/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.history;

import java.util.Arrays;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.osee.ats.ide.editor.tab.workflow.history.XHistoryViewer;
import org.eclipse.osee.ats.ide.editor.tab.workflow.history.operations.LoadChangesOperation;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationBuilder;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public final class HistoryRefreshAction
extends Action {
    private final XHistoryViewer xHistoryViewer;

    public HistoryRefreshAction(String text, int style, XHistoryViewer xHistoryViewer) {
        super(text, style);
        this.xHistoryViewer = xHistoryViewer;
        this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)PluginUiImage.REFRESH));
        this.setToolTipText("Refresh History");
    }

    public void run() {
        this.setEnabled(false);
        this.setToolTipText("Already Loading, Please Wait");
        this.xHistoryViewer.getXViewer().setInput(Arrays.asList("Loading..."));
        OperationBuilder builder = Operations.createBuilder((String)"Load History Viewer");
        builder.addOp((IOperation)new LoadChangesOperation(this.xHistoryViewer.awa, this.xHistoryViewer.changes));
        Operations.executeAsJob((IOperation)builder.build(), (boolean)true, (int)30, (IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus result = event.getResult();
                if (!result.isOK()) {
                    HistoryRefreshAction.this.setEnabled(true);
                } else {
                    UIJob job = new UIJob("Load History Table"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                try {
                                    if (Widgets.isAccessible((Widget)(this).HistoryRefreshAction.this.xHistoryViewer.getXViewer().getTree())) {
                                        (this).HistoryRefreshAction.this.xHistoryViewer.getXViewer().setInput((this).HistoryRefreshAction.this.xHistoryViewer.changes);
                                    }
                                }
                                catch (Exception ex) {
                                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                                    HistoryRefreshAction.this.setEnabled(true);
                                    HistoryRefreshAction.this.setToolTipText("Refresh History");
                                }
                            }
                            finally {
                                HistoryRefreshAction.this.setEnabled(true);
                                HistoryRefreshAction.this.setToolTipText("Refresh History");
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    Operations.scheduleJob((Job)job, (boolean)true, (int)20, null);
                }
            }
        });
    }
}

