/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.header;

import java.text.NumberFormat;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.core.util.PercentCompleteTotalUtil;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.IntegerDialog;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WfePercentCompleteHeader
extends Composite {
    private static final String PERCENT_COMPLETE = "Percent Complete:";
    private final String LABEL_TOOL_TIP = "[Workflow Percent] | [Calculation: Sum of percent for workflow, reviews and tasks / # workflows, reviews and tasks]";
    private final String LINK_TOOL_TIP = "Select to set percent of workflow complete.";
    Label valueLabel;
    private final IAtsWorkItem workItem;

    public WfePercentCompleteHeader(Composite parent, int style, final IAtsWorkItem workItem, final WorkflowEditor editor) {
        super(parent, style);
        this.workItem = workItem;
        this.setLayoutData(new GridData(4, 0, true, false));
        this.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        try {
            if (!workItem.isCancelled() && !workItem.isCompleted()) {
                Hyperlink link = editor.getToolkit().createHyperlink((Composite)this, PERCENT_COMPLETE, 0);
                link.setToolTipText("Select to set percent of workflow complete.");
                link.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            if (editor.isDirty()) {
                                editor.doSave(null);
                            }
                            IntegerDialog dialog = new IntegerDialog("Enter Percent Complete", "Enter Percent Complete (0 to 99)\n\n(use Transition to mark complete.)", 0, 99);
                            dialog.setNumberFormat(NumberFormat.getIntegerInstance());
                            int percent = 0;
                            if (workItem.getStateMgr().getPercentCompleteValue() != null) {
                                percent = workItem.getStateMgr().getPercentCompleteValue();
                            }
                            dialog.setEntry(String.valueOf(percent));
                            if (dialog.open() == 0) {
                                Integer intValue = dialog.getInt();
                                workItem.getStateMgr().setPercentCompleteValue(intValue);
                                AtsApiService.get().getStoreService().executeChangeSet("ATS Workflow Editor - set Percent Complete", (IAtsObject)workItem);
                            }
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                        }
                    }
                });
            } else {
                Label origLabel = editor.getToolkit().createLabel((Composite)this, PERCENT_COMPLETE);
                origLabel.setLayoutData((Object)new GridData());
            }
            this.valueLabel = editor.getToolkit().createLabel((Composite)this, "0");
            this.valueLabel.setToolTipText("[Workflow Percent] | [Calculation: Sum of percent for workflow, reviews and tasks / # workflows, reviews and tasks]");
            this.valueLabel.setLayoutData((Object)new GridData());
            this.refresh();
        }
        catch (OseeCoreException ex) {
            Label errorLabel = editor.getToolkit().createLabel((Composite)this, "Error: " + ex.getLocalizedMessage());
            errorLabel.setForeground(Displays.getSystemColor((int)3));
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public String getPercentCompleteStr() {
        int totalPecent;
        int awaPercent = (Integer)AtsApiService.get().getAttributeResolver().getSoleAttributeValue((IAtsObject)this.workItem, (AttributeTypeToken)AtsAttributeTypes.PercentComplete, (Object)0);
        if (awaPercent != (totalPecent = PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)this.workItem, (AtsApi)AtsApiService.get()))) {
            return String.format("%d | %d", awaPercent, totalPecent);
        }
        return String.valueOf(awaPercent);
    }

    public void refresh() {
        this.valueLabel.setText(this.getPercentCompleteStr());
        this.valueLabel.getParent().layout(true);
        this.valueLabel.getParent().getParent().layout(true);
    }
}

