/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.reload;

import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.RecentlyVisitedNavigateItems;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ExceptionComposite;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WfeReloadTab
extends FormPage {
    private IManagedForm managedForm;
    private Composite bodyComp;
    public static final String ID = "ats.reload.tab";
    private final WorkflowEditor editor;
    private final String title;
    private final BranchId branch;
    private Button reloadButton;
    private boolean reloading = false;

    public WfeReloadTab(WorkflowEditor editor) {
        super((FormEditor)editor, ID, "Reload");
        this.editor = editor;
        this.title = editor.getWfeInput().getSavedTitle();
        this.branch = editor.getWfeInput().getBranchId();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.managedForm = managedForm;
        try {
            this.updateTitleBar();
            this.bodyComp = managedForm.getForm().getBody();
            this.bodyComp.setLayout((Layout)new GridLayout(1, false));
            this.bodyComp.setLayoutData((Object)new GridData(16384, 16384, true, false));
            if (AtsApiService.get().getAtsBranch().notEqual((Id)this.branch)) {
                Label imageLabel = new Label(this.bodyComp, 0);
                imageLabel.setLayoutData((Object)new GridData(4, 1, false, true));
                Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                imageLabel.setImage(image);
                imageLabel.setBackground(Displays.getSystemColor((int)25));
                imageLabel.setText("Saved item not on currently configured ATS Branch.  Unable to reload.");
            } else {
                this.reloadButton = new Button(this.bodyComp, 8);
                this.reloadButton.setText("Reload");
                this.reloadButton.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.REFRESH));
                this.reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (WfeReloadTab.this.reloading) {
                            AWorkbench.popup((String)"Editor Reloading...");
                        } else {
                            WfeReloadTab.this.reloading = true;
                            WfeReloadTab.this.reloadEditor();
                        }
                    }
                });
            }
            FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void handleException(Exception ex) {
        if (Widgets.isAccessible((Widget)this.bodyComp)) {
            this.bodyComp.dispose();
        }
        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        new ExceptionComposite(this.bodyComp, ex);
        this.bodyComp.layout();
    }

    private void updateTitleBar() {
        String displayableTitle = Strings.escapeAmpersands((String)this.title);
        if (this.managedForm != null && Widgets.isAccessible((Widget)this.managedForm.getForm())) {
            this.managedForm.getForm().setText(displayableTitle);
            this.managedForm.getForm().setImage(ImageManager.getImage((OseeImage)AtsImage.WORKFLOW));
        }
        this.setPartName(displayableTitle);
    }

    public void showBusy(boolean busy) {
        super.showBusy(busy);
        IManagedForm managedForm = this.getManagedForm();
        if (managedForm != null && Widgets.isAccessible((Widget)this.getManagedForm().getForm())) {
            this.getManagedForm().getForm().getForm().setBusy(busy);
        }
    }

    private void reloadEditor() {
        LoadAndRefreshJob loadAndRefresh = new LoadAndRefreshJob(this.title);
        Jobs.startJob((Job)loadAndRefresh, (boolean)true);
    }

    public void reloadEditor(String title) {
        LoadAndRefreshJob loadAndRefresh = new LoadAndRefreshJob(title);
        Jobs.startJob((Job)loadAndRefresh, (boolean)true);
    }

    public Button getReloadButtion() {
        return this.reloadButton;
    }

    private class LoadAndRefreshJob
    extends Job {
        public LoadAndRefreshJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            final int currentPage = WfeReloadTab.this.editor.getActivePage();
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    IManagedForm managedForm;
                    if (Widgets.isAccessible((Widget)((LoadAndRefreshJob)LoadAndRefreshJob.this).WfeReloadTab.this.editor.getReloadButton())) {
                        ((LoadAndRefreshJob)LoadAndRefreshJob.this).WfeReloadTab.this.editor.getReloadButton().setText("Reloading...");
                        ((LoadAndRefreshJob)LoadAndRefreshJob.this).WfeReloadTab.this.editor.getReloadButton().getParent().layout(true);
                    }
                    if ((managedForm = WfeReloadTab.this.getManagedForm()) != null && Widgets.isAccessible((Widget)WfeReloadTab.this.getManagedForm().getForm())) {
                        WfeReloadTab.this.getManagedForm().getForm().getForm().setBusy(true);
                    }
                }
            });
            Thread reload = new Thread(new Runnable(){

                @Override
                public void run() {
                    AbstractWorkflowArtifact workItem = ((LoadAndRefreshJob)LoadAndRefreshJob.this).WfeReloadTab.this.editor.getWorkItem();
                    if (workItem == null) {
                        workItem = AtsApiService.get().getWorkItemService().getWorkItem(((LoadAndRefreshJob)LoadAndRefreshJob.this).WfeReloadTab.this.editor.getWfeInput().getSavedArtUuid().getId());
                    }
                    if (workItem == null) {
                        AWorkbench.popup((String)"Can't reload editor.");
                        ((LoadAndRefreshJob)LoadAndRefreshJob.this).WfeReloadTab.this.editor.closeEditor();
                        return;
                    }
                    final Artifact artifact = (Artifact)workItem.getStoreObject();
                    try {
                        artifact.isReadOnly();
                    }
                    catch (Exception exception) {}
                    final AbstractWorkflowArtifact fWorkItem = workItem;
                    Displays.ensureInDisplayThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ((LoadAndRefreshJob)(this).LoadAndRefreshJob.this).WfeReloadTab.this.editor.getWfeInput().setArtifact(artifact);
                            ((LoadAndRefreshJob)(this).LoadAndRefreshJob.this).WfeReloadTab.this.editor.disposeTabs();
                            ((LoadAndRefreshJob)(this).LoadAndRefreshJob.this).WfeReloadTab.this.editor.loadPages();
                            ((LoadAndRefreshJob)(this).LoadAndRefreshJob.this).WfeReloadTab.this.editor.setPage(currentPage);
                            RecentlyVisitedNavigateItems.addVisited(fWorkItem);
                        }
                    });
                }
            });
            reload.start();
            return Status.OK_STATUS;
        }
    }
}

