/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.version;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class MassEditTeamVersionItem
extends XNavigateItemAction {
    private IAtsTeamDefinition selectedTeamDef;

    public MassEditTeamVersionItem(String name, KeyedImage oseeImage) {
        super(name, oseeImage, new XNavItemCat[]{AtsNavigateViewItems.ATS_VERSIONS_ADMIN});
    }

    public MassEditTeamVersionItem(String name, AtsImage oseeImage) {
        super(name, (OseeImage)oseeImage, new XNavItemCat[]{AtsNavigateViewItems.ATS_VERSIONS_ADMIN});
    }

    private IAtsTeamDefinition getTeamDefinition() {
        if (this.selectedTeamDef != null) {
            return this.selectedTeamDef;
        }
        TeamDefinitionDialog dialog = new TeamDefinitionDialog();
        dialog.setInput(AtsApiService.get().getTeamDefinitionService().getTeamReleaseableDefinitions(Active.Active));
        int result = dialog.open();
        if (result == 0) {
            return (IAtsTeamDefinition)dialog.getSelectedFirst();
        }
        return null;
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        try {
            this.selectedTeamDef = this.getTeamDefinition();
            if (this.selectedTeamDef == null) {
                return;
            }
            final IAtsTeamDefinition fTeamDef = this.selectedTeamDef;
            Job signJob = new Job("Load Team Versions"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (AtsApiService.get().getTeamDefinitionService().getTeamDefHoldingVersions(fTeamDef) == null) {
                        AWorkbench.popup((String)"ERROR", (String)"Team is not configured to use versions.");
                        return Status.CANCEL_STATUS;
                    }
                    List<Artifact> versions = MassEditTeamVersionItem.this.getResults(fTeamDef);
                    MassArtifactEditor.editArtifacts((String)this.getName(), versions, (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[0]);
                    return Status.OK_STATUS;
                }
            };
            Operations.scheduleJob((Job)signJob, (boolean)false, (int)20, null);
            this.selectedTeamDef = null;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public List<Artifact> getResults(IAtsTeamDefinition fTeamDef) {
        Collection related = AtsApiService.get().getRelationResolver().getRelated((IAtsObject)fTeamDef, AtsRelationTypes.TeamDefinitionToVersion_Version);
        return Collections.castAll((Collection)related);
    }

    public void setSelectedTeamDef(IAtsTeamDefinition selectedTeamDef) {
        this.selectedTeamDef = selectedTeamDef;
    }
}

