/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class OperationalImpactWorkaroundColumn
extends XViewerValueColumn {
    public static OperationalImpactWorkaroundColumn instance = new OperationalImpactWorkaroundColumn();

    public static OperationalImpactWorkaroundColumn getInstance() {
        return instance;
    }

    private OperationalImpactWorkaroundColumn() {
        super("ats.Operational Impact Workaround", "Operational Impact Workaround", 80, XViewerAlign.Left, false, SortDataType.String, true, "Does operational impact to the product have a workaround?");
    }

    public OperationalImpactWorkaroundColumn copy() {
        OperationalImpactWorkaroundColumn newXCol = new OperationalImpactWorkaroundColumn();
        super.copy((XViewerColumn)this, (XViewerColumn)newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        if (AtsObjects.isAtsWorkItemOrAction((Object)element)) {
            try {
                return this.getOperationalImpact(AtsApiService.get().getQueryServiceIde().getArtifact(element));
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                return LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
        return "";
    }

    private String getOperationalImpact(Artifact art) {
        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            return (String)((TeamWorkFlowArtifact)art).getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.OperationalImpactWorkaround, "");
        }
        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            HashSet<String> strs = new HashSet<String>();
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)art)) {
                strs.add(this.getOperationalImpact(AtsApiService.get().getQueryServiceIde().getArtifact(team)));
            }
            return Collections.toString((String)", ", strs);
        }
        if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
            return this.getOperationalImpact(((TaskArtifact)art).getParentTeamWorkflow());
        }
        return "";
    }
}

