/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class TestRunSessionSerializer
implements XMLReader {
    private static final String EMPTY = "";
    private static final String CDATA = "CDATA";
    private static final Attributes NO_ATTS = new AttributesImpl();
    private final TestRunSession fTestRunSession;
    private ContentHandler fHandler;
    private ErrorHandler fErrorHandler;
    private final NumberFormat timeFormat = new DecimalFormat("0.0##", new DecimalFormatSymbols(Locale.US));

    public TestRunSessionSerializer(TestRunSession testRunSession) {
        Assert.isNotNull((Object)testRunSession);
        this.fTestRunSession = testRunSession;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        if (this.fHandler == null) {
            throw new SAXException("ContentHandler missing");
        }
        this.fHandler.startDocument();
        this.handleTestRun();
        this.fHandler.endDocument();
    }

    private void handleTestRun() throws SAXException {
        ITestElement[] topSuites;
        String excludeTags;
        AttributesImpl atts = new AttributesImpl();
        TestRunSessionSerializer.addCDATA(atts, "name", this.fTestRunSession.getTestRunName());
        IJavaProject project = this.fTestRunSession.getLaunchedProject();
        if (project != null) {
            TestRunSessionSerializer.addCDATA(atts, "project", project.getElementName());
        }
        TestRunSessionSerializer.addCDATA(atts, "tests", this.fTestRunSession.getTotalCount());
        TestRunSessionSerializer.addCDATA(atts, "started", this.fTestRunSession.getStartedCount());
        TestRunSessionSerializer.addCDATA(atts, "failures", this.fTestRunSession.getFailureCount());
        TestRunSessionSerializer.addCDATA(atts, "errors", this.fTestRunSession.getErrorCount());
        TestRunSessionSerializer.addCDATA(atts, "ignored", this.fTestRunSession.getIgnoredCount());
        String includeTags = this.fTestRunSession.getIncludeTags();
        if (includeTags != null && !includeTags.trim().isEmpty()) {
            TestRunSessionSerializer.addCDATA(atts, "include_tags", includeTags);
        }
        if ((excludeTags = this.fTestRunSession.getExcludeTags()) != null && !excludeTags.trim().isEmpty()) {
            TestRunSessionSerializer.addCDATA(atts, "exclude_tags", excludeTags);
        }
        this.startElement("testrun", atts);
        TestRoot testRoot = this.fTestRunSession.getTestRoot();
        ITestElement[] iTestElementArray = topSuites = testRoot.getChildren();
        int n = topSuites.length;
        int n2 = 0;
        while (n2 < n) {
            ITestElement topSuite = iTestElementArray[n2];
            this.handleTestElement(topSuite);
            ++n2;
        }
        this.endElement("testrun");
    }

    private void handleTestElement(ITestElement testElement) throws SAXException {
        if (testElement instanceof TestSuiteElement) {
            ITestElement[] children;
            String[] paramTypes;
            TestSuiteElement testSuiteElement = (TestSuiteElement)testElement;
            AttributesImpl atts = new AttributesImpl();
            TestRunSessionSerializer.addCDATA(atts, "name", testSuiteElement.getTestName());
            if (!Double.isNaN(testSuiteElement.getElapsedTimeInSeconds())) {
                TestRunSessionSerializer.addCDATA(atts, "time", this.timeFormat.format(testSuiteElement.getElapsedTimeInSeconds()));
            }
            if (testElement.getProgressState() != ITestElement.ProgressState.COMPLETED || testElement.getTestResult(false) != ITestElement.Result.UNDEFINED) {
                TestRunSessionSerializer.addCDATA(atts, "incomplete", Boolean.TRUE.toString());
            }
            if (testSuiteElement.getDisplayName() != null) {
                TestRunSessionSerializer.addCDATA(atts, "displayname", testSuiteElement.getDisplayName());
            }
            if ((paramTypes = testSuiteElement.getParameterTypes()) != null) {
                String paramTypesStr = Arrays.stream(paramTypes).collect(Collectors.joining(","));
                TestRunSessionSerializer.addCDATA(atts, "parameters", paramTypesStr);
            }
            if (testSuiteElement.getUniqueId() != null) {
                TestRunSessionSerializer.addCDATA(atts, "uniqueid", testSuiteElement.getUniqueId());
            }
            this.startElement("testsuite", atts);
            this.addFailure(testSuiteElement);
            ITestElement[] iTestElementArray = children = testSuiteElement.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ITestElement child = iTestElementArray[n2];
                this.handleTestElement(child);
                ++n2;
            }
            this.endElement("testsuite");
        } else if (testElement instanceof TestCaseElement) {
            String[] paramTypes;
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            AttributesImpl atts = new AttributesImpl();
            TestRunSessionSerializer.addCDATA(atts, "name", testCaseElement.getTestMethodName());
            TestRunSessionSerializer.addCDATA(atts, "classname", testCaseElement.getClassName());
            if (!Double.isNaN(testCaseElement.getElapsedTimeInSeconds())) {
                TestRunSessionSerializer.addCDATA(atts, "time", this.timeFormat.format(testCaseElement.getElapsedTimeInSeconds()));
            }
            if (testElement.getProgressState() != ITestElement.ProgressState.COMPLETED) {
                TestRunSessionSerializer.addCDATA(atts, "incomplete", Boolean.TRUE.toString());
            }
            if (testCaseElement.isIgnored()) {
                TestRunSessionSerializer.addCDATA(atts, "ignored", Boolean.TRUE.toString());
            }
            if (testCaseElement.isDynamicTest()) {
                TestRunSessionSerializer.addCDATA(atts, "dynamicTest", Boolean.TRUE.toString());
            }
            if (testCaseElement.getDisplayName() != null) {
                TestRunSessionSerializer.addCDATA(atts, "displayname", testCaseElement.getDisplayName());
            }
            if ((paramTypes = testCaseElement.getParameterTypes()) != null) {
                String paramTypesStr = Arrays.stream(paramTypes).collect(Collectors.joining(","));
                TestRunSessionSerializer.addCDATA(atts, "parameters", paramTypesStr);
            }
            if (testCaseElement.getUniqueId() != null) {
                TestRunSessionSerializer.addCDATA(atts, "uniqueid", testCaseElement.getUniqueId());
            }
            this.startElement("testcase", atts);
            this.addFailure(testCaseElement);
            this.endElement("testcase");
        } else {
            throw new IllegalStateException(String.valueOf(testElement));
        }
    }

    private void addFailure(TestElement testElement) throws SAXException {
        ITestElement.FailureTrace failureTrace = testElement.getFailureTrace();
        if (testElement.isAssumptionFailure()) {
            this.startElement("skipped", NO_ATTS);
            if (failureTrace != null) {
                this.addCharacters(failureTrace.getTrace());
            }
            this.endElement("skipped");
        } else if (failureTrace != null) {
            AttributesImpl failureAtts = new AttributesImpl();
            String failureKind = testElement.getTestResult(false) == ITestElement.Result.ERROR ? "error" : "failure";
            this.startElement(failureKind, failureAtts);
            String expected = failureTrace.getExpected();
            String actual = failureTrace.getActual();
            if (expected != null) {
                this.startElement("expected", NO_ATTS);
                this.addCharacters(expected);
                this.endElement("expected");
            }
            if (actual != null) {
                this.startElement("actual", NO_ATTS);
                this.addCharacters(actual);
                this.endElement("actual");
            }
            String trace = failureTrace.getTrace();
            this.addCharacters(trace);
            this.endElement(failureKind);
        }
    }

    private void startElement(String name, Attributes atts) throws SAXException {
        this.fHandler.startElement(EMPTY, name, name, atts);
    }

    private void endElement(String name) throws SAXException {
        this.fHandler.endElement(EMPTY, name, name);
    }

    private static void addCDATA(AttributesImpl atts, String name, int value) {
        TestRunSessionSerializer.addCDATA(atts, name, Integer.toString(value));
    }

    private static void addCDATA(AttributesImpl atts, String name, String value) {
        atts.addAttribute(EMPTY, EMPTY, name, CDATA, value);
    }

    private void addCharacters(String string) throws SAXException {
        string = TestRunSessionSerializer.escapeNonUnicodeChars(string);
        this.fHandler.characters(string.toCharArray(), 0, string.length());
    }

    private static String escapeNonUnicodeChars(String string) {
        StringBuffer buf = null;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (ch != '\t' && ch != '\n' && ch != '\r' && ch < ' ') {
                if (buf == null) {
                    buf = new StringBuffer(string.substring(0, i));
                }
                buf.append("\\u");
                String hex = Integer.toHexString(ch);
                int j = hex.length();
                while (j < 4) {
                    buf.append('0');
                    ++j;
                }
                buf.append(hex);
            } else if (buf != null) {
                buf.append(ch);
            }
            ++i;
        }
        if (buf != null) {
            return buf.toString();
        }
        return string;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.fHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.fHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.fErrorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setFeature(String name, boolean value) {
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }
}

