/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeServerContext;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.core.model.type.LinkType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.HttpUrlBuilder;
import org.eclipse.osee.framework.jdk.core.util.xml.Xml;

public class OseeLinkBuilder {
    private static final String WORDML_INTERNAL_DOC_LINK_FORMAT = "<w:r><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:instrText> HYPERLINK \\l \"OSEE.%s\" </w:instrText></w:r><w:r><w:fldChar w:fldCharType=\"separate\"/></w:r><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>%s</w:t></w:r><w:r><w:fldChar w:fldCharType=\"end\"/></w:r>";
    private static final String WORDML_INTERNAL_DOC_REFERENCE_FORMAT = "<w:r><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:instrText> REF OSEE.%s \\h %s</w:instrText></w:r><w:r><w:fldChar w:fldCharType=\"separate\"/></w:r><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>Sec#</w:t></w:r><w:r><w:fldChar w:fldCharType=\"end\"/></w:r><w:r><w:t> %s</w:t></w:r>";
    private static final String WORDML_LINK_FORMAT = "<w:hlink w:dest=\"%s\"><w:r><w:rPr><w:rStyle w:val=\"Hyperlink\"/></w:rPr><w:t>%s</w:t></w:r></w:hlink>";
    private static final String WORDML_BOOKMARK_FORMAT = "<aml:annotation aml:id=\"%s\" w:type=\"Word.Bookmark.Start\" w:name=\"OSEE.%s\"/><aml:annotation aml:id=\"%s\" w:type=\"Word.Bookmark.End\"/>";
    private static final String OSEE_LINK_MARKER = "OSEE_LINK(%s)";
    public static String START_BIN_DATA = "/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAAUAEcDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDuI/HV3L4l1XTJvEnhmwtrKK1aC5uYSRd+bEHZkzcKNoPTBbhhz3Ol478fWvhjR9TFhcW0us2awt9nmRmQeY4AViMDcU3sF3bsKWxgGix0bxLpfi3Xtahs9JnTVltSYnv5IzC0UW1hkQncMk4PHAHHOBleLPh/rWrz+Kv7Nu9PWHXls2b7TvDRtAcbPlBGCAG3c9Nu3ncPfhHBSxEPaWUEovdav3OZOyv/ADPXe2ljJ81nY0ta8fjw7N4nluxDdw6V9mWC2tYpRKryoSBM5GxVJxhlzgcHLEA9pBMtxBHMgcJIodRIhRgCM8qwBB9iARXAa98P9Q1l/G4W7tok11bI2pO4lWgAyHGOASAMjOAc44wen/4S/wAPwfub/XtGtryP5Z4P7QjPlyDhlycHg5HIB9hXHiKNGdOH1dXlpe3+GHS383N+vQpN31ObtPGOsap4k1fSrW40azvrG+8iHS7+OVJbqEYPmLKG/iUOwxG2BtzkHJ2bfxxp0/iHW9KeG5hGkrF5k0kD4kdyRtUbckk7Ao6yFjtBAycbxb4O1jxRJIj2+jRTx3Mb2OswySxXdrErBsbAp3sMvj94qkkHCkVY1Hwjrp1Xxbd6RqcNpJrltbiG4ywkt5Yl2bcAH5WXPzghlJ4U4zXTKGCqRV2otpddneN3dJ3VuZ6rmVnvoT7yNh/G3h+LTdQv5r14YdOZEu1mtpY5YS+Nm6NlD4bcMHGDz6GoLTxvY33i+Hw9BZ6gsslm90ZZ7OWELhgoG10Bwfm+Y4XIABJOBx0vww1N9D8WWNpBpOnJqy2KWlvDcSSRwiAjducxgktjOcEkk59a7WXw/dj4jW/iSGSF7ZtMbT54nYq6fvPMV1wCGyeCDtx1yelZ1KGAgpcsm3Z21W/LFrZd3Jb20GnNnR0UUV45oFFFFABRRRQAUUUUAFFFFABRRRQB/9k=";
    public static final String END_BIN_DATA = "/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAgGBgcGBQgHBwcJCQgKDBQNDAsLDBkSEw8UHRofHh0aHBwgJC4nICIsIxwcKDcpLDAxNDQ0Hyc5PTgyPC4zNDL/2wBDAQkJCQwLDBgNDRgyIRwhMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjIyMjL/wAARCAAUAEcDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD1jUPE2oR+NF8NabpdtcTf2f8Ab2mubxoVC+YY9uFjck5wf886s2t6fYIE1XUNPsrpIFnmie6UCNSQu7LbSV3naGIGTjoeK5HxB4emufiUmsXXhn+29KGji1CYt32zecWztldei55H9761V17wjfal4hvL210VI7U+EpbCzjYxAwXLFgsYAbCkIxXI+XBIzivYWGwk1BOSj7t3qt+2r0+5fMzvJXO11/XrTQNMubmaSFrmO2muILV5gj3HlIXYLnk8DkgHGc1Pouo/2xoOnan5Xk/bLaO48vdu2b1DYzgZxnrivMdQ8E681ra7dJhvDJ4QXSHiedB5FyhVwWzweR8pXPzKMlR8w9H8MWc+neE9GsbqPy7m2sYIZUyDtdY1BGRweQelY4rD4elh04TUpX79PS44tt6mUnifVb3xVrWiaZpFlL/ZXkeZNc37Rb/NTeMKsT9MEdfSp/GHi+08J6Je3mIbq8tokm+w/aAkjRtKse/oSFy3XGMjFc3J4cdPH/iXU9T8Hf21Z332X7HJttZNuyLa/EsilcnHbnb9KyvG/gnXtSuvGH2HSYb4av8AYJrSUzovktCNjgbuQ+CfQbWb5s/KeylhcFOvTUpJRtBvXdvk5k3zabyb0VrNIlykkzstT8c2OhTa62rrDBaaZ5IieO6SWW5eRC2zyh8yNxxu6jLcAEjpoJ4rmCOeCVJYZVDxyRsGV1IyCCOCCO9eZeJfBeuas/xCW2tkA1ZbBrFnlUCYwgF165U5GBuwMkc45r02CRpYI5HheF3UM0UhBZCR907SRkdOCR7muHF0sPClCVJ+87X1/uQe3q5J+a6bFRbvqSUUUV55YUUUUAFZV54Y8P6jdPdX2h6Zc3MmN809pG7tgYGSRk8AD8KKKuFScHeDt6Ba5owQRW0EcEESRQxKEjjjUKqKBgAAcAAdqkooqG76sAooooAKKKKAP//Z";
    private static final String PIC_TAG_DATA = "<w:r><w:pict><v:shapetype id=\"_x0000_t75\" coordsize=\"21600,21600\" o:spt=\"75\" o:preferrelative=\"t\" path=\"m@4@5l@4@11@9@11@9@5xe\" filled=\"f\" stroked=\"f\"><v:stroke joinstyle=\"miter\"/><v:formulas><v:f eqn=\"if lineDrawn pixelLineWidth 0\"/><v:f eqn=\"sum @0 1 0\"/><v:f eqn=\"sum 0 0 @1\"/><v:f eqn=\"prod @2 1 2\"/><v:f eqn=\"prod @3 21600 pixelWidth\"/><v:f eqn=\"prod @3 21600 pixelHeight\"/><v:f eqn=\"sum @0 0 1\"/><v:f eqn=\"prod @6 1 2\"/><v:f eqn=\"prod @7 21600 pixelWidth\"/><v:f eqn=\"sum @8 21600 0\"/><v:f eqn=\"prod @7 21600 pixelHeight\"/><v:f eqn=\"sum @10 21600 0\"/></v:formulas><v:path o:extrusionok=\"f\" gradientshapeok=\"t\" o:connecttype=\"rect\"/><o:lock v:ext=\"edit\" aspectratio=\"t\"/></v:shapetype><w:binData w:name=\"wordml://%s\">%s</w:binData><v:shape id=\"_x0000_i1025\" type=\"#_x0000_t75\" style=\"width:53.25pt;height:15pt\"><v:imagedata src=\"wordml://%s\" o:title=\"%s\"/></v:shape></w:pict></w:r>";

    public String getUnknownArtifactLink(String guid, BranchId branch) {
        String message = String.format("Invalid Link: artifact with guid:[%s] on branchUuid:[%s] does not exist", guid, branch);
        String internalLink = String.format("http://none/unknown?guid=%s&amp;branchUuid=%s", guid, branch);
        return String.format(WORDML_LINK_FORMAT, internalLink, message);
    }

    public String getWordMlBookmark(ArtifactReadable source) {
        return this.getWordMlBookmark(source.getIdString());
    }

    public String getWordMlBookmark(String uuid) {
        return String.format(WORDML_BOOKMARK_FORMAT, 0, uuid, 0);
    }

    public String getStartEditImage(String guid) {
        return this.getEditImage(true, guid);
    }

    public String getEndEditImage(String guid) {
        return this.getEditImage(false, guid);
    }

    private String getEditImage(boolean isStart, String guid) {
        String imageId = String.format("%s_%s", guid, isStart ? "START.jpg" : "END.jpg");
        String imageData = isStart ? START_BIN_DATA : END_BIN_DATA;
        return String.format(PIC_TAG_DATA, imageId, imageData, imageId, guid);
    }

    public String getOseeLinkMarker(String guid) {
        return String.format(OSEE_LINK_MARKER, guid);
    }

    public String getWordMlLink(LinkType destLinkType, ArtifactReadable artifact, TransactionId txId, String permanentUrl) {
        return this.getWordMlLink(destLinkType, artifact, txId, PresentationType.DEFAULT_OPEN, permanentUrl);
    }

    public String getWordMlLink(LinkType destLinkType, ArtifactReadable artifact, TransactionId txId, PresentationType presentationType, String permanentUrl) {
        String linkFormat = this.getLinkFormat(destLinkType);
        String linkId = this.getLinkId(destLinkType, artifact, txId, presentationType, permanentUrl);
        String linkText = this.getLinkText(destLinkType, artifact);
        return String.format(linkFormat, linkId, linkText);
    }

    public String getWordMlReference(String linkId, boolean addParagraphNumber, String linkText) {
        String paragraphNumSwitch = addParagraphNumber ? "\\n " : "";
        return String.format(WORDML_INTERNAL_DOC_REFERENCE_FORMAT, linkId, paragraphNumSwitch, linkText);
    }

    private String getLinkFormat(LinkType destLinkType) {
        String toReturn = destLinkType == LinkType.OSEE_SERVER_LINK ? WORDML_LINK_FORMAT : WORDML_INTERNAL_DOC_LINK_FORMAT;
        return toReturn;
    }

    private String getLinkId(LinkType destLinkType, ArtifactReadable artifact, TransactionId tx, PresentationType presentationType, String permanentUrl) {
        String toReturn = destLinkType == LinkType.OSEE_SERVER_LINK ? this.escapeXml(this.getOseeLink(artifact, presentationType, permanentUrl)) : artifact.getIdString();
        return toReturn;
    }

    private String getOseeLink(ArtifactReadable artifact, PresentationType presentationType, String permanentUrl) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("guid", artifact.getGuid());
        parameters.put("uuid", artifact.getIdString());
        parameters.put("branchUuid", artifact.getBranch().getIdString());
        parameters.put("isDeleted", String.valueOf(artifact.isDeleted()));
        if (artifact.isHistorical() && presentationType != PresentationType.DIFF && presentationType != PresentationType.F5_DIFF) {
            parameters.put("transactionId", String.valueOf(artifact.getTransaction()));
        }
        parameters.put("cmd", "open.artifact");
        URL url = null;
        try {
            String urlString = HttpUrlBuilder.createURL((String)permanentUrl, (String)OseeServerContext.CLIENT_LOOPBACK_CONTEXT, parameters);
            url = new URL(urlString);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return url.toString();
    }

    private String getLinkText(LinkType linkType, ArtifactReadable artifact) {
        StringBuilder builder = new StringBuilder();
        if (this.isParagraphRequired(linkType)) {
            builder.append((String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, (Object)"Undefined"));
        }
        if (this.isArtifactNameRequired(linkType)) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append((String)artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Name, DeletionFlag.INCLUDE_DELETED, (Object)""));
        }
        if (artifact.isDeleted()) {
            builder.append(" (DELETED)");
        }
        return this.escapeXml(builder.toString());
    }

    private boolean isParagraphRequired(LinkType linkType) {
        return linkType == LinkType.INTERNAL_DOC_REFERENCE_USE_PARAGRAPH_NUMBER || linkType == LinkType.INTERNAL_DOC_REFERENCE_USE_PARAGRAPH_NUMBER_AND_NAME;
    }

    private boolean isArtifactNameRequired(LinkType linkType) {
        return linkType == LinkType.OSEE_SERVER_LINK || linkType == LinkType.INTERNAL_DOC_REFERENCE_USE_NAME || linkType == LinkType.INTERNAL_DOC_REFERENCE_USE_PARAGRAPH_NUMBER_AND_NAME;
    }

    private String escapeXml(String source) {
        return Xml.escape((CharSequence)source).toString();
    }
}

