/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTextView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    NSScrollView scrollView;
    String text;
    Point[] offsets;
    String[] ids;
    int[] mnemonics;
    double[] linkForeground;
    NSColor defaultLinkColor;
    int focusIndex;
    boolean ignoreNextMouseUp;

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int width = 0;
        int height = 0;
        NSLayoutManager layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
        NSTextContainer textContainer = (NSTextContainer)new NSTextContainer().alloc();
        NSSize size = new NSSize();
        size.height = 5000000.0;
        size.width = 5000000.0;
        if (wHint != -1) {
            size.width = wHint;
        }
        if (hHint != -1) {
            size.height = hHint;
        }
        textContainer.initWithContainerSize(size);
        textContainer.setLineFragmentPadding(2.0);
        layoutManager.addTextContainer(textContainer);
        NSTextStorage textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
        textStorage.setAttributedString(((NSTextView)this.view).textStorage());
        layoutManager.setTextStorage(textStorage);
        layoutManager.glyphRangeForTextContainer(textContainer);
        NSRect rect = layoutManager.usedRectForTextContainer(textContainer);
        width = layoutManager.numberOfGlyphs() == 0L ? 64 : (int)Math.ceil(rect.width);
        height = (int)Math.ceil(rect.height);
        textStorage.release();
        textContainer.release();
        layoutManager.release();
        if (width <= 0) {
            width = 64;
        }
        if (height <= 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        size.width = width;
        size.height = height;
        int border = this.hasBorder() ? 2 : 0;
        size = NSScrollView.frameSizeForContentSize(size, false, false, border);
        width = (int)size.width;
        height = (int)size.height;
        if (!this.hasBorder()) {
            width += 2;
            height += 2;
        }
        return new Point(width, height);
    }

    @Override
    void createHandle() {
        this.state |= 0x800;
        NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
        scrollWidget.init();
        scrollWidget.setDrawsBackground(false);
        scrollWidget.setAutoresizesSubviews(true);
        scrollWidget.setBorderType(this.hasBorder() ? 2 : 0);
        scrollWidget.setVerticalScrollElasticity(1L);
        NSTextView widget = (NSTextView)new SWTTextView().alloc();
        widget.init();
        widget.setEditable(false);
        NSSize size = new NSSize();
        size.height = 3.4028234663852886E38;
        size.width = 3.4028234663852886E38;
        widget.setMaxSize(size);
        widget.setDisplaysLinkToolTips(false);
        widget.setDrawsBackground(false);
        widget.setDelegate(widget);
        widget.setAutoresizingMask(18L);
        widget.textContainer().setLineFragmentPadding(2.0);
        widget.setFont(this.getFont().handle);
        widget.setAlignment(0L);
        NSMutableDictionary dict = NSMutableDictionary.dictionaryWithCapacity(4L);
        dict.setDictionary(widget.selectedTextAttributes());
        dict.removeObjectForKey(OS.NSBackgroundColorAttributeName);
        dict.setObject(NSCursor.arrowCursor(), OS.NSCursorAttributeName);
        widget.setSelectedTextAttributes(dict);
        this.scrollView = scrollWidget;
        this.view = widget;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.text = "";
        NSDictionary dict = ((NSTextView)this.view).linkTextAttributes();
        this.defaultLinkColor = new NSColor(dict.valueForKey(OS.NSForegroundColorAttributeName));
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.focusIndex = -1;
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.textFieldFont;
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.scrollView != null) {
            this.display.removeWidget(this.scrollView);
        }
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rectangle) {
        this.fillBackground(this.view, context, rectangle, -1);
        if (!this.hasFocus() || this.focusIndex == -1) {
            return;
        }
        int[] outMetric = new int[1];
        OS.GetThemeMetric(7, outMetric);
        outMetric[0] = outMetric[0] - 1;
        CGRect r = new CGRect();
        NSRect[] rect = this.getRectangles(this.focusIndex);
        if (rect == null) {
            return;
        }
        int i = 0;
        while (i < rect.length && rect[i] != null) {
            r.origin.x = rect[i].x + (double)outMetric[0];
            r.origin.y = rect[i].y + (double)outMetric[0];
            r.size.width = rect[i].width - (double)outMetric[0];
            r.size.height = rect[i].height - (double)(2 * outMetric[0]);
            OS.HIThemeDrawFocusRect(r, true, context.graphicsPort(), 0);
            ++i;
        }
    }

    @Override
    void drawRect(long id2, long sel, NSRect rect) {
        super.drawRect(id2, sel, rect);
        if (this.display.appAppearance == Display.APPEARANCE.Dark) {
            this.setDefaultForeground();
        }
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        NSTextView widget = (NSTextView)this.view;
        widget.setTextColor(this.getTextColor(enabled));
        this.setLinkColor(enabled);
        this.redrawWidget(this.view, false);
    }

    @Override
    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        if (cursor != null) {
            return cursor;
        }
        NSTextView widget = (NSTextView)this.view;
        NSWindow window = this.view.window();
        NSPoint point = this.view.convertPoint_fromView_(window.convertScreenToBase(NSEvent.mouseLocation()), null);
        if (widget.characterIndexForInsertionAtPoint(point) == widget.textStorage().length()) {
            return this.display.getSystemCursor(0);
        }
        return null;
    }

    public Color getLinkForeground() {
        this.checkWidget();
        return Color.cocoa_new(this.display, this.display.getNSColorRGB(this.getLinkForegroundColor()));
    }

    NSColor getLinkForegroundColor() {
        if (this.linkForeground != null) {
            return NSColor.colorWithDeviceRed(this.linkForeground[0], this.linkForeground[1], this.linkForeground[2], this.linkForeground[3]);
        }
        return this.defaultLinkColor;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    NSRect[] getRectangles(int linkIndex) {
        if (linkIndex == -1) {
            return null;
        }
        NSTextView widget = (NSTextView)this.view;
        NSLayoutManager layoutManager = widget.layoutManager();
        NSRange range = new NSRange();
        range.location = this.offsets[linkIndex].x;
        range.length = this.offsets[linkIndex].y - this.offsets[linkIndex].x + 1;
        NSRange glyphRange = layoutManager.glyphRangeForCharacterRange(range, 0L);
        long rangePtr = C.malloc(NSRange.sizeof);
        NSRange lineRange = new NSRange();
        int numberOfLines = 0;
        long index = glyphRange.location;
        long glyphEndIndex = glyphRange.location + glyphRange.length;
        while (index < glyphEndIndex) {
            ++numberOfLines;
            layoutManager.lineFragmentUsedRectForGlyphAtIndex(index, rangePtr, true);
            OS.memmove(lineRange, rangePtr, (long)NSRange.sizeof);
            index = lineRange.location + lineRange.length;
        }
        NSRect[] result = new NSRect[numberOfLines];
        index = glyphRange.location;
        int i = 0;
        while (index < glyphEndIndex && i < numberOfLines) {
            NSRect usedRect = layoutManager.lineFragmentUsedRectForGlyphAtIndex(index, rangePtr, true);
            OS.memmove(lineRange, rangePtr, (long)NSRange.sizeof);
            index = lineRange.location + lineRange.length;
            if (lineRange.location < glyphRange.location) {
                lineRange.length = index - glyphRange.location;
                lineRange.location = glyphRange.location;
            }
            if (index > glyphEndIndex) {
                lineRange.length = glyphEndIndex - lineRange.location;
            }
            NSRect boundsRect = layoutManager.boundingRectForGlyphRange(lineRange, widget.textContainer());
            result[i] = new NSRect();
            OS.NSIntersectionRect(result[i], usedRect, boundsRect);
            ++i;
        }
        C.free(rangePtr);
        return result;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    NSColor getTextColor(boolean enabled) {
        if (enabled) {
            if (this.foreground == null) {
                return NSColor.textColor();
            }
            return NSColor.colorWithDeviceRed(this.foreground[0], this.foreground[1], this.foreground[2], this.foreground[3]);
        }
        return NSColor.disabledControlTextColor();
    }

    @Override
    void mouseUp(long id2, long sel, long theEvent) {
        if (this.ignoreNextMouseUp) {
            this.ignoreNextMouseUp = false;
            return;
        }
        super.mouseUp(id2, sel, theEvent);
    }

    String parse(String string) {
        int length = string.length();
        this.offsets = new Point[length / 4];
        this.ids = new String[length / 4];
        this.mnemonics = new int[length / 4 + 1];
        StringBuilder result = new StringBuilder();
        char[] buffer = new char[length];
        string.getChars(0, string.length(), buffer, 0);
        int index = 0;
        int state = 0;
        int linkIndex = 0;
        int start = 0;
        int tagStart = 0;
        int linkStart = 0;
        int endtagStart = 0;
        int refStart = 0;
        while (index < length) {
            char c = Character.toLowerCase(buffer[index]);
            block0 : switch (state) {
                case 0: {
                    if (c != '<') break;
                    tagStart = index;
                    ++state;
                    break;
                }
                case 1: {
                    if (c != 'a') break;
                    ++state;
                    break;
                }
                case 2: {
                    switch (c) {
                        case 'h': {
                            state = 7;
                            break block0;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) break;
                    state = 13;
                    break;
                }
                case 3: {
                    if (c != '<') break;
                    endtagStart = index;
                    ++state;
                    break;
                }
                case 4: {
                    state = c == '/' ? state + 1 : 3;
                    break;
                }
                case 5: {
                    state = c == 'a' ? state + 1 : 3;
                    break;
                }
                case 6: {
                    if (c == '>') {
                        this.mnemonics[linkIndex] = this.parseMnemonics(buffer, start, tagStart, result);
                        int offset = result.length();
                        this.parseMnemonics(buffer, linkStart, endtagStart, result);
                        this.offsets[linkIndex] = new Point(offset, result.length() - 1);
                        if (this.ids[linkIndex] == null) {
                            this.ids[linkIndex] = new String(buffer, linkStart, endtagStart - linkStart);
                        }
                        ++linkIndex;
                        endtagStart = refStart = index + 1;
                        linkStart = refStart;
                        tagStart = refStart;
                        start = refStart;
                        state = 0;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    state = c == 'r' ? state + 1 : 0;
                    break;
                }
                case 8: {
                    state = c == 'e' ? state + 1 : 0;
                    break;
                }
                case 9: {
                    state = c == 'f' ? state + 1 : 0;
                    break;
                }
                case 10: {
                    state = c == '=' ? state + 1 : 0;
                    break;
                }
                case 11: {
                    if (c == '\"') {
                        ++state;
                        refStart = index + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (c != '\"') break;
                    this.ids[linkIndex] = new String(buffer, refStart, index - refStart);
                    state = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        break;
                    }
                    if (c != '=') break;
                    ++state;
                    break;
                }
                case 14: {
                    state = c == '\"' ? state + 1 : 0;
                    break;
                }
                case 15: {
                    if (c != '\"') break;
                    state = 2;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++index;
        }
        if (start < length) {
            int tmp = this.parseMnemonics(buffer, start, tagStart, result);
            int mnemonic = this.parseMnemonics(buffer, Math.max(tagStart, linkStart), length, result);
            if (mnemonic == -1) {
                mnemonic = tmp;
            }
            this.mnemonics[linkIndex] = mnemonic;
        } else {
            this.mnemonics[linkIndex] = -1;
        }
        if (this.offsets.length != linkIndex) {
            Point[] newOffsets = new Point[linkIndex];
            System.arraycopy(this.offsets, 0, newOffsets, 0, linkIndex);
            this.offsets = newOffsets;
            String[] newIDs = new String[linkIndex];
            System.arraycopy(this.ids, 0, newIDs, 0, linkIndex);
            this.ids = newIDs;
            int[] newMnemonics = new int[linkIndex + 1];
            System.arraycopy(this.mnemonics, 0, newMnemonics, 0, linkIndex + 1);
            this.mnemonics = newMnemonics;
        }
        return result.toString();
    }

    int parseMnemonics(char[] buffer, int start, int end, StringBuilder result) {
        int mnemonic = -1;
        int index = start;
        while (index < end) {
            if (buffer[index] == '&') {
                if (index + 1 < end && buffer[index + 1] == '&') {
                    result.append(buffer[index]);
                    ++index;
                } else {
                    mnemonic = result.length();
                }
            } else {
                result.append(buffer[index]);
            }
            ++index;
        }
        return mnemonic;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.scrollView, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.scrollView != null) {
            this.scrollView.release();
        }
        this.scrollView = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
        this.defaultLinkColor = null;
        this.linkForeground = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void scrollWheel(long id2, long sel, long theEvent) {
        super.scrollWheel(id2, sel, theEvent);
        this.parent.scrollWheel(this.parent.view.id, sel, theEvent);
    }

    @Override
    void sendFocusEvent(int type) {
        if (this.focusIndex != -1) {
            this.redrawWidget(this.view, false);
        }
        super.sendFocusEvent(type);
    }

    @Override
    boolean sendKeyEvent(int type, Event event) {
        boolean result = super.sendKeyEvent(type, event);
        if (!result) {
            return result;
        }
        if (this.focusIndex == -1) {
            return result;
        }
        if (type != 1) {
            return result;
        }
        int keyCode = event.keyCode;
        switch (keyCode) {
            case 13: 
            case 32: 
            case 0x1000050: {
                Event event1 = new Event();
                event1.text = this.ids[this.focusIndex];
                this.sendEvent(13, event1);
                break;
            }
            case 9: {
                boolean next;
                int modifierFlags = event.stateMask;
                boolean bl = next = (modifierFlags & 0x20000) == 0;
                if (next) {
                    if (this.focusIndex >= this.offsets.length - 1) break;
                    ++this.focusIndex;
                    this.redraw();
                    return false;
                }
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
                return false;
            }
        }
        return result;
    }

    @Override
    boolean sendMouseEvent(NSEvent nsEvent, int type, boolean send) {
        if (type == 5 && this.view.window().firstResponder().id != this.view.id) {
            this.mouseMoved(this.view.id, OS.sel_mouseMoved_, nsEvent.id);
        }
        return super.sendMouseEvent(nsEvent, type, send);
    }

    void setBackground(NSColor nsColor) {
        NSTextView widget = (NSTextView)this.view;
        if (nsColor == null) {
            widget.setDrawsBackground(false);
        } else {
            widget.setDrawsBackground(true);
            widget.setBackgroundColor(nsColor);
        }
    }

    @Override
    void setBackgroundColor(NSColor nsColor) {
        this.setBackground(nsColor);
    }

    @Override
    void setBackgroundImage(NSImage image) {
        ((NSTextView)this.view).setDrawsBackground(image == null);
    }

    void setDefaultForeground() {
        if (this.foreground != null) {
            return;
        }
        if (this.getEnabled()) {
            ((NSTextView)this.view).setTextColor(NSColor.textColor());
        } else {
            ((NSTextView)this.view).setTextColor(NSColor.disabledControlTextColor());
        }
    }

    @Override
    void setFont(NSFont font) {
        ((NSTextView)this.view).setFont(font);
    }

    @Override
    void setForeground(double[] color) {
        if (!this.getEnabled()) {
            return;
        }
        ((NSTextView)this.view).setTextColor(this.getTextColor(true));
    }

    void setLinkColor(boolean enabled) {
        NSTextView widget = (NSTextView)this.view;
        NSDictionary linkTextAttributes = widget.linkTextAttributes();
        int count = (int)linkTextAttributes.count();
        NSMutableDictionary dict = NSMutableDictionary.dictionaryWithCapacity(count);
        dict.setDictionary(linkTextAttributes);
        dict.setValue(enabled ? this.getLinkForegroundColor() : this.getTextColor(false), OS.NSForegroundColorAttributeName);
        widget.setLinkTextAttributes(dict);
    }

    public void setLinkForeground(Color color) {
        double[] linkForeground;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        double[] dArray = linkForeground = color != null ? color.handle : null;
        if (this.equals(linkForeground, this.linkForeground)) {
            return;
        }
        this.linkForeground = linkForeground;
        if (this.getEnabled()) {
            this.setLinkColor(true);
        }
        this.redrawWidget(this.view, false);
    }

    @Override
    void setOrientation() {
        NSTextView widget = (NSTextView)this.view;
        int direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        widget.setBaseWritingDirection(direction);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        NSTextView widget = (NSTextView)this.view;
        widget.setString(NSString.stringWith(this.parse(string)));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        NSTextStorage textStorage = widget.textStorage();
        NSRange range = new NSRange();
        range.length = textStorage.length();
        textStorage.removeAttribute(OS.NSLinkAttributeName, range);
        textStorage.addAttribute(OS.NSCursorAttributeName, NSCursor.arrowCursor(), range);
        int i = 0;
        while (i < this.offsets.length) {
            range.location = this.offsets[i].x;
            range.length = this.offsets[i].y - this.offsets[i].x + 1;
            textStorage.addAttribute(OS.NSLinkAttributeName, NSString.stringWith(this.ids[i]), range);
            ++i;
        }
    }

    @Override
    void setZOrder() {
        super.setZOrder();
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
    }

    @Override
    boolean shouldDrawInsertionPoint(long id2, long sel) {
        return false;
    }

    @Override
    boolean textView_clickOnLink_atIndex(long id2, long sel, long textView, long link, long charIndex) {
        NSString str = new NSString(link);
        Event event = new Event();
        event.text = str.getString();
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return true;
        }
        int i = 0;
        while (i < this.offsets.length) {
            if (charIndex >= (long)this.offsets[i].x && charIndex <= (long)this.offsets[i].y) {
                this.focusIndex = i;
                break;
            }
            ++i;
        }
        this.redrawWidget(this.view, false);
        this.ignoreNextMouseUp = true;
        return true;
    }

    @Override
    NSView topView() {
        return this.scrollView;
    }

    @Override
    int traversalCode(int key, NSEvent theEvent) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int bits = super.traversalCode(key, theEvent);
        if (key == 48 && theEvent != null) {
            boolean next;
            long modifierFlags = theEvent.modifierFlags();
            boolean bl = next = (modifierFlags & 0x20000L) == 0L;
            if (next && this.focusIndex < this.offsets.length - 1) {
                return bits & 0xFFFFFFEF;
            }
            if (!next && this.focusIndex > 0) {
                return bits & 0xFFFFFFF7;
            }
        }
        return bits;
    }

    @Override
    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        if (this.scrollView == null) {
            return;
        }
        this.updateCursorRects(enabled, this.scrollView);
        NSClipView contentView = this.scrollView.contentView();
        this.updateCursorRects(enabled, contentView);
        contentView.setDocumentCursor(enabled ? NSCursor.arrowCursor() : null);
    }
}

