/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.widgets.GraphContainer;

public class ExpandGraphLabel
extends Figure
implements ActionListener {
    public static final int OPEN = 1;
    public static final int CLOSED = 2;
    private int state = 2;
    private Expander expander = null;
    private int arcWidth;
    private Label label = null;
    private final GraphContainer container;
    private ToolbarLayout layout;

    public void setExpandedState(int state) {
        if (state == 1) {
            this.expander.open();
        } else {
            this.expander.close();
        }
        this.state = state;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.state == 1) {
            this.container.close(true);
        } else {
            this.container.open(true);
        }
    }

    public ExpandGraphLabel(GraphContainer container, boolean cacheLabel) {
        this(container, "", null, cacheLabel);
    }

    public ExpandGraphLabel(GraphContainer container, Image i, boolean cacheLabel) {
        this(container, "", i, cacheLabel);
    }

    public ExpandGraphLabel(GraphContainer container, String text, boolean cacheLabel) {
        this(container, text, null, cacheLabel);
    }

    public ExpandGraphLabel(GraphContainer container, String text, Image image, boolean cacheLabel) {
        this.label = new Label(text){

            protected void paintFigure(Graphics graphics) {
                if (this.isOpaque()) {
                    super.paintFigure(graphics);
                }
                Rectangle bounds = this.getBounds();
                graphics.translate(bounds.x, bounds.y);
                if (this.getIcon() != null) {
                    graphics.drawImage(this.getIcon(), this.getIconLocation());
                }
                if (!this.isEnabled()) {
                    graphics.translate(1, 1);
                    graphics.setForegroundColor(ColorConstants.buttonLightest);
                    graphics.drawText(this.getSubStringText(), this.getTextLocation());
                    graphics.translate(-1, -1);
                    graphics.setForegroundColor(ColorConstants.buttonDarker);
                }
                graphics.drawText(this.getText(), this.getTextLocation());
                graphics.translate(-bounds.x, -bounds.y);
            }
        };
        this.setText(text);
        this.setImage(image);
        this.container = container;
        this.expander = new Expander();
        this.arcWidth = 8;
        this.setFont(Display.getDefault().getSystemFont());
        this.layout = new ToolbarLayout(true);
        this.layout.setSpacing(5);
        this.layout.setMinorAlignment(0);
        this.setLayoutManager((LayoutManager)this.layout);
        this.add((IFigure)this.expander);
        this.add((IFigure)this.label);
    }

    protected void adjustBoundsToFit() {
        Font font;
        String text = this.getText();
        if (text != null && text.length() > 0 && (font = this.getFont()) != null) {
            Dimension minSize = FigureUtilities.getTextExtents((String)text, (Font)font);
            if (this.getIcon() != null) {
                org.eclipse.swt.graphics.Rectangle imageRect = this.getIcon().getBounds();
                int expandHeight = Math.max(imageRect.height - minSize.height, 0);
                minSize.expand(imageRect.width + 4, expandHeight);
            }
            minSize.expand(112, 6);
            this.label.setBounds(new Rectangle(this.getLocation(), minSize));
        }
    }

    private Image getIcon() {
        return this.label.getIcon();
    }

    private String getText() {
        return this.label.getText();
    }

    public void paint(Graphics graphics) {
        int blue = this.getBackgroundColor().getBlue();
        blue = (blue = (int)((double)blue - (double)blue * 0.2)) > 0 ? blue : 0;
        int red = this.getBackgroundColor().getRed();
        red = (int)((double)red - (double)red * 0.2);
        red = red > 0 ? red : 0;
        int green = this.getBackgroundColor().getGreen();
        green = (int)((double)green - (double)green * 0.2);
        green = green > 0 ? green : 0;
        Color lightenColor = new Color((Device)Display.getCurrent(), new RGB(red, green, blue));
        graphics.setForegroundColor(lightenColor);
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.pushState();
        Rectangle bounds = this.getBounds().getCopy();
        Rectangle r = bounds.getCopy();
        r.y += this.arcWidth / 2;
        r.height -= this.arcWidth;
        Rectangle top = bounds.getCopy();
        top.height /= 2;
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.fillRoundRectangle(top, this.arcWidth, this.arcWidth);
        top.y += top.height;
        graphics.setForegroundColor(lightenColor);
        graphics.setBackgroundColor(lightenColor);
        graphics.fillRoundRectangle(top, this.arcWidth, this.arcWidth);
        graphics.setBackgroundColor(lightenColor);
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.fillGradient(r, true);
        super.paint(graphics);
        graphics.popState();
        graphics.setForegroundColor(lightenColor);
        graphics.setBackgroundColor(lightenColor);
        bounds.setSize(bounds.width - 1, bounds.height - 1);
        graphics.drawRoundRectangle(bounds, this.arcWidth, this.arcWidth);
        lightenColor.dispose();
    }

    public void setTextT(String string) {
        this.setPreferredSize(null);
        this.label.setText(string);
        this.add((IFigure)this.label);
        this.layout.layout((IFigure)this);
        this.invalidate();
        this.revalidate();
        this.validate();
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public void setImage(Image image) {
        this.label.setIcon(image);
    }

    public void setLocation(Point p) {
        super.setLocation(p);
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    class Expander
    extends Clickable {
        private Triangle triangle;

        public Expander() {
            this.setStyle(Clickable.STYLE_TOGGLE);
            this.triangle = new Triangle();
            this.triangle.setSize(10, 10);
            this.triangle.setBackgroundColor(ColorConstants.black);
            this.triangle.setForegroundColor(ColorConstants.black);
            this.triangle.setFill(true);
            this.triangle.setDirection(16);
            this.triangle.setLocation(new Point(5, 3));
            this.setLayoutManager((LayoutManager)new FreeformLayout());
            this.add((IFigure)this.triangle);
            this.setPreferredSize(15, 15);
            this.addActionListener(ExpandGraphLabel.this);
        }

        public void open() {
            this.triangle.setDirection(4);
        }

        public void close() {
            this.triangle.setDirection(16);
        }
    }
}

