/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;

public class AttributeTypeToXWidgetName {
    public static <T extends EnumToken> String getXWidgetName(ArtifactTypeToken artType, AttributeTypeToken attributeType) {
        int minOccurrence = artType.getMin(attributeType);
        int maxOccurrence = artType.getMax(attributeType);
        String xWidgetName = "";
        if (attributeType.isEnumerated()) {
            AttributeTypeEnum enumeratedType = (AttributeTypeEnum)ServiceUtil.getOrcsTokenService().getAttributeType(attributeType.getId());
            artType = ServiceUtil.getOrcsTokenService().getArtifactType(artType.getId());
            xWidgetName = maxOccurrence == 1 ? "XComboDam(" + Collections.toString((String)",", (Iterable)artType.getValidEnumValues(enumeratedType)) + ")" : "XSelectFromMultiChoiceDam(" + Collections.toString((String)",", (Iterable)artType.getValidEnumValues(enumeratedType)) + ")";
        } else {
            xWidgetName = attributeType.isBoolean() ? (minOccurrence == 1 ? "XCheckBoxDam" : "XComboBooleanDam") : (attributeType.isDate() ? "XDateDam" : (attributeType.isInteger() ? "XIntegerDam" : (attributeType.isLong() ? "XLongDam" : (attributeType.isDouble() ? "XFloatDam" : (attributeType.isInputStream() ? "XLabelDam" : (attributeType.isBranchId() ? "XBranchSelectWidget" : (attributeType.isArtifactId() ? "XListDropViewWithSave" : (attributeType.isString() ? (maxOccurrence == 1 ? (attributeType.isMultiLine() ? "XStackedDam" : "XTextDam") : (attributeType.isSingleLine() ? "XTextFlatDam" : "XStackedDam")) : "XStackedDam"))))))));
        }
        return xWidgetName;
    }
}

