/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.change;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;
import org.eclipse.osee.framework.skynet.core.change.Change;

public final class RelationChange
extends Change {
    private static final ChangeType changeType = ChangeType.Relation;
    private final ArtifactId bArtId;
    private final Artifact endTxBArtifact;
    private final RelationId relLinkId;
    private final String rationale;
    private final String wasValue;
    private final RelationTypeToken relationType;

    public RelationChange(BranchToken branch, GammaId sourceGamma, ArtifactId aArtId, TransactionDelta txDelta, ModificationType modType, ArtifactId bArtId, RelationId relLinkId, String rationale, String wasValue, RelationTypeToken relationType, boolean isHistorical, Artifact changeArtifact, ArtifactDelta artifactDelta, Artifact endTxBArtifact) {
        super(branch, sourceGamma, aArtId, txDelta, modType, isHistorical, changeArtifact, artifactDelta);
        this.bArtId = bArtId;
        this.relLinkId = relLinkId;
        this.rationale = rationale;
        this.relationType = relationType;
        this.endTxBArtifact = endTxBArtifact;
        this.wasValue = wasValue;
    }

    public ArtifactId getBArtId() {
        return this.bArtId;
    }

    public Artifact getEndTxBArtifact() {
        return this.endTxBArtifact;
    }

    public RelationId getRelLinkId() {
        return this.relLinkId;
    }

    public String getRationale() {
        return this.rationale;
    }

    public RelationTypeToken getRelationType() {
        return this.relationType;
    }

    @Override
    public ChangeType getChangeType() {
        return changeType;
    }

    @Override
    public String getName() {
        return String.format("%s <- [%s] -> %s", this.getArtifactName(), this.getItemTypeName(), this.getEndTxBArtifact().getName());
    }

    @Override
    public String getNameOrToken() {
        return String.format("%s <- [%s] -> %s", this.getArtifactNameOrToken(), this.getItemTypeName(), UserManager.isShowTokenForChangeName() ? this.getEndTxBArtifact().toStringWithId() : this.getEndTxBArtifact().getName());
    }

    @Override
    public String getItemTypeName() {
        return this.relationType.getName();
    }

    @Override
    public String getIsValue() {
        return this.getRationale();
    }

    @Override
    public String getItemKind() {
        return "Relation";
    }

    @Override
    public String getWasValue() {
        return this.wasValue;
    }

    @Override
    public Id getItemTypeId() {
        return this.relationType;
    }

    @Override
    public Id getItemId() {
        return this.relLinkId;
    }
}

