/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.utility;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.branch.graph.model.BranchModel;
import org.eclipse.swt.graphics.Color;

public class GraphColorConstants {
    public static final Color FONT_COLOR = new Color(null, 1, 70, 122);
    public static final Color BGCOLOR = new Color(null, 250, 250, 250);
    private static final Color CURRENT_BRANCH = ColorConstants.orange;
    private static final Color SYSTEM_ROOT_BRANCH = new Color(null, 255, 180, 220);
    private static final Color WORKING_BRANCH_COLOR = new Color(null, 244, 244, 244);
    private static final Color BASELINE_BRANCH = new Color(null, 120, 255, 120);
    private static final Color MERGE_BRANCH = new Color(null, 200, 200, 240);

    private GraphColorConstants() {
    }

    public static Color getBranchColor(BranchModel branchModel) {
        Color toReturn = ColorConstants.gray;
        if (branchModel.isDefaultBranch()) {
            toReturn = CURRENT_BRANCH;
        } else {
            BranchType type = BranchManager.getType((BranchId)branchModel.getBranch());
            if (type.equals((Object)BranchType.BASELINE)) {
                toReturn = BASELINE_BRANCH;
            } else if (type.equals((Object)BranchType.MERGE)) {
                toReturn = MERGE_BRANCH;
            } else if (type.equals((Object)BranchType.SYSTEM_ROOT)) {
                toReturn = SYSTEM_ROOT_BRANCH;
            } else if (type.equals((Object)BranchType.WORKING)) {
                toReturn = WORKING_BRANCH_COLOR;
            }
        }
        return toReturn;
    }
}

