/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.viewers.data;

import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OteArtifactTypes;
import org.eclipse.osee.framework.core.enums.OteAttributeTypes;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.attribute.DateAttribute;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.OverlayImage;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.osee.ote.ui.define.OteDefineImage;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.viewers.data.DataItem;
import org.eclipse.osee.ote.ui.define.viewers.data.IXViewerItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeColumn;

public class ArtifactItem
extends DataItem
implements IXViewerItem,
IArtifactEventListener,
IArtifactTopicEventListener {
    private static Image FROM_LOCAL_WS_COMMIT_ALLOWED_IMAGE = null;
    private static Image FROM_DATABASE_IMAGE = null;
    private static Image FROM_LOCAL_WS_COMMIT_NOT_ALLOWED_IMAGE = null;
    private static Image INVALID_SCRIPT_IMAGE = null;
    private static boolean isFullDescriptionMode = true;
    private final XViewer xViewer;
    private Artifact artifact;
    private ArtifactTestRunOperator operator;
    private String key;

    public ArtifactItem(XViewer xViewer, Artifact artifact, DataItem parent) {
        super(parent);
        this.xViewer = xViewer;
        this.setArtifact(artifact);
        OseeEventManager.addListener((IEventListener)this);
    }

    public Artifact getData() {
        return this.artifact;
    }

    @Override
    public void dispose() {
        OseeEventManager.removeListener((IEventListener)this);
        super.dispose();
    }

    private void setArtifact(Artifact artifact) {
        this.artifact = artifact;
        this.operator = new ArtifactTestRunOperator(artifact);
        try {
            this.key = String.format("%s:%s:%s", this.getOperator().getChecksum(), this.getOperator().isFromLocalWorkspace(), this.getOperator().hasNotBeenCommitted());
        }
        catch (Exception exception) {
            this.key = "";
        }
    }

    public XViewer getXViewer() {
        return this.xViewer;
    }

    public ArtifactTestRunOperator getOperator() {
        return this.operator;
    }

    @Override
    public String getLabel(int index) {
        String toReturn;
        block17: {
            String colName;
            Artifact artifact;
            block18: {
                toReturn = "";
                artifact = this.getData();
                if (artifact == null || artifact.isDeleted() || index > this.xViewer.getTree().getColumns().length - 1) break block17;
                TreeColumn treeCol = this.xViewer.getTree().getColumns()[index];
                colName = treeCol.getText();
                if (colName.equals("GUID")) {
                    toReturn = artifact.getGuid();
                    break block17;
                }
                if (colName.equals("Artifact_Type")) {
                    toReturn = artifact.getArtifactTypeName();
                    if (this.getOperator().isFromLocalWorkspace()) {
                        toReturn = String.valueOf(toReturn) + " (Local)";
                    }
                    break block17;
                }
                if (colName.equals("Status")) {
                    try {
                        toReturn = this.getOperator().getTestResultStatus();
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                        toReturn = ex.getLocalizedMessage();
                    }
                    break block17;
                }
                if (!colName.equals("Disposition")) break block18;
                String name = artifact.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.Name, "");
                if (name != "") {
                    try {
                        Artifact dispoArtifact = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)OteArtifactTypes.TestRunDisposition, (String)name, (BranchId)artifact.getBranch());
                        if (dispoArtifact != null) {
                            return dispoArtifact.getSoleAttributeValueAsString((AttributeTypeToken)OteAttributeTypes.TestDisposition, "");
                        }
                    }
                    catch (ArtifactDoesNotExist artifactDoesNotExist) {}
                }
                return "";
            }
            try {
                AttributeTypeToken attributeType = AttributeTypeManager.getType((String)colName);
                if (!artifact.isAttributeTypeValid((AttributeTypeId)attributeType)) break block17;
                if (attributeType.isDate()) {
                    Date date = null;
                    try {
                        date = (Date)artifact.getSoleAttributeValue((AttributeTypeId)attributeType);
                    }
                    catch (Exception exception) {}
                    toReturn = date != null ? new DateAttribute().MMDDYYHHMM.format(date) : "NOT SET";
                    break block17;
                }
                toReturn = artifact.getAttributesToString((AttributeTypeId)attributeType);
                if (colName.equals("Name")) {
                    toReturn = this.getArtifactName(toReturn);
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                toReturn = ex.getLocalizedMessage();
            }
        }
        return toReturn;
    }

    private String getArtifactName(String rawName) {
        String name = rawName;
        if (!ArtifactItem.isFullDescriptionModeEnabled()) {
            String[] qualifiers = rawName.split("\\.");
            name = qualifiers[qualifiers.length - 1];
        }
        return String.format("%s%s [%s]", this.getOperator().isFromLocalWorkspace() ? "> " : "", name, this.getOperator().getChecksum());
    }

    @Override
    public Image getImage() {
        Image toReturn = null;
        try {
            Artifact artifact = this.getData();
            if (artifact != null && !artifact.isDeleted()) {
                ArtifactTestRunOperator operator;
                if (!this.areImagesInitialized()) {
                    this.initializeImages();
                }
                toReturn = (operator = this.getOperator()).isFromLocalWorkspace() ? (operator.isCommitAllowed() ? FROM_LOCAL_WS_COMMIT_ALLOWED_IMAGE : (!operator.isScriptRevisionValid() ? INVALID_SCRIPT_IMAGE : FROM_LOCAL_WS_COMMIT_NOT_ALLOWED_IMAGE)) : FROM_DATABASE_IMAGE;
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return toReturn;
    }

    private boolean areImagesInitialized() {
        return FROM_LOCAL_WS_COMMIT_ALLOWED_IMAGE != null && FROM_DATABASE_IMAGE != null && FROM_LOCAL_WS_COMMIT_NOT_ALLOWED_IMAGE != null;
    }

    private void initializeImages() {
        Artifact artifact = this.getData();
        Image defaultImage = ArtifactImageManager.getImage((Artifact)artifact);
        DecorationOverlayIcon overlay = null;
        if (FROM_LOCAL_WS_COMMIT_ALLOWED_IMAGE == null) {
            OverlayImage overlayImage = new OverlayImage(defaultImage, ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.ADDITION), OverlayImage.Location.BOT_RIGHT);
            FROM_LOCAL_WS_COMMIT_ALLOWED_IMAGE = overlayImage.createImage();
        }
        if (FROM_LOCAL_WS_COMMIT_NOT_ALLOWED_IMAGE == null) {
            overlay = new DecorationOverlayIcon(defaultImage, ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.CONFAUTO_OV), 3);
            FROM_LOCAL_WS_COMMIT_NOT_ALLOWED_IMAGE = overlay.createImage();
        }
        if (FROM_DATABASE_IMAGE == null) {
            overlay = new DecorationOverlayIcon(defaultImage, ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.VERSION_CONTROLLED), 3);
            FROM_DATABASE_IMAGE = overlay.createImage();
        }
        if (INVALID_SCRIPT_IMAGE == null) {
            overlay = new DecorationOverlayIcon(defaultImage, ImageManager.getImageDescriptor((KeyedImage)OteDefineImage.OBSTRUCTED), 3);
            INVALID_SCRIPT_IMAGE = overlay.createImage();
        }
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    public static void setFullDescriptionModeEnabled(boolean isEnabled) {
        isFullDescriptionMode = isEnabled;
    }

    public static boolean isFullDescriptionModeEnabled() {
        return isFullDescriptionMode;
    }

    public List<? extends IEventFilter> getEventFilters() {
        return null;
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return null;
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        if (this.artifact.isDeleted()) {
            return;
        }
        if (artifactEvent.isDeletedPurged(this.artifact)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!ArtifactItem.this.xViewer.getTree().isDisposed()) {
                        ArtifactItem.this.xViewer.remove((Object)this);
                    }
                    ArtifactItem.this.dispose();
                }
            });
            return;
        }
        if (artifactEvent.isRelAddedChangedDeleted(this.artifact) || artifactEvent.isModified(this.artifact)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!ArtifactItem.this.xViewer.getTree().isDisposed()) {
                        ArtifactItem.this.xViewer.remove((Object)this);
                    } else {
                        ArtifactItem.this.xViewer.update((Object)this, null);
                    }
                }
            });
        }
    }

    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, Sender sender) {
        if (this.artifact.isDeleted()) {
            return;
        }
        if (artifactTopicEvent.isDeletedPurged(this.artifact)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!ArtifactItem.this.xViewer.getTree().isDisposed()) {
                        ArtifactItem.this.xViewer.remove((Object)this);
                    }
                    ArtifactItem.this.dispose();
                }
            });
            return;
        }
        if (artifactTopicEvent.isRelAddedChangedDeleted(this.artifact) || artifactTopicEvent.isModified(this.artifact)) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!ArtifactItem.this.xViewer.getTree().isDisposed()) {
                        ArtifactItem.this.xViewer.remove((Object)this);
                    } else {
                        ArtifactItem.this.xViewer.update((Object)this, null);
                    }
                }
            });
        }
    }
}

