/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.traceability.data.TraceMark;
import org.eclipse.osee.define.ide.traceability.data.TraceUnit;
import org.eclipse.osee.define.ide.traceability.operations.ITraceUnitProcessor;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public final class TraceUnitReportProcessor
implements ITraceUnitProcessor {
    private long startTime;
    private long startMemory;
    private final XResultData resultData = new XResultData();

    public TraceUnitReportProcessor() {
        this.startTime = System.currentTimeMillis();
        this.startMemory = Runtime.getRuntime().totalMemory();
    }

    @Override
    public void clear() {
        this.startTime = 0L;
        this.startMemory = 0L;
    }

    @Override
    public void initialize(IProgressMonitor monitor) {
        this.resultData.addRaw(AHTML.beginMultiColumnTable((int)95, (int)1));
        this.resultData.addRaw(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Test Unit Type", "Test Unit Name", "Trace Type", "Trace Mark"}));
    }

    @Override
    public void process(IProgressMonitor monitor, TraceUnit testUnit) {
        if (testUnit != null) {
            block0: for (String traceTypes : testUnit.getTraceMarkTypes()) {
                for (TraceMark traceMark : testUnit.getTraceMarksByType(traceTypes)) {
                    if (monitor.isCanceled()) continue block0;
                    this.resultData.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{testUnit.getTraceUnitType().getName(), testUnit.getName(), traceMark.getTraceType(), traceMark.getRawTraceMark()}));
                }
            }
        }
    }

    @Override
    public void onComplete(IProgressMonitor monitor) {
        this.resultData.addRaw(AHTML.endMultiColumnTable());
        System.out.println(String.format("Completed in: %s", Lib.getElapseString((long)this.startTime)));
        System.out.println(String.format("Memory Leaked: %s", Runtime.getRuntime().totalMemory() - this.startMemory));
        XResultDataUI.report((XResultData)this.resultData, (String)"Report");
    }
}

