/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.osee.define.ide.traceability.RequirementTraceabilityData;
import org.eclipse.osee.define.ide.traceability.TraceabilityTable;
import org.eclipse.osee.define.ide.traceability.report.ISimpleTable;
import org.eclipse.osee.define.ide.traceability.report.StdCsciToTestTable;
import org.eclipse.osee.define.ide.traceability.report.StdTestToCsciTable;
import org.eclipse.osee.define.ide.traceability.report.StpCsciToTestTable;
import org.eclipse.osee.define.ide.traceability.report.StpTestToCsciTable;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;

public class TraceabilityFactory {
    public static TraceabilityTable getTraceabilityTable(TraceabilityStyle style, RequirementTraceabilityData sourceData) throws Exception {
        ISimpleTable simpleTable = null;
        StringWriter stringWriter = new StringWriter();
        ExcelXmlWriter sheetWriter = new ExcelXmlWriter((Writer)stringWriter);
        switch (style) {
            case STP_Test_to_CSCI: {
                simpleTable = new StpTestToCsciTable(sourceData);
                break;
            }
            case STP_CSCI_to_Test: {
                simpleTable = new StpCsciToTestTable(sourceData, false);
                break;
            }
            case STP_CSCI_to_Test_One_Per_Row: {
                simpleTable = new StpCsciToTestTable(sourceData, true);
                break;
            }
            case STD_Test_to_CSCI: {
                simpleTable = new StdTestToCsciTable(sourceData, false);
                break;
            }
            case STD_CSCI_to_Test: {
                simpleTable = new StdCsciToTestTable(sourceData, false);
                break;
            }
            case STD_Test_to_CSCI_One_Per_Row: {
                simpleTable = new StdTestToCsciTable(sourceData, true);
                break;
            }
            case STD_CSCI_to_Test_One_Per_Row: {
                simpleTable = new StdCsciToTestTable(sourceData, true);
                break;
            }
            default: {
                throw new OseeArgumentException("Unsupported Style [%s]", new Object[]{style});
            }
        }
        return new TraceabilityTable(stringWriter, sheetWriter, simpleTable);
    }

    public static enum TraceabilityStyle {
        STP_Test_to_CSCI,
        STP_CSCI_to_Test,
        STP_CSCI_to_Test_One_Per_Row,
        STD_Test_to_CSCI,
        STD_CSCI_to_Test,
        STD_Test_to_CSCI_One_Per_Row,
        STD_CSCI_to_Test_One_Per_Row;


        public String toString() {
            return this.name().toUpperCase();
        }

        public String asLabel() {
            return this.name().replaceAll("_", " ");
        }
    }
}

