/*********************************************************************
 * Copyright (c) 2022 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.synchronization.rest;

import org.eclipse.osee.synchronization.util.IndentedString;

/**
 * A specialization of {@link AbstractMapGrove} for the storage of {@link SpecificationGroveThing} objects needed for a
 * Synchronization Artifact.
 *
 * @author Loren K. Ashley
 */

public class SpecificationGrove extends AbstractMapGrove {

   /**
    * Creates a new empty {@link SpecificationGrove}.
    */

   SpecificationGrove() {
      super(IdentifierType.SPECIFICATION);
   }

   /**
    * Generates a debugging message with a listing of the {@link SpecificationGroveThing} objects stored in the grove. There is no
    * contract for the format or contents of the generated message. {@inheritDoc}
    */

   @Override
   public StringBuilder toMessage(int indent, StringBuilder message) {
      var outMessage = (message != null) ? message : new StringBuilder(1 * 1024);
      var indent0 = IndentedString.indentString(indent + 0);
      var indent1 = IndentedString.indentString(indent + 1);
      var indent2 = IndentedString.indentString(indent + 2);

      //@formatter:off
      outMessage
         .append( indent0 ).append( "SpecificationGrove:" ).append( "\n" );
      //@formatter:on

      this.map.values().forEach(specification -> {
         //@formatter:off
         outMessage
            .append( indent1 ).append( "SpecificationGroveThing:" ).append( "\n" )
            .append( indent2 ).append( "Key:          ").append( specification.getGroveThingKey() ).append( "\n" )
            .append( indent2 ).append( "Native Thing: ").append( specification.getNativeThing()   ).append( "\n" )
            ;
         //@formatter:on
      });

      return outMessage;
   }

   /**
    * Returns the message generated by the method {@link #toMessage} with an indent level of zero. {@inheritDoc}
    */

   @Override
   public String toString() {
      return this.toMessage(0, null).toString();
   }
}

/* EOF */
