/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.internal.InterfaceNodeAccessor;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.mim.types.PLGenericDBObject;
import org.eclipse.osee.orcs.OrcsApi;

public class InterfaceNodeViewApiImpl
implements InterfaceNodeViewApi {
    private ArtifactAccessor<InterfaceNode> accessor;

    InterfaceNodeViewApiImpl(OrcsApi orcsApi) {
        this.setAccessor(new InterfaceNodeAccessor(orcsApi));
    }

    @Override
    public ArtifactAccessor<InterfaceNode> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ArtifactAccessor<InterfaceNode> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<InterfaceNode> query(BranchId branch, MimAttributeQuery query) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, InterfaceNode.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceNode>();
        }
    }

    @Override
    public InterfaceNode getNodeForMessage(BranchId branch, ArtifactId message) {
        try {
            return this.getAccessor().getByRelationWithoutId(branch, CoreRelationTypes.InterfaceMessageSendingNode_Message, ArtifactId.valueOf((Long)message.getId()), InterfaceNode.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return (InterfaceNode)PLGenericDBObject.SENTINEL;
        }
    }

    @Override
    public InterfaceNode get(BranchId branch, ArtifactId nodeId) {
        try {
            return this.getAccessor().get(branch, nodeId, InterfaceNode.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return InterfaceNode.SENTINEL;
        }
    }
}

