/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.ws.rs.core.StreamingOutput;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.mim.internal.IcdGenerator;
import org.eclipse.osee.orcs.OrcsApi;

public final class IcdStreamingOutput
implements StreamingOutput {
    private final OrcsApi orcsApi;
    private final BranchId branch;
    private final ArtifactId viewId;
    private final ArtifactId connectionId;

    public IcdStreamingOutput(OrcsApi orcsApi, BranchId branch, ArtifactId viewId, ArtifactId connectionId) {
        this.orcsApi = orcsApi;
        this.branch = branch;
        this.viewId = viewId;
        this.connectionId = connectionId;
    }

    public void write(OutputStream output) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(output);
            IcdGenerator generator = new IcdGenerator(this.orcsApi);
            generator.runOperation(this.orcsApi, writer, this.branch, this.viewId, this.connectionId);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }
}

