/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.Application;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.clientcred.ClientCredentialsGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.code.CodeVerifierTransformer;
import org.apache.cxf.rs.security.oauth2.grants.code.DigestCodeVerifier;
import org.apache.cxf.rs.security.oauth2.grants.owner.ResourceOwnerGrantHandler;
import org.apache.cxf.rs.security.oauth2.grants.owner.ResourceOwnerLoginHandler;
import org.apache.cxf.rs.security.oauth2.grants.refresh.RefreshTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.ResourceOwnerNameProvider;
import org.apache.cxf.rs.security.oauth2.provider.SessionAuthenticityTokenProvider;
import org.apache.cxf.rs.security.oauth2.provider.SubjectCreator;
import org.apache.cxf.rs.security.oauth2.services.AbstractAccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.services.AbstractTokenService;
import org.apache.cxf.rs.security.oauth2.services.AccessTokenService;
import org.apache.cxf.rs.security.oauth2.services.AccessTokenValidatorService;
import org.apache.cxf.rs.security.oauth2.services.AuthorizationCodeGrantService;
import org.apache.cxf.rs.security.oauth2.services.ImplicitGrantService;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;
import org.apache.cxf.rs.security.oauth2.services.TokenRevocationService;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.HawkAccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.NonceStore;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.NonceVerifier;
import org.apache.cxf.rs.security.oauth2.tokens.hawk.NonceVerifierImpl;
import org.eclipse.osee.jaxrs.server.internal.JaxRsResourceManager;
import org.eclipse.osee.jaxrs.server.internal.applications.JaxRsApplicationRegistry;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.ClientProvider;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.OAuth2Application;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.OAuth2Configuration;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.OAuth2DataProvider;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.OAuth2RequestFilter;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.SubjectProvider;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.ClientProviderImpl;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.OAuthEncryption;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.adapters.SubjectProviderImpl;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.AbstractClientService;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.AuthorizationCodeEndpoint;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.ClientEndpoint;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.ClientRegistrationEndpoint;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.endpoints.ImplicitGrantEndpoint;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.writers.AuthorizationDataHtmlWriter;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.writers.ClientRegistrationDataHtmlWriter;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.writers.ClientRegistrationResponseHtmlWriter;
import org.eclipse.osee.jaxrs.server.internal.security.oauth2.provider.writers.OOBAuthorizationResponseHtmlWriter;
import org.eclipse.osee.jaxrs.server.security.JaxRsAuthenticator;
import org.eclipse.osee.jaxrs.server.security.JaxRsOAuth;
import org.eclipse.osee.jaxrs.server.security.JaxRsOAuthStorage;
import org.eclipse.osee.jaxrs.server.security.JaxRsSessionProvider;
import org.eclipse.osee.logger.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OAuth2ServerProvider {
    private static final String OAUTH2_APPLICATION_COMPONENT_NAME = OAuth2ServerProvider.qualify("application");
    private final Set<String> registeredProviders = new HashSet<String>();
    private List<String> audiences;
    private OAuth2DataProvider dataProvider;
    private NonceVerifier nonceVerifier;
    private OAuth2RequestFilter filter;
    private List<AccessTokenGrantHandler> grantHandlers;
    private List<AccessTokenValidator> tokenValidators;
    private Set<Object> endpoints;
    private Application application;
    private Log logger;
    private JaxRsApplicationRegistry registry;
    private JaxRsResourceManager resourceManager;
    private JaxRsAuthenticator authenticator;
    private JaxRsSessionProvider sessionProvider;
    private JaxRsOAuthStorage storage;
    private SubjectProvider subjectProvider;
    private final AtomicBoolean wasRegistered = new AtomicBoolean();
    private Bundle bundle;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setJaxRsApplicationRegistry(JaxRsApplicationRegistry registry) {
        this.registry = registry;
    }

    public void setJaxRsResourceManager(JaxRsResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setJaxRsAuthenticator(JaxRsAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setJaxRsSessionProvider(JaxRsSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    public void setJaxRsOAuthStorage(JaxRsOAuthStorage storage) {
        this.storage = storage;
    }

    private static String qualify(String name) {
        return String.format("%s.security.oauth2.%s", "jaxrs.server", name);
    }

    public void start(BundleContext bundleContext, Map<String, Object> props) {
        this.bundle = bundleContext.getBundle();
        this.update(props);
    }

    public void stop() {
        if (this.wasRegistered.getAndSet(false)) {
            this.deregister(this.registry);
            this.audiences = null;
            this.dataProvider = null;
            this.nonceVerifier = null;
            this.filter = null;
            this.grantHandlers = null;
            this.tokenValidators = null;
            this.endpoints = null;
            this.application = null;
        }
    }

    private void initialize(OAuth2Configuration config) {
        OAuthEncryption serializer = new OAuthEncryption();
        this.subjectProvider = new SubjectProviderImpl(this.logger, this.sessionProvider, this.authenticator, serializer);
        ClientProviderImpl clientProvider = new ClientProviderImpl(this.subjectProvider, this.storage);
        this.audiences = Collections.emptyList();
        this.dataProvider = new OAuth2DataProvider(clientProvider, this.subjectProvider, serializer, this.storage);
        this.filter = new OAuth2RequestFilter(this.logger, this.resourceManager, this.subjectProvider);
        OAuth2ServerProvider.bind((AbstractAccessTokenValidator)this.filter, (OAuthDataProvider)this.dataProvider);
        this.endpoints = new HashSet<Object>();
        this.endpoints.add(OAuth2ServerProvider.bind((AbstractOAuthService)new AccessTokenService(), (OAuthDataProvider)this.dataProvider));
        this.endpoints.add(OAuth2ServerProvider.bind((AbstractOAuthService)new TokenRevocationService(), (OAuthDataProvider)this.dataProvider));
        this.endpoints.add(OAuth2ServerProvider.bind((RedirectionBasedGrantService)new AuthorizationCodeEndpoint(clientProvider), (OAuthDataProvider)this.dataProvider, this.subjectProvider));
        this.endpoints.add(OAuth2ServerProvider.bind((RedirectionBasedGrantService)new ImplicitGrantEndpoint(clientProvider), (OAuthDataProvider)this.dataProvider, this.subjectProvider));
        this.endpoints.add(OAuth2ServerProvider.bind((AbstractAccessTokenValidator)new AccessTokenValidatorService(), (OAuthDataProvider)this.dataProvider));
        this.endpoints.add(OAuth2ServerProvider.bind(new ClientRegistrationEndpoint(this.logger), clientProvider, this.subjectProvider));
        this.endpoints.add(OAuth2ServerProvider.bind(new ClientEndpoint(this.logger), clientProvider, this.subjectProvider));
        this.endpoints.add(new AuthorizationDataHtmlWriter());
        this.endpoints.add(new OOBAuthorizationResponseHtmlWriter());
        this.endpoints.add(new ClientRegistrationDataHtmlWriter());
        this.endpoints.add(new ClientRegistrationResponseHtmlWriter());
        this.application = new OAuth2Application(this.endpoints);
        this.grantHandlers = new ArrayList<AccessTokenGrantHandler>();
        this.grantHandlers.add((AccessTokenGrantHandler)OAuth2ServerProvider.bind(new AuthorizationCodeGrantHandler(), (OAuthDataProvider)this.dataProvider, (CodeVerifierTransformer)new DigestCodeVerifier()));
        this.grantHandlers.add((AccessTokenGrantHandler)OAuth2ServerProvider.bind((AbstractGrantHandler)new ClientCredentialsGrantHandler(), (OAuthDataProvider)this.dataProvider));
        this.grantHandlers.add((AccessTokenGrantHandler)OAuth2ServerProvider.bind(new ResourceOwnerGrantHandler(), (OAuthDataProvider)this.dataProvider, (ResourceOwnerLoginHandler)this.subjectProvider));
        this.grantHandlers.add((AccessTokenGrantHandler)OAuth2ServerProvider.bind(new RefreshTokenGrantHandler(), (OAuthDataProvider)this.dataProvider));
        this.tokenValidators = new ArrayList<AccessTokenValidator>();
        if (config.isHawkTokenSupported()) {
            NonceVerifierImpl nonceVerifier = new NonceVerifierImpl();
            NonceStore nonceStore = null;
            nonceVerifier.setNonceStore(nonceStore);
            HawkAccessTokenValidator validator = new HawkAccessTokenValidator();
            validator.setDataProvider((OAuthDataProvider)this.dataProvider);
            validator.setNonceVerifier((NonceVerifier)nonceVerifier);
            this.tokenValidators.add((AccessTokenValidator)validator);
            this.nonceVerifier = nonceVerifier;
        }
    }

    public void update(Map<String, Object> props) {
        OAuth2Configuration config = OAuth2Configuration.fromProperties(props);
        if (config.isEnabled()) {
            if (!this.wasRegistered.getAndSet(true)) {
                this.initialize(config);
                this.register(this.registry, this.bundle);
            }
            this.configure(config);
        } else {
            this.stop();
        }
    }

    private void register(JaxRsApplicationRegistry registry, Bundle bundle) {
        for (Object object : JaxRsOAuth.getOAuthProviders()) {
            this.addProvider(registry, bundle, OAuth2ServerProvider.qualify(object.getClass().getSimpleName()), object);
        }
        registry.register(OAUTH2_APPLICATION_COMPONENT_NAME, bundle, this.application);
        this.addProvider(registry, bundle, OAuth2ServerProvider.qualify("filter"), (Object)this.filter);
    }

    private void addProvider(JaxRsApplicationRegistry registry, Bundle bundle, String name, Object object) {
        this.registeredProviders.add(name);
        registry.registerProvider(name, bundle, object);
    }

    private void deregister(JaxRsApplicationRegistry registry) {
        registry.deregister(OAUTH2_APPLICATION_COMPONENT_NAME);
        for (String componentName : this.registeredProviders) {
            registry.deregisterProvider(componentName);
        }
        this.registeredProviders.clear();
    }

    private void configure(OAuth2Configuration config) {
        this.configure(config, this.filter);
        this.configure(config, this.subjectProvider);
        this.configure(config, this.dataProvider);
        this.configure(config, this.nonceVerifier);
        for (AccessTokenValidator validator : this.tokenValidators) {
            this.configureObject(config, validator);
        }
        for (AccessTokenGrantHandler handler : this.grantHandlers) {
            this.configureObject(config, handler);
        }
        for (Object endpoint : this.endpoints) {
            this.configureObject(config, endpoint);
        }
    }

    private void configure(OAuth2Configuration config, OAuth2DataProvider provider) {
        provider.setRefreshTokenAllowed(config.isRefreshTokenAllowed());
        provider.setCodeGrantExpiration(config.getCodeGrantExpiration());
        provider.setAccessTokenExpiration(config.getAccessTokenExpiration());
        provider.setRefreshTokenExpiration(config.getRefreshTokenExpiration());
        provider.setSecretKeyAlgorithm(config.getSecretKeyAlgorithm());
        provider.setSecretKeyEncoded(config.getEncodedSecretKey());
        this.configureObject(config, provider);
    }

    private void configure(OAuth2Configuration config, SubjectProvider provider) {
        provider.setSessionTokenExpiration(config.getSessionTokenExpiration());
        provider.setSecretKeyAlgorithm(config.getSecretKeyAlgorithm());
        provider.setSecretKeyEncoded(config.getEncodedSecretKey());
    }

    private void configure(OAuth2Configuration config, NonceVerifier object) {
        if (object instanceof NonceVerifierImpl) {
            NonceVerifierImpl nonceVerifier = (NonceVerifierImpl)object;
            nonceVerifier.setAllowedWindow(config.getNonceAllowedWindow());
        }
        this.configureObject(config, object);
    }

    private void configure(OAuth2Configuration config, OAuth2RequestFilter filter) {
        filter.setAudienceIsEndpointAddress(config.isAudienceIsEndpointAddress());
        filter.setUseUserSubject(config.isUseUserSubject());
        filter.setCheckFormData(config.isFilterChecksFormDataForToken());
        filter.setRealm(config.getRealm());
        filter.setRedirectURI(config.getLoginRedirectURI());
        filter.setRedirectErrorURI(config.getLoginRedirectErrorURI());
        filter.setIgnoreBasePath(config.isIgnoreLoginRedirectBasePath());
        filter.setRealm(config.getRealm());
        this.configureObject(config, (Object)filter);
    }

    private void configureObject(OAuth2Configuration config, Object object) {
        AbstractGrantHandler handler;
        if (object instanceof AbstractGrantHandler) {
            handler = (AbstractGrantHandler)object;
            handler.setCanSupportPublicClients(config.isCanSupportPublicClients());
            handler.setPartialMatchScopeValidation(config.isPartialMatchScopeValidation());
        }
        if (object instanceof RefreshTokenGrantHandler) {
            handler = (RefreshTokenGrantHandler)object;
            handler.setPartialMatchScopeValidation(config.isPartialMatchScopeValidation());
        }
        if (object instanceof AbstractAccessTokenValidator) {
            AbstractAccessTokenValidator validator = (AbstractAccessTokenValidator)object;
            validator.setRealm(config.getRealm());
            validator.setTokenValidators(this.tokenValidators);
        }
        if (object instanceof AbstractOAuthService) {
            AbstractOAuthService service = (AbstractOAuthService)object;
            service.setBlockUnsecureRequests(config.isBlockUnsecureRequests());
            service.setWriteOptionalParameters(config.isWriteOptionalParameters());
        }
        if (object instanceof AbstractTokenService) {
            AbstractTokenService tokenService = (AbstractTokenService)object;
            tokenService.setCanSupportPublicClients(config.isCanSupportPublicClients());
            tokenService.setWriteCustomErrors(config.isWriteCustomErrors());
        }
        if (object instanceof RedirectionBasedGrantService) {
            RedirectionBasedGrantService redirectService = (RedirectionBasedGrantService)object;
            redirectService.setPartialMatchScopeValidation(config.isPartialMatchScopeValidation());
            redirectService.setUseRegisteredRedirectUriIfPossible(config.isUseRegisteredRedirectUriIfPossible());
        }
        if (object instanceof AuthorizationCodeGrantService) {
            AuthorizationCodeGrantService codeGrantService = (AuthorizationCodeGrantService)object;
            codeGrantService.setCanSupportPublicClients(config.isCanSupportPublicClients());
        }
        if (object instanceof ImplicitGrantService) {
            ImplicitGrantService implicitGrant = (ImplicitGrantService)object;
            implicitGrant.setReportClientId(config.isReportClientId());
        }
        if (object instanceof AccessTokenService) {
            AccessTokenService accessTokenService = (AccessTokenService)object;
            accessTokenService.setGrantHandlers(this.grantHandlers);
        }
        if (object instanceof AbstractClientService) {
            AbstractClientService clientService = (AbstractClientService)object;
            clientService.setBlockUnsecureRequests(config.isBlockUnsecureRequests());
        }
    }

    private static AbstractClientService bind(AbstractClientService object, ClientProvider dataProvider, SubjectProvider subjectProvider) {
        object.setDataProvider(dataProvider);
        object.setResourceOwnerNameProvider(subjectProvider);
        object.setSessionAuthenticityTokenProvider(subjectProvider);
        object.setSubjectCreator(subjectProvider);
        return object;
    }

    private static AbstractAccessTokenValidator bind(AbstractAccessTokenValidator object, OAuthDataProvider dataProvider) {
        object.setDataProvider(dataProvider);
        return object;
    }

    private static AbstractOAuthService bind(RedirectionBasedGrantService object, OAuthDataProvider dataProvider, SubjectProvider subjectProvider) {
        object.setResourceOwnerNameProvider((ResourceOwnerNameProvider)subjectProvider);
        object.setSessionAuthenticityTokenProvider((SessionAuthenticityTokenProvider)subjectProvider);
        object.setSubjectCreator((SubjectCreator)subjectProvider);
        OAuth2ServerProvider.bind((AbstractOAuthService)object, dataProvider);
        return object;
    }

    private static AuthorizationCodeGrantHandler bind(AuthorizationCodeGrantHandler object, OAuthDataProvider dataProvider, CodeVerifierTransformer codeVerifier) {
        object.setCodeVerifierTransformer(codeVerifier);
        OAuth2ServerProvider.bind((AbstractGrantHandler)object, dataProvider);
        return object;
    }

    private static ResourceOwnerGrantHandler bind(ResourceOwnerGrantHandler handler, OAuthDataProvider dataProvider, ResourceOwnerLoginHandler loginHandler) {
        handler.setLoginHandler(loginHandler);
        OAuth2ServerProvider.bind((AbstractGrantHandler)handler, dataProvider);
        return handler;
    }

    private static AbstractOAuthService bind(AbstractOAuthService object, OAuthDataProvider dataProvider) {
        object.setDataProvider(dataProvider);
        return object;
    }

    private static RefreshTokenGrantHandler bind(RefreshTokenGrantHandler object, OAuthDataProvider dataProvider) {
        object.setDataProvider(dataProvider);
        return object;
    }

    private static AbstractGrantHandler bind(AbstractGrantHandler object, OAuthDataProvider dataProvider) {
        object.setDataProvider(dataProvider);
        return object;
    }
}

