/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest;

import java.util.Objects;

public final class IdentifierType
extends Enum<IdentifierType> {
    public static final /* enum */ IdentifierType ATTRIBUTE_DEFINITION = new IdentifierType("AD");
    public static final /* enum */ IdentifierType ATTRIBUTE_VALUE = new IdentifierType("AV");
    public static final /* enum */ IdentifierType DATA_TYPE_DEFINITION = new IdentifierType("DD");
    public static final /* enum */ IdentifierType HEADER = new IdentifierType("H");
    public static final /* enum */ IdentifierType SPECIFICATION = new IdentifierType("S");
    public static final /* enum */ IdentifierType SPECIFICATION_TYPE = new IdentifierType("ST");
    public static final /* enum */ IdentifierType SPEC_OBJECT = new IdentifierType("SO");
    public static final /* enum */ IdentifierType SPEC_OBJECT_TYPE = new IdentifierType("SOT");
    private ThreadLocal<Long> identifierCount;
    private String identifierPrefix;
    private ThreadLocal<StringBuilder> stringBuilder;
    private static final /* synthetic */ IdentifierType[] ENUM$VALUES;

    static {
        ENUM$VALUES = new IdentifierType[]{ATTRIBUTE_DEFINITION, ATTRIBUTE_VALUE, DATA_TYPE_DEFINITION, HEADER, SPECIFICATION, SPECIFICATION_TYPE, SPEC_OBJECT, SPEC_OBJECT_TYPE};
    }

    private IdentifierType(String identifierPrefix) {
        assert (Objects.nonNull(identifierPrefix));
        this.identifierPrefix = identifierPrefix;
        this.identifierCount = new ThreadLocal<Long>(){

            @Override
            protected Long initialValue() {
                return 0L;
            }
        };
        this.stringBuilder = new ThreadLocal<StringBuilder>(){

            @Override
            protected StringBuilder initialValue() {
                return new StringBuilder(32);
            }
        };
    }

    Identifier createIdentifier() {
        Long identifierCount = this.identifierCount.get();
        StringBuilder stringBuilder = this.stringBuilder.get();
        stringBuilder.setLength(0);
        stringBuilder.append(this.identifierPrefix).append("-").append(Long.toString(identifierCount, 10));
        Long l = identifierCount;
        identifierCount = l + 1L;
        Identifier identifier = new Identifier(stringBuilder, l, this);
        this.identifierCount.set(identifierCount);
        return identifier;
    }

    public static IdentifierType[] values() {
        IdentifierType[] identifierTypeArray = ENUM$VALUES;
        int n = identifierTypeArray.length;
        IdentifierType[] identifierTypeArray2 = new IdentifierType[n];
        System.arraycopy(ENUM$VALUES, 0, identifierTypeArray2, 0, n);
        return identifierTypeArray2;
    }

    public static IdentifierType valueOf(String string) {
        return Enum.valueOf(IdentifierType.class, string);
    }

    public static class Identifier {
        private final String identifierText;
        private final IdentifierType identifierType;
        private final int hashCode;
        private final Long identifierCount;

        private Identifier(CharSequence text, Long count, IdentifierType type) {
            this.identifierText = text.toString();
            this.identifierType = type;
            this.identifierCount = count;
            this.hashCode = (int)((long)(type.ordinal() << 24) ^ count >> 32 & 0xFFFFFFFFFFFFFFFFL ^ count & 0xFFFFFFFFFFFFFFFFL);
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Identifier && this.identifierCount == ((Identifier)obj).identifierCount && this.identifierType == ((Identifier)obj).identifierType;
        }

        long getCount() {
            return this.identifierCount;
        }

        String getText() {
            return this.identifierText;
        }

        public IdentifierType getType() {
            return this.identifierType;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.identifierText;
        }
    }
}

