/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.synchronization.rest.AbstractGroveThing;
import org.eclipse.osee.synchronization.rest.AttributeDefinitionGroveThing;
import org.eclipse.osee.synchronization.rest.GroveThing;
import org.eclipse.osee.synchronization.rest.IdentifierType;
import org.eclipse.osee.synchronization.util.IndentedString;

public class CommonObjectTypeGroveThing
extends AbstractGroveThing {
    Map<IdentifierType.Identifier, AttributeDefinitionGroveThing> attributeDefinitionMap;

    CommonObjectTypeGroveThing(IdentifierType.Identifier identifier) {
        super(identifier);
        assert (identifier.getType() == IdentifierType.SPECIFICATION_TYPE || identifier.getType() == IdentifierType.SPEC_OBJECT_TYPE);
        this.attributeDefinitionMap = new HashMap<IdentifierType.Identifier, AttributeDefinitionGroveThing>();
    }

    void add(AttributeDefinitionGroveThing attributeDefinitionGroveThing) {
        assert (attributeDefinitionGroveThing != null);
        this.attributeDefinitionMap.put(attributeDefinitionGroveThing.getGroveThingKey(), attributeDefinitionGroveThing);
    }

    @Override
    public GroveThing setNativeThing(Object nativeThing) {
        assert (nativeThing instanceof ArtifactTypeToken);
        return super.setNativeThing(nativeThing);
    }

    public Stream<AttributeDefinitionGroveThing> streamAttributeDefinitions() {
        return this.attributeDefinitionMap.values().stream();
    }

    @Override
    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString(indent + 0);
        String indent1 = IndentedString.indentString(indent + 1);
        String name = this.getClass().getName();
        String attributeListString = this.attributeDefinitionMap.values().stream().map(AbstractGroveThing::getGroveThingKey).map(IdentifierType.Identifier::toString).collect(Collectors.joining(","));
        outMessage.append(indent0).append(name).append(":").append("\n").append(indent1).append("Attributes: ").append(attributeListString).append("\n");
        return outMessage;
    }
}

