/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.osee.synchronization.rest.DuplicateGroveEntry;
import org.eclipse.osee.synchronization.rest.Grove;
import org.eclipse.osee.synchronization.rest.GroveThing;
import org.eclipse.osee.synchronization.rest.IdentifierType;
import org.eclipse.osee.synchronization.rest.SynchronizationArtifactBuilder;
import org.eclipse.osee.synchronization.util.IndentedString;
import org.eclipse.osee.synchronization.util.ToMessage;

public class AbstractMapGrove
implements Grove,
ToMessage {
    protected final IdentifierType identifierType;
    protected final Map<IdentifierType.Identifier, GroveThing> map;
    protected final Map<Long, GroveThing> nativeKeyMap;

    protected AbstractMapGrove(IdentifierType identifierType) {
        this.identifierType = Objects.requireNonNull(identifierType);
        this.map = new HashMap<IdentifierType.Identifier, GroveThing>();
        this.nativeKeyMap = new HashMap<Long, GroveThing>();
    }

    @Override
    public GroveThing add(GroveThing groveThing) {
        Objects.requireNonNull(groveThing);
        IdentifierType.Identifier groveThingKey = groveThing.getGroveThingKey();
        assert (Objects.nonNull(groveThingKey));
        if (this.map.containsKey(groveThingKey)) {
            throw new DuplicateGroveEntry(this, groveThing);
        }
        this.map.put(groveThingKey, groveThing);
        groveThing.getNativeKey().ifPresent(nativeKey -> {
            GroveThing groveThing2 = this.nativeKeyMap.put((Long)nativeKey, groveThing);
        });
        return groveThing;
    }

    @Override
    public boolean contains(Long nativeKey) {
        return this.nativeKeyMap.containsKey(nativeKey);
    }

    @Override
    public void createForeignThings(SynchronizationArtifactBuilder synchronizationArtifactBuilder) {
        if (this.map.size() == 0) {
            return;
        }
        Optional<Consumer<GroveThing>> converterOptional = synchronizationArtifactBuilder.getConverter(this.identifierType);
        converterOptional.ifPresent(converter -> this.map.values().forEach(converter::accept));
    }

    @Override
    public GroveThing get(IdentifierType.Identifier groveThingKey) {
        return this.map.get(groveThingKey);
    }

    @Override
    public Optional<GroveThing> getByNativeKey(Long nativeKey) {
        return Optional.ofNullable(this.nativeKeyMap.get(nativeKey));
    }

    @Override
    public IdentifierType getType() {
        return this.identifierType;
    }

    @Override
    public Stream<GroveThing> stream() {
        return this.map.values().stream();
    }

    @Override
    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString(indent + 0);
        String indent1 = IndentedString.indentString(indent + 1);
        String indent2 = IndentedString.indentString(indent + 2);
        String name = this.getClass().getName();
        outMessage.append(indent0).append(name).append(":").append("\n");
        this.map.values().forEach(groveThing -> {
            String abstractObjectTypeName = groveThing.getClass().getName();
            outMessage.append(indent1).append(abstractObjectTypeName).append(":").append("\n").append(indent2).append("Key:          ").append(groveThing.getGroveThingKey()).append("\n").append(indent2).append("Grove Thing:").append("\n");
            groveThing.toMessage(indent + 3, outMessage);
            outMessage.append(indent2).append("Native Thing: ").append(groveThing.getNativeThing()).append("\n");
        });
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

