/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.importing.ReqNumbering;
import org.eclipse.osee.framework.skynet.core.importing.RoughAttributeSet;
import org.eclipse.osee.framework.skynet.core.internal.Activator;

public class RoughArtifact {
    private RoughArtifact roughParent;
    private ReqNumbering number;
    private String guid;
    private ArtifactTypeToken artifactType;
    private final RoughAttributeSet attributes = new RoughAttributeSet();
    private final Collection<RoughArtifact> children = new ArrayList<RoughArtifact>();

    public RoughArtifact(ArtifactTypeToken artifactType, String name) {
        this.artifactType = artifactType;
        this.setName(name);
    }

    public RoughArtifact(ArtifactTypeToken artifactType) {
        this(artifactType, "unnamed");
    }

    public RoughArtifact() {
        this(ArtifactTypeToken.SENTINEL);
    }

    public void setName(String name) {
        this.attributes.setAttribute(CoreAttributeTypes.Name.getName(), name);
    }

    public void clear() {
        this.attributes.clear();
        this.children.clear();
        this.guid = null;
        this.number = null;
        this.roughParent = null;
    }

    public Set<String> getAttributeTypeNames() {
        return this.attributes.getAttributeTypeNames();
    }

    public boolean hasHierarchicalRelation() {
        return this.number != null;
    }

    public void addChild(RoughArtifact child) {
        child.roughParent = this;
        this.children.add(child);
    }

    public boolean hasParent() {
        return this.roughParent != null;
    }

    public RoughArtifact getRoughParent() {
        return this.roughParent;
    }

    public void addAttribute(AttributeTypeToken attrType, String value) {
        this.addAttribute(attrType.getName(), value);
    }

    public void setAttribute(String typeName, String value) {
        this.attributes.setAttribute(typeName, value);
    }

    public void addAttribute(String typeName, String value) {
        if (this.isEnumeration(typeName)) {
            if (this.isMultipleEnum(typeName, value)) {
                this.attributes.addAttribute(typeName, this.getEnumValues(value));
            } else {
                this.attributes.addAttribute(typeName, value.trim());
            }
        } else {
            this.attributes.addAttribute(typeName, value);
        }
    }

    public void addAttribute(String name, URI uri) {
        this.attributes.addAttribute(name, uri);
    }

    public void addAttribute(AttributeTypeToken attributeType, URI uri) {
        this.addAttribute(attributeType.getName(), uri);
    }

    public Collection<URI> getURIAttributes() {
        return this.attributes.getURIAttributes();
    }

    private String[] getEnumValues(String value) {
        String[] data = value.split(",");
        int index = 0;
        while (index < data.length) {
            data[index] = data[index].trim();
            ++index;
        }
        return data;
    }

    private boolean isEnumeration(String typeName) {
        boolean result = false;
        AttributeTypeToken type = AttributeTypeManager.getType(typeName);
        result = type.isEnumerated();
        return result;
    }

    private boolean isMultipleEnum(String typeName, String value) {
        boolean result = false;
        try {
            AttributeTypeToken attributeType = AttributeTypeManager.getType(typeName);
            if (attributeType.isEnumerated() && this.artifactType.getMax(attributeType) > 1 && value.contains(",")) {
                result = true;
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return result;
    }

    public boolean isChild(RoughArtifact otherArtifact) {
        return this.number.isChild(otherArtifact.number);
    }

    public String toString() {
        return this.getName();
    }

    public void setSectionNumber(String number) {
        this.number = new ReqNumbering(number);
    }

    public ReqNumbering getSectionNumber() {
        return this.number;
    }

    public RoughAttributeSet getAttributes() {
        return this.attributes;
    }

    public Collection<RoughArtifact> getChildren() {
        return this.children;
    }

    public Collection<RoughArtifact> getDescendants() {
        ArrayList<RoughArtifact> decendants = new ArrayList<RoughArtifact>();
        for (RoughArtifact child : this.getChildren()) {
            if (!this.equals(child.roughParent)) continue;
            decendants.add(child);
        }
        return decendants;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getGuid() {
        return this.guid;
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public String getName() {
        return this.attributes.getSoleAttributeValue(CoreAttributeTypes.Name.getName());
    }

    public String getRoughAttribute(String attributeName) {
        return this.attributes.getSoleAttributeValue(attributeName);
    }

    public void setArtifactType(ArtifactTypeToken artifactType) {
        this.artifactType = artifactType;
    }
}

