/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.httpRequests;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.client.server.HttpRequest;
import org.eclipse.osee.framework.core.client.server.HttpResponse;
import org.eclipse.osee.framework.core.client.server.IHttpServerRequest;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.IHealthStatus;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.internal.Activator;

public class ClientDashboardRequestHandler
implements IHttpServerRequest {
    public String getRequestType() {
        return "osee/request";
    }

    public void processRequest(HttpRequest httpRequest, HttpResponse httpResponse) {
        String cmd = httpRequest.getParameter("cmd");
        try {
            if (Strings.isValid((String)cmd)) {
                RequestCmd requestCmd = RequestCmd.valueOf(cmd);
                switch (requestCmd) {
                    case log: {
                        this.sendLog(httpRequest, httpResponse);
                        break;
                    }
                    case info: {
                        this.sendResults(this.getInfoString(), httpRequest, httpResponse);
                        break;
                    }
                    case pingId: {
                        this.sendResults(ClientSessionManager.getSession().getId(), httpRequest, httpResponse);
                        break;
                    }
                }
            } else {
                httpResponse.outputStandardError(400, String.format("Unable to process request: [%s]", httpRequest.getRawRequest()));
            }
        }
        catch (Exception ex) {
            httpResponse.outputStandardError(400, String.format("Unable to process request: [%s]", "Exception processing request: " + ex.getLocalizedMessage()));
        }
    }

    private String getInfoString() {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("\nName: [" + UserManager.getUser().getName() + "]\n");
        sb.append(ClientSessionManager.getSession().toString().replaceAll("] ", "]\n"));
        sb.append("\nOSEE Data Path: [" + OseeData.getPath() + "]");
        sb.append("\nInstallation Location: [" + Platform.getInstallLocation().getURL() + "]");
        for (IHealthStatus status : OseeLog.getStatus()) {
            sb.append("\n" + status.getSourceName() + ": [" + status.getMessage() + "]");
        }
        sb.append("\nRemote Event Service Connected: [" + OseeEventManager.isEventManagerConnected() + "]");
        return sb.toString();
    }

    private List<File> getLogFiles() {
        ArrayList<File> files = new ArrayList<File>();
        File file = Platform.getLogFileLocation().removeFileExtension().toFile();
        if ((file = new File(file, ".bak_0.log")).exists()) {
            files.add(file);
        }
        if ((file = Platform.getLogFileLocation().toFile()) != null && file.exists()) {
            files.add(file);
        }
        return files;
    }

    private void sendLog(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        List<File> files = this.getLogFiles();
        StringBuffer sb = new StringBuffer(String.valueOf(this.getInfoString()) + "\n");
        if (files.isEmpty()) {
            sb.append("No [.log] file found");
            this.sendResults(sb.toString(), httpRequest, httpResponse);
        } else {
            try {
                try {
                    sb.append("\n------------------------------------------\n-- Log File Contents (oldest at bottom) --\n------------------------------------------\n");
                    int length = sb.length();
                    for (File file : files) {
                        length = (int)((long)length + file.length());
                    }
                    httpResponse.setContentType("text/plain");
                    httpResponse.setContentEncoding("UTF-8");
                    httpResponse.sendResponseHeaders(200, (long)length);
                    try (BufferedOutputStream outputStream = null;){
                        outputStream = new BufferedOutputStream(httpResponse.getOutputStream());
                        Lib.inputStreamToOutputStream((InputStream)new ByteArrayInputStream(sb.toString().getBytes("UTF-8")), (OutputStream)outputStream);
                        for (File file : files) {
                            try (FileInputStream inputStream = new FileInputStream(file);){
                                Lib.inputStreamToOutputStream((InputStream)inputStream, (OutputStream)outputStream);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error processing request for [%s]", (Object[])new Object[]{httpRequest.toString()});
                    httpResponse.getPrintStream().println(Lib.exceptionToString((Exception)ex));
                    httpResponse.getOutputStream().flush();
                    httpResponse.getOutputStream().close();
                }
            }
            finally {
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
            }
        }
    }

    private void sendResults(String results, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        try {
            try {
                httpResponse.setContentEncoding("UTF-8");
                httpResponse.setContentType("text/plain");
                httpResponse.sendResponseHeaders(200, (long)results.length());
                httpResponse.getPrintStream().println(results);
            }
            catch (Exception ex) {
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error processing request for [%s]", (Object[])new Object[]{httpRequest.toString()});
                httpResponse.getPrintStream().println(Lib.exceptionToString((Exception)ex));
                httpResponse.getOutputStream().flush();
                httpResponse.getOutputStream().close();
            }
        }
        finally {
            httpResponse.getOutputStream().flush();
            httpResponse.getOutputStream().close();
        }
    }

    private static enum RequestCmd {
        log,
        info,
        pingId;

    }
}

