/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.IBasicGuidRelation;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.internal.Activator;

public class ArtifactTypeEventFilter
implements IEventFilter {
    private final Collection<ArtifactTypeToken> artifactTypes;

    public ArtifactTypeEventFilter(ArtifactTypeToken ... artifactTypes) {
        this.artifactTypes = Arrays.asList(artifactTypes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isMatchArtifacts(List<? extends DefaultBasicGuidArtifact> guidArts) {
        try {
            for (DefaultBasicGuidArtifact defaultBasicGuidArtifact : guidArts) {
                ArtifactTypeToken typeToken = defaultBasicGuidArtifact.getArtifactType();
                for (ArtifactTypeId artifactTypeId : this.artifactTypes) {
                    if (typeToken.inheritsFrom(artifactTypeId)) {
                        return true;
                    }
                    for (ArtifactTypeToken matchArtType : this.artifactTypes) {
                        if (!matchArtType.equals(typeToken)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Exception exception) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)exception);
        }
        return false;
    }

    @Override
    public boolean isMatchRelationArtifacts(List<? extends IBasicGuidRelation> relations) {
        for (IBasicGuidRelation iBasicGuidRelation : relations) {
            if (!this.isMatchArtifacts(Arrays.asList(iBasicGuidRelation.getArtA(), iBasicGuidRelation.getArtB()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMatch(BranchId branch) {
        return true;
    }
}

