/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client.internal;

import java.net.InetAddress;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.client.AnonymousCredentialProvider;
import org.eclipse.osee.framework.core.client.BaseCredentialProvider;
import org.eclipse.osee.framework.core.client.ICredentialProvider;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.client.internal.Activator;
import org.eclipse.osee.framework.core.client.server.HttpServer;
import org.eclipse.osee.framework.core.data.IdeClientSession;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.data.OseeSessionGrant;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.exception.OseeAuthenticationRequiredException;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.logging.BaseStatus;
import org.eclipse.osee.framework.logging.IHealthStatus;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.server.ide.api.SessionEndpoint;

public class InternalClientSessionManager {
    public static final String STATUS_ID = "Session Manager";
    private static final InternalClientSessionManager instance = new InternalClientSessionManager();
    private OseeSessionGrant oseeSessionGrant;
    private IdeClientSession oseeSession;
    private SessionEndpoint sessionEndpoint;
    private final UserService userService = ((OseeClient)OsgiUtil.getService(this.getClass(), OseeClient.class)).userService();

    private InternalClientSessionManager() {
    }

    public static InternalClientSessionManager getInstance() {
        if (InternalClientSessionManager.instance.sessionEndpoint == null) {
            InternalClientSessionManager.instance.sessionEndpoint = ((OseeClient)OsgiUtil.getService(InternalClientSessionManager.class, OseeClient.class)).getSessionEndpoint();
        }
        return instance;
    }

    public boolean isSessionValid() {
        return this.oseeSession != null;
    }

    public OseeSessionGrant getDatabaseInfo() {
        return this.getOseeSessionGrant();
    }

    public OseeSessionGrant getOseeSessionGrant() {
        this.ensureSessionCreated();
        if (this.isSessionValid()) {
            return this.oseeSessionGrant;
        }
        throw new OseeAuthenticationRequiredException("Session is invalid - authentication is required", new Object[0]);
    }

    public IdeClientSession getOseeSession() {
        this.ensureSessionCreated();
        if (this.isSessionValid()) {
            return this.oseeSession;
        }
        throw new OseeAuthenticationRequiredException("Session is invalid - authentication is required", new Object[0]);
    }

    public void authenticateAsAnonymous() {
        this.authenticate(new AnonymousCredentialProvider());
    }

    public IdeClientSession getSafeSession() {
        IdeClientSession session = new IdeClientSession();
        session.setId("Invalid");
        try {
            session.setClientName(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            session.setClientName(HttpServer.getServerAddressForExternalCommunication());
        }
        session.setClientAddress(HttpServer.getServerAddressForExternalCommunication());
        session.setUserId("N/A");
        session.setClientPort(String.valueOf(HttpServer.getDefaultServicePort()));
        session.setClientVersion(OseeCodeVersion.getVersion());
        session.setAuthenticationProtocol("N/A");
        return session;
    }

    public synchronized void authenticate(ICredentialProvider credentialProvider) {
        if (!this.isSessionValid()) {
            block6: {
                this.userService.setUserLoading(true);
                OseeCredential credential = credentialProvider.getCredential();
                this.clearData();
                this.oseeSessionGrant = this.getSessionEndpoint().createIdeClientSession(credential);
                if (this.oseeSessionGrant != null) break block6;
                this.userService.setUserLoading(false);
                return;
            }
            try {
                try {
                    this.oseeSession = new IdeClientSession();
                    this.oseeSession.setId(this.oseeSessionGrant.getSessionId());
                    this.oseeSession.setClientName(InetAddress.getLocalHost().getHostName());
                    this.oseeSession.setClientAddress(HttpServer.getServerAddressForExternalCommunication());
                    this.oseeSession.setUserId(this.oseeSessionGrant.getUserToken().getUserId());
                    this.oseeSession.setClientPort(String.valueOf(HttpServer.getDefaultServicePort()));
                    this.oseeSession.setClientVersion(OseeCodeVersion.getVersion());
                    this.oseeSession.setAuthenticationProtocol(this.oseeSessionGrant.getAuthenticationProtocol());
                    this.oseeSession.setUseOracleHints(String.valueOf(this.oseeSessionGrant.getUseOracleHints()));
                }
                catch (Exception ex) {
                    OseeLog.reportStatus((IHealthStatus)new BaseStatus(STATUS_ID, Level.SEVERE, (Throwable)ex));
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                    this.userService.setUserLoading(false);
                }
            }
            catch (Throwable throwable) {
                this.userService.setUserLoading(false);
                throw throwable;
            }
            this.userService.setUserLoading(false);
            OseeLog.reportStatus((IHealthStatus)new BaseStatus(STATUS_ID, Level.INFO, "%s", new Object[]{this.oseeSession}));
        }
    }

    public void ensureSessionCreated() {
        if (!this.isSessionValid()) {
            try {
                this.authenticate(new BaseCredentialProvider(){

                    @Override
                    public OseeCredential getCredential() {
                        OseeCredential credential = super.getCredential();
                        String userName = OseeProperties.isInDbInit() ? SystemUser.OseeSystem.getName() : System.getProperty("user.name", SystemUser.Anonymous.getName());
                        credential.setUserName(userName);
                        credential.setPassword("");
                        return credential;
                    }
                });
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                try {
                    this.authenticateAsAnonymous();
                }
                catch (Exception ex1) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex1);
                }
            }
        }
    }

    public void releaseSession() {
        if (this.isSessionValid()) {
            this.getSessionEndpoint().releaseIdeClientSession(this.getOseeSessionGrant().getSessionId());
            this.clearData();
        }
    }

    public List<String> getAuthenticationProtocols() {
        this.userService.setUserLoading(true);
        List ideClientProtocols = this.getSessionEndpoint().getIdeClientProtocols();
        this.userService.setUserLoading(false);
        return ideClientProtocols;
    }

    private void clearData() {
        this.oseeSession = null;
        this.oseeSessionGrant = null;
    }

    private SessionEndpoint getSessionEndpoint() {
        return this.sessionEndpoint;
    }
}

