/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.jobs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ote.define.operations.RemoteResourceRequestOperation;

public class RemoteResourceRequestJob
extends Job {
    private static final String JOB_NAME = "Download Resource";
    private final String urlRequest;
    private final String targetFileName;
    private IFile downloaded;

    public RemoteResourceRequestJob(String urlRequest, String targetFileName) {
        super(JOB_NAME);
        this.urlRequest = urlRequest;
        this.targetFileName = targetFileName;
        this.setUser(false);
        this.setPriority(30);
    }

    public IFile getDownloadedFile() {
        return this.downloaded;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.CANCEL_STATUS;
        try {
            RemoteResourceRequestOperation remoteRequest = new RemoteResourceRequestOperation("TEMP", this.urlRequest, this.targetFileName);
            remoteRequest.execute(monitor);
            this.downloaded = remoteRequest.getResults();
            status = Status.OK_STATUS;
        }
        catch (Exception ex) {
            status = new Status(4, "org.eclipse.osee.ote.define", String.format("Error downloading resource [%s]", this.targetFileName), (Throwable)ex);
        }
        return status;
    }
}

