/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerCells;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public abstract class XViewerLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
IXViewerLabelProvider {
    private final XViewer viewer;
    private final Map<Integer, XViewerColumn> indexToXViewerColumnMap = new HashMap<Integer, XViewerColumn>();

    @Override
    public XViewerColumn getTreeColumnOffIndex(int columnIndex) {
        XViewerColumn xViewerColumn;
        if (!this.indexToXViewerColumnMap.containsKey(columnIndex) && (xViewerColumn = this.viewer.getXTreeColumn(columnIndex)) != null) {
            this.indexToXViewerColumnMap.put(columnIndex, xViewerColumn);
        }
        return this.indexToXViewerColumnMap.get(columnIndex);
    }

    @Override
    public void clearXViewerColumnIndexCache() {
        this.indexToXViewerColumnMap.clear();
    }

    public XViewerLabelProvider(XViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image;
        XViewerColumn xViewerColumn;
        block4: {
            try {
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (xViewerColumn.isShow()) break block4;
                return null;
            }
            catch (Exception ex) {
                XViewerLog.log(Activator.class, Level.SEVERE, ex);
                return null;
            }
        }
        if (xViewerColumn instanceof IXViewerValueColumn && (image = ((IXViewerValueColumn)xViewerColumn).getColumnImage(element, xViewerColumn, columnIndex)) != null) {
            return image;
        }
        return this.getColumnImage(element, xViewerColumn, columnIndex);
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        XViewerColumn xViewerColumn;
        block9: {
            block8: {
                try {
                    xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                    if (xViewerColumn.isShow()) break block8;
                    return "";
                }
                catch (Exception ex) {
                    return XViewerCells.getCellExceptionString(ex);
                }
            }
            if (xViewerColumn instanceof IXViewerPreComputedColumn) {
                IXViewerPreComputedColumn preComputedColumn = (IXViewerPreComputedColumn)xViewerColumn;
                String result = XViewerLabelProvider.getPrecomputedText(element, xViewerColumn, preComputedColumn, true);
                return result;
            }
            if (!(xViewerColumn instanceof IXViewerValueColumn)) break block9;
            Long startTime = this.viewer.isDebugLoading() ? new Date().getTime() : 0L;
            IXViewerValueColumn xViewerValueColumn = (IXViewerValueColumn)xViewerColumn;
            String str = xViewerValueColumn.getColumnText(element, xViewerColumn, columnIndex);
            if (this.viewer.isDebugLoading()) {
                xViewerColumn.addElapsedTime(Long.valueOf(new Date().getTime() - startTime));
            }
            if (str != null) {
                return str;
            }
            return "";
        }
        Long startTime = this.viewer.isDebugLoading() ? new Date().getTime() : 0L;
        String value = this.getColumnText(element, xViewerColumn, columnIndex);
        if (this.viewer.isDebugLoading()) {
            xViewerColumn.addElapsedTime(Long.valueOf(new Date().getTime() - startTime));
        }
        return value;
    }

    public static String getPrecomputedText(Object element, XViewerColumn xViewerColumn, IXViewerPreComputedColumn preComputedColumn, boolean debugLoading) {
        Long key = preComputedColumn.getKey(element);
        String cachedValue = xViewerColumn.getPreComputedValue(key);
        Long startTime = debugLoading ? new Date().getTime() : 0L;
        String result = ((IXViewerPreComputedColumn)xViewerColumn).getText(element, key, cachedValue);
        if (result == null) {
            preComputedColumn.populateCachedValues(Collections.singleton(element), xViewerColumn.getPreComputedValueMap());
            result = xViewerColumn.getPreComputedValue(key);
            if (debugLoading) {
                xViewerColumn.addElapsedTime(Long.valueOf(new Date().getTime() - startTime));
            }
            if (result == null) {
                xViewerColumn.getPreComputedValueMap().put(key, "");
            }
        }
        return result;
    }

    public Color getSearchBackground(Object element, int columnIndex) {
        String text = this.getColumnText(element, columnIndex);
        if (this.viewer.searchMatch(text)) {
            return this.viewer.getSearchMatchColor();
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        Color color;
        XViewerColumn xViewerColumn;
        block5: {
            try {
                Color searchColor = null;
                if (this.viewer.isSearch() && (searchColor = this.getSearchBackground(element, columnIndex)) != null) {
                    return searchColor;
                }
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (xViewerColumn.isShow()) break block5;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (xViewerColumn instanceof IXViewerValueColumn && (color = ((IXViewerValueColumn)xViewerColumn).getBackground(element, xViewerColumn, columnIndex)) != null) {
            return color;
        }
        return this.getBackground(element, xViewerColumn, columnIndex);
    }

    public Color getForeground(Object element, int columnIndex) {
        Color color;
        XViewerColumn xViewerColumn;
        block4: {
            try {
                xViewerColumn = this.getTreeColumnOffIndex(columnIndex);
                if (xViewerColumn.isShow()) break block4;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (xViewerColumn instanceof IXViewerValueColumn && (color = ((IXViewerValueColumn)xViewerColumn).getForeground(element, xViewerColumn, columnIndex)) != null) {
            return color;
        }
        return this.getForeground(element, xViewerColumn, columnIndex);
    }

    public Color getBackground(Object element, XViewerColumn xCol, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, XViewerColumn xCol, int columnIndex) {
        return null;
    }

    public abstract Image getColumnImage(Object var1, XViewerColumn var2, int var3) throws Exception;

    @Override
    public abstract String getColumnText(Object var1, XViewerColumn var2, int var3) throws Exception;

    @Override
    public Object getBackingData(Object element, XViewerColumn xViewerColumn, int columnIndex) throws Exception {
        block4: {
            try {
                if (xViewerColumn.isShow()) break block4;
                return "";
            }
            catch (Exception ex) {
                return XViewerCells.getCellExceptionString(ex);
            }
        }
        if (xViewerColumn instanceof IXViewerValueColumn) {
            return ((IXViewerValueColumn)xViewerColumn).getBackingData(element, xViewerColumn, columnIndex);
        }
        return null;
    }

    @Override
    public int getColumnGradient(Object element, XViewerColumn xCol, int columnIndex) throws Exception {
        return 0;
    }
}

