/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.util.IConsoleInputListener;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.internal.UiPluginConstants;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class OseeConsole {
    private IOConsoleOutputStream streamOut = null;
    private IOConsoleOutputStream streamErr = null;
    private IOConsoleOutputStream streamPrompt = null;
    private final IOConsole console;
    private final HandleInput inputHandler;
    private final boolean time;
    private final Thread thread;
    private final boolean newline;
    public static final int CONSOLE_ERROR = 0;
    public static final int CONSOLE_OUT = 1;
    public static final int CONSOLE_PROMPT = 2;

    public OseeConsole(String title) {
        this(title, true, true);
    }

    public OseeConsole(String title, boolean time, boolean newline) {
        this.console = new IOConsole(title, null);
        this.time = time;
        this.newline = newline;
        this.inputHandler = new HandleInput();
        this.thread = new Thread(this.inputHandler);
        this.thread.setName("Osee console input handler");
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                OseeConsole.this.streamOut = OseeConsole.this.console.newOutputStream();
                OseeConsole.this.streamOut.setColor(Displays.getSystemColor((int)2));
                OseeConsole.this.streamOut.setActivateOnWrite(false);
                OseeConsole.this.streamErr = OseeConsole.this.console.newOutputStream();
                OseeConsole.this.streamErr.setColor(Displays.getSystemColor((int)3));
                OseeConsole.this.streamErr.setActivateOnWrite(false);
                OseeConsole.this.streamPrompt = OseeConsole.this.console.newOutputStream();
                OseeConsole.this.streamPrompt.setColor(Displays.getSystemColor((int)9));
                OseeConsole.this.streamPrompt.setActivateOnWrite(false);
            }
        });
        this.thread.start();
    }

    public PrintStream getPrintStream() {
        return new PrintStream((OutputStream)this.streamOut);
    }

    public void shutdown() {
        block5: {
            this.thread.interrupt();
            try {
                try {
                    this.thread.join(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.console});
                    break block5;
                }
            }
            catch (Throwable throwable) {
                ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.console});
                throw throwable;
            }
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.console});
        }
    }

    public void write(String str) {
        this.write(str, false);
    }

    public void writeError(String str) {
        this.write(str, 0, true);
    }

    public void write(String str, boolean popup) {
        this.write(str, 1, popup);
    }

    public void write(String str, int type) {
        this.write(str, type, false);
    }

    public void write(String str, int type, boolean popup) {
        String time = "";
        if (this.time) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            time = cal.get(10) == 0 ? "12" : "" + cal.get(10);
            time = Lib.padLeading((String)time, (char)'0', (int)2);
            String minute = "" + cal.get(12);
            minute = Lib.padLeading((String)minute, (char)'0', (int)2);
            time = String.valueOf(time) + ":" + minute + " => ";
        }
        try {
            this.sendToStreams(type, time);
            if (str.length() > 100000) {
                int i = 0;
                while (i < str.length()) {
                    int endIndex = i + 100000;
                    endIndex = endIndex > str.length() ? str.length() : endIndex;
                    String chunk = str.substring(i, endIndex);
                    this.sendToStreams(type, chunk);
                    i = endIndex;
                }
            } else {
                this.sendToStreams(type, str);
            }
            if (this.newline) {
                this.sendToStreams(type, "\n");
            }
            if (popup) {
                this.popup();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void prompt(String str) throws IOException {
        this.sendToStreams(2, str);
    }

    private void sendToStreams(int type, String str) throws IOException {
        if (type == 0 && this.streamErr != null) {
            this.streamErr.write(str);
        }
        if (type == 2 && this.streamPrompt != null) {
            this.streamPrompt.write(str);
        }
        if (type == 1 && this.streamOut != null) {
            this.streamOut.write(str);
        }
    }

    public void popup() {
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this.console);
    }

    public void addInputListener(IConsoleInputListener listener) {
        this.inputHandler.addListener(listener);
    }

    public void removeInputListener(IConsoleInputListener listener) {
        this.inputHandler.removeListener(listener);
    }

    private class HandleInput
    implements Runnable {
        private final CopyOnWriteArrayList<IConsoleInputListener> listeners = new CopyOnWriteArrayList();

        public void addListener(IConsoleInputListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(IConsoleInputListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void run() {
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)OseeConsole.this.console.getInputStream()));
            try {
                String line = null;
                while ((line = input.readLine()) != null) {
                    for (IConsoleInputListener listener : this.listeners) {
                        listener.lineRead(line);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            OseeLog.log(UiPluginConstants.class, (Level)Level.INFO, (String)"done with the handling of input");
        }
    }
}

