/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.HashSet;
import org.eclipse.osee.ats.ide.world.search.MultipleIdSearchData;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.MutableBoolean;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.branch.BranchSelectionDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryCheckDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class MultipleIdSearchUi {
    private final MultipleIdSearchData data;
    private boolean multiLine;

    public MultipleIdSearchUi(MultipleIdSearchData data) {
        this.data = data;
    }

    public boolean getInput() {
        MutableBoolean result = new MutableBoolean(false);
        Displays.pendInDisplayThread((Runnable)new EntryJob(result));
        return result.getValue();
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public String processEntry(String entry) {
        String result = entry;
        if (this.multiLine) {
            HashSet<String> entries = new HashSet<String>(50);
            String[] stringArray = entry.split(System.getProperty("line.separator"));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                line = line.replaceFirst("^ +", "");
                line = line.replaceFirst(" +$", "");
                entries.add(line);
                ++n2;
            }
            result = Collections.toString((String)",", entries);
        }
        return result;
    }

    private final class EntryJob
    implements Runnable {
        private final MutableBoolean result;

        public EntryJob(MutableBoolean result) {
            this.result = result;
        }

        @Override
        public void run() {
            int response;
            String msg = String.format("Enter ATS IDs or Legacy IDs, %s", MultipleIdSearchUi.this.multiLine ? "one per line" : "comma delimited", "Include ArtIds");
            EntryCheckDialog ed = new EntryCheckDialog(MultipleIdSearchUi.this.data.getName(), msg, "Include ArtIds");
            if (MultipleIdSearchUi.this.multiLine) {
                ed.setFillVertically(true);
            }
            if ((response = ed.open()) == 0) {
                String entry = MultipleIdSearchUi.this.processEntry(ed.getEntry());
                MultipleIdSearchUi.this.data.setEnteredIds(entry);
                if (ed instanceof EntryCheckDialog) {
                    MultipleIdSearchUi.this.data.setIncludeArtIds(ed.isChecked());
                    if (MultipleIdSearchUi.this.data.isIncludeArtIds()) {
                        MultipleIdSearchUi.this.data.setBranch((BranchId)BranchSelectionDialog.getBranchFromUser());
                    }
                    this.result.setValue(true);
                }
                if (!Strings.isValid((String)MultipleIdSearchUi.this.data.getEnteredIds())) {
                    AWorkbench.popup((String)"Must Enter Valid Id");
                } else if (MultipleIdSearchUi.this.data.getEnteredIds().equals("oseerocks") || MultipleIdSearchUi.this.data.getEnteredIds().equals("osee rocks")) {
                    AWorkbench.popup((String)"Confirmation", (String)"Confirmed!  Osee Rocks!");
                } else if (MultipleIdSearchUi.this.data.getEnteredIds().equals("purple icons")) {
                    AWorkbench.popup((String)"Confirmation", (String)"Yeehaw, Purple Icons Rule!!");
                    ArtifactImageManager.setOverrideImageEnum((KeyedImage)FrameworkImage.PURPLE);
                } else {
                    this.result.setValue(true);
                }
            }
        }
    }
}

