/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.widget;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.editor.tab.workflow.widget.AbstractXAssigneesListWidget;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.UserCheckTreeDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;

public class XAssigneesListWidget
extends AbstractXAssigneesListWidget {
    List<AtsUser> assignees = new LinkedList<AtsUser>();
    IAtsTeamDefinition teamDef = null;

    public XAssigneesListWidget() {
        super("Assignees");
    }

    @Override
    public List<AtsUser> getCurrentAssignees() {
        return this.assignees;
    }

    @Override
    public void handleModifySelection() {
        try {
            UserCheckTreeDialog uld = new UserCheckTreeDialog("Select Assigness", "Select to assign.", AtsApiService.get().getUserService().getUsers(Active.Active));
            if (this.teamDef != null) {
                uld.setTeamMembers(AtsApiService.get().getTeamDefinitionService().getMembersAndLeads(this.teamDef));
            }
            uld.setInitialSelections(this.assignees);
            if (uld.open() == 0) {
                this.assignees.clear();
                this.assignees.addAll(uld.getUsersSelected());
                this.setInput(this.assignees);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    @Override
    public void handleEmailSelection() {
    }

    @Override
    public boolean includeEmailButton() {
        return false;
    }

    public IAtsTeamDefinition getTeamDef() {
        return this.teamDef;
    }

    public void setTeamDef(IAtsTeamDefinition teamDef) {
        this.teamDef = teamDef;
    }
}

