/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.widgets.dialog.UserListDialog;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class OriginatorColumn
extends XViewerAtsColumn
implements IXViewerValueColumn,
IAltLeftClickProvider,
IMultiColumnEditProvider {
    public static OriginatorColumn instance = new OriginatorColumn();

    public static OriginatorColumn getInstance() {
        return instance;
    }

    private OriginatorColumn() {
        super("ats.column.originator", "Originator", 80, XViewerAlign.Left, false, SortDataType.String, true, null);
    }

    public OriginatorColumn copy() {
        OriginatorColumn newXCol = new OriginatorColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block7: {
            Artifact useArt;
            block9: {
                block8: {
                    if (!(treeItem.getData() instanceof Artifact)) break block7;
                    useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                    if (!useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) break block8;
                    if (AtsApiService.get().getWorkItemService().getTeams((Object)useArt).size() == 1) {
                        useArt = AtsApiService.get().getQueryServiceIde().getArtifact(AtsApiService.get().getWorkItemService().getFirstTeam((Object)useArt));
                        break block8;
                    }
                    return false;
                }
                if (useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) break block9;
                return false;
            }
            try {
                boolean modified = OriginatorColumn.promptChangeOriginator(Arrays.asList(new IAtsWorkItem[]{(TeamWorkFlowArtifact)useArt}), this.isPersistViewer());
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified && this.isPersistViewer(xViewer)) {
                    useArt.persist("persist goals via alt-left-click");
                }
                if (modified) {
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean promptChangeOriginator(IAtsWorkItem workItem, boolean persist) {
        return OriginatorColumn.promptChangeOriginator(Arrays.asList(workItem), persist);
    }

    public static boolean promptChangeOriginator(Collection<IAtsWorkItem> workItems, boolean persist) {
        UserListDialog dialog = new UserListDialog(Displays.getActiveShell(), "Select New Originator", Active.Active);
        int result = dialog.open();
        if (result == 0) {
            AtsUser selectedUser = dialog.getSelection();
            IAtsChangeSet changes = AtsApiService.get().createChangeSet("ATS Prompt Change Originator");
            for (IAtsWorkItem workItem : workItems) {
                workItem.getStateMgr().setCreatedBy(selectedUser, true, null, changes);
                OriginatorColumn.addOriginatorNotification(workItem, changes);
                changes.add((Object)workItem);
            }
            if (persist) {
                changes.execute();
            }
            return true;
        }
        return false;
    }

    public static void addOriginatorNotification(IAtsWorkItem workItem, IAtsChangeSet changes) {
        try {
            changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)AtsApiService.get().getUserService().getCurrentUser(), (IAtsWorkItem)workItem, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Originator}));
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error adding ATS Notification Event", (Throwable)ex);
        }
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof AbstractWorkflowArtifact) {
                return ((AbstractWorkflowArtifact)((Object)element)).getCreatedBy().getName();
            }
            if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                HashSet<String> strs = new HashSet<String>();
                for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(element)) {
                    strs.add(team.getCreatedBy().getName());
                }
                return Collections.toString((String)"; ", strs);
            }
            return "";
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
    }

    @Override
    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        try {
            if (element instanceof AbstractWorkflowArtifact) {
                return AtsEditors.getImage(Arrays.asList(((AbstractWorkflowArtifact)((Object)element)).getCreatedBy()));
            }
            if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                HashSet<AtsUser> users = new HashSet<AtsUser>();
                for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(element)) {
                    users.add(team.getCreatedBy());
                }
                return AtsEditors.getImage(users);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<IAtsWorkItem> awas = new HashSet<IAtsWorkItem>();
            for (TreeItem item : treeItems) {
                Artifact art;
                if (!(item.getData() instanceof AbstractWorkflowArtifact) || !((art = AtsApiService.get().getQueryServiceIde().getArtifact(item)) instanceof AbstractWorkflowArtifact)) continue;
                awas.add((AbstractWorkflowArtifact)art);
            }
            OriginatorColumn.promptChangeOriginator(awas, true);
            return;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return;
        }
    }
}

