/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.util.ChangeTypeUtil;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.ChangeTypeDialog;
import org.eclipse.osee.ats.ide.workflow.ChangeTypeToSwtImage;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ChangeTypeColumnUI
extends XViewerAtsAttributeValueColumn {
    public static ChangeTypeColumnUI instance = new ChangeTypeColumnUI();

    public static ChangeTypeColumnUI getInstance() {
        return instance;
    }

    private ChangeTypeColumnUI() {
        super(AtsColumnTokens.ChangeTypeColumn);
    }

    @Override
    public ChangeTypeColumnUI copy() {
        ChangeTypeColumnUI newXCol = new ChangeTypeColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean promptChangeType(Collection<? extends TeamWorkFlowArtifact> teams, boolean persist) {
        try {
            ChangeType changeType;
            for (TeamWorkFlowArtifact team : teams) {
                if (!AtsApiService.get().getVersionService().isReleased((IAtsTeamWorkflow)team) && !AtsApiService.get().getVersionService().isVersionLocked((IAtsTeamWorkflow)team)) continue;
                AWorkbench.popup((String)"ERROR", (String)("Team Workflow\n \"" + team.getName() + "\"\n version is locked or already released."));
                return false;
            }
            ChangeTypeDialog dialog = new ChangeTypeDialog(Displays.getActiveShell());
            if (teams.size() == 1 && (changeType = ChangeTypeUtil.getChangeType((IAtsWorkItem)teams.iterator().next(), (AtsApi)AtsApiService.get())) != null) {
                dialog.setSelected(changeType);
            }
            if (dialog.open() == 0) {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("ATS Prompt Change Type");
                ChangeType newChangeType = dialog.getSelection();
                for (TeamWorkFlowArtifact teamWorkFlowArtifact : teams) {
                    ChangeType currChangeType = ChangeTypeUtil.getChangeType((IAtsWorkItem)teamWorkFlowArtifact, (AtsApi)AtsApiService.get());
                    if (currChangeType == newChangeType) continue;
                    ChangeTypeUtil.setChangeType((IAtsObject)teamWorkFlowArtifact, (ChangeType)newChangeType, (IAtsChangeSet)changes);
                    if (!persist) continue;
                    teamWorkFlowArtifact.save(changes);
                }
                if (persist) {
                    changes.execute();
                }
            }
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't change priority", (Throwable)ex);
            return false;
        }
    }

    @Override
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block8: {
            Artifact useArt;
            block11: {
                block10: {
                    block9: {
                        if (!(treeItem.getData() instanceof Artifact)) break block8;
                        useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                        if (useArt.getArtifactType().getMax(this.getAttributeType()) == 1) break block9;
                        return false;
                    }
                    if (!useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) break block10;
                    if (AtsApiService.get().getWorkItemService().getTeams((Object)useArt).size() == 1) {
                        useArt = (AbstractWorkflowArtifact)AtsApiService.get().getWorkItemService().getFirstTeam((Object)useArt).getStoreObject();
                        break block10;
                    }
                    return false;
                }
                if (useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) break block11;
                return false;
            }
            try {
                boolean modified = ChangeTypeColumnUI.promptChangeType(Arrays.asList((TeamWorkFlowArtifact)useArt), this.isPersistViewer());
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified && this.isPersistViewer(xViewer)) {
                    useArt.persist("persist change type via alt-left-click");
                }
                if (modified) {
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public Image getColumnImage(Object element, XViewerColumn column, int columnIndex) {
        try {
            ChangeType changeType;
            IAtsWorkItem workItem;
            Artifact useArt;
            if (element instanceof IAtsWorkItem && (useArt = this.getParentTeamWorkflowOrArtifact(workItem = (IAtsWorkItem)element)) != null && (changeType = ChangeTypeUtil.getChangeType((IAtsWorkItem)workItem, (AtsApi)AtsApiService.get())) != null) {
                return ChangeTypeToSwtImage.getImage(changeType);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return null;
    }

    @Override
    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        HashSet<TeamWorkFlowArtifact> awas = new HashSet<TeamWorkFlowArtifact>();
        for (TreeItem item : treeItems) {
            if (!(item.getData() instanceof Artifact)) continue;
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
            awas.add((TeamWorkFlowArtifact)art);
        }
        ChangeTypeColumnUI.promptChangeType(awas, true);
        ((XViewer)this.getXViewer()).update(awas.toArray(), null);
    }
}

