/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.access;

import java.util.Collection;
import org.eclipse.osee.framework.core.access.AccessControlData;
import org.eclipse.osee.framework.core.access.AccessTopicEventPayload;
import org.eclipse.osee.framework.core.access.object.AccessObject;
import org.eclipse.osee.framework.core.access.object.ArtifactAccessObject;
import org.eclipse.osee.framework.core.access.object.BranchAccessObject;
import org.eclipse.osee.framework.core.access.operation.AccessCache;
import org.eclipse.osee.framework.core.access.operation.IAccessStoreOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class AccessStoreOperations
implements IAccessStoreOperations {
    private AccessCache cache;
    private final JdbcClient jdbcClient;
    private final OrcsApi orcsApi;

    public AccessStoreOperations(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.jdbcClient = orcsApi.getJdbcService().getClient();
    }

    public void removePermissions(BranchId branch) {
        this.jdbcClient.runPreparedUpdate("DELETE FROM OSEE_ARTIFACT_ACL WHERE  branch_id =?", new Object[]{branch});
        this.jdbcClient.runPreparedUpdate("DELETE FROM OSEE_BRANCH_ACL WHERE branch_id =?", new Object[]{branch});
        AccessTopicEventPayload event = new AccessTopicEventPayload();
        event.setBranch(branch);
    }

    public void setPermission(ArtifactToken subject, BranchId branch, PermissionEnum permission) {
        boolean newAccessControlData;
        Conditions.assertFalse((boolean)CoreBranches.COMMON.equals(branch), (String)"Can not set permissions on Common branch.", (Object[])new Object[0]);
        AccessObject accessObject = AccessObject.valueOf((Object)branch);
        boolean bl = newAccessControlData = !this.cache.accessControlListCache.containsKey((Object)subject.getId(), (Object)accessObject);
        if (newAccessControlData || permission != this.cache.accessControlListCache.get((Object)subject.getId(), (Object)accessObject)) {
            AccessControlData data = new AccessControlData(subject, accessObject, permission, newAccessControlData);
            this.persistPermission(data);
        }
    }

    public void setPermission(ArtifactToken subject, ArtifactToken artifact, PermissionEnum permission) {
        boolean newAccessControlData;
        AccessObject accessObject = AccessObject.valueOf((Object)artifact);
        boolean bl = newAccessControlData = !this.cache.accessControlListCache.containsKey((Object)subject.getId(), (Object)accessObject);
        if (newAccessControlData || permission != this.cache.accessControlListCache.get((Object)subject.getId(), (Object)accessObject)) {
            AccessControlData data = new AccessControlData(subject, accessObject, permission, newAccessControlData);
            this.persistPermission(data);
        }
    }

    public void persistPermission(AccessControlData data) {
        this.persistPermission(data, false);
    }

    public void persistPermission(AccessControlData data, boolean recurse) {
        if (data.getObject() instanceof ArtifactAccessObject) {
            ArtifactAccessObject artifactAccessObject = (ArtifactAccessObject)data.getObject();
            AccessTopicEventPayload event = new AccessTopicEventPayload();
            event.setBranch((BranchId)artifactAccessObject.getBranch());
            this.persistPermissionForArtifact(data, artifactAccessObject, recurse, event);
            this.cache.cacheAccessControlData(data);
        } else if (data.getObject() instanceof BranchAccessObject) {
            BranchAccessObject branchAccessObject = (BranchAccessObject)data.getObject();
            this.orcsApi.getBranchOps().setBranchPermission((ArtifactId)data.getSubject(), (BranchId)branchAccessObject.getBranch(), data.getPermission());
            this.cache.cacheAccessControlData(data);
            AccessTopicEventPayload event = new AccessTopicEventPayload();
            event.setBranch((BranchId)branchAccessObject.getBranch());
        }
    }

    private void persistPermissionForArtifact(AccessControlData data, ArtifactAccessObject artifactAccessObject, boolean recurse, AccessTopicEventPayload event) {
        ArtifactToken subject = data.getSubject();
        PermissionEnum permission = data.getPermission();
        if (data.isDirty()) {
            ArtifactToken artifact;
            data.setNotDirty();
            if (data.isBirth()) {
                this.jdbcClient.runPreparedUpdate(OseeDb.OSEE_ARTIFACT_ACL_TABLE.getInsertSql(), new Object[]{artifactAccessObject, data.getSubject().getId(), artifactAccessObject.getBranch(), data.getPermission().getPermId()});
            } else {
                this.jdbcClient.runPreparedUpdate("UPDATE OSEE_ARTIFACT_ACL SET permission_id = ? WHERE privilege_entity_id =? AND art_id = ? AND branch_id = ?", new Object[]{data.getPermission().getPermId(), data.getSubject().getId(), artifactAccessObject, artifactAccessObject.getBranch()});
            }
            event.addArtifact(artifactAccessObject.getArtifact());
            if (recurse && (artifact = this.orcsApi.getQueryFactory().fromBranch((BranchId)artifactAccessObject.getBranch()).andId((ArtifactId)artifactAccessObject).getArtifactOrSentinal()).isValid()) {
                for (ArtifactReadable child : ((ArtifactReadable)artifact).getChildren()) {
                    AccessControlData childAccessControlData = null;
                    AccessObject childAccessObject = AccessObject.valueOf((Object)child);
                    if (this.cache.objectToSubjectCache.containsKey((Object)childAccessObject)) {
                        Collection subjectIds = this.cache.objectToSubjectCache.getValues((Object)childAccessObject);
                        for (ArtifactId subjectId : subjectIds) {
                            if (!subjectId.equals(subject)) continue;
                            childAccessControlData = new AccessControlData(subject, childAccessObject, permission, false);
                            break;
                        }
                    }
                    if (childAccessControlData == null) {
                        childAccessControlData = new AccessControlData(subject, childAccessObject, permission, true);
                    }
                    this.persistPermissionForArtifact(childAccessControlData, (ArtifactAccessObject)childAccessObject, true, event);
                }
            }
        }
    }

    public void removeAccessControlDataIf(boolean removeFromDb, AccessControlData data) {
        AccessObject accessControlledObject = data.getObject();
        boolean isArtifact = accessControlledObject instanceof ArtifactAccessObject;
        if (removeFromDb) {
            this.removeFromDatabase(accessControlledObject, (ArtifactId)data.getSubject());
        }
        if (accessControlledObject instanceof ArtifactAccessObject) {
            accessControlledObject.removeFromCache();
        }
        this.cache.deCacheAccessControlData(data);
        AccessTopicEventPayload event = new AccessTopicEventPayload();
        event.setBranch((BranchId)accessControlledObject.getBranch());
        if (isArtifact) {
            event.addArtifact(((ArtifactAccessObject)accessControlledObject).getArtifact());
        }
    }

    public void removeFromDatabase(AccessObject accessControlledObject, ArtifactId subjectId) {
        if (accessControlledObject.isArtifact()) {
            this.jdbcClient.runPreparedUpdate("DELETE FROM OSEE_ARTIFACT_ACL WHERE privilege_entity_id = ? AND art_id =? AND branch_id =?", new Object[]{subjectId, ArtifactId.valueOf((Long)accessControlledObject.getId()), accessControlledObject.getBranch()});
        } else if (accessControlledObject.isBranch()) {
            this.jdbcClient.runPreparedUpdate("DELETE FROM OSEE_BRANCH_ACL WHERE privilege_entity_id = ? AND branch_id =?", new Object[]{subjectId, BranchId.valueOf((Long)accessControlledObject.getId())});
        }
    }

    public void setCache(AccessCache cache) {
        this.cache = cache;
    }
}

