/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.BranchQuery;

public class HtmlWriter {
    private final UriInfo uriInfo;
    private final OrcsApi orcsApi;

    public HtmlWriter(UriInfo uriInfo, OrcsApi orcsApi) {
        this.uriInfo = uriInfo;
        this.orcsApi = orcsApi;
    }

    public String toHtml(Iterable<? extends Object> objects) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html><body>");
        for (Object object : objects) {
            if (object instanceof Branch) {
                Branch branch = (Branch)object;
                this.addTable(builder, this.toData(branch));
            } else if (object instanceof ArtifactReadable) {
                ArtifactReadable artifact = (ArtifactReadable)object;
                this.addTable(builder, this.toData(artifact));
            } else if (object instanceof AttributeReadable) {
                AttributeReadable attribute = (AttributeReadable)object;
                this.addTable(builder, this.toData(attribute));
            } else if (object instanceof TransactionReadable) {
                TransactionReadable tx = (TransactionReadable)object;
                this.addTable(builder, this.toData(tx));
            } else {
                LinkedHashMap<String, Object> unhandled = new LinkedHashMap<String, Object>();
                unhandled.put("Class", object.getClass().getSimpleName());
                unhandled.put("Data", object.toString());
                this.addTable(builder, unhandled);
            }
            builder.append("<br/>");
        }
        builder.append("</body></html>");
        return builder.toString();
    }

    private Map<String, Object> toData(AttributeReadable<?> attribute) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("Name", attribute.getAttributeType().getName());
        Long attrId = attribute.getId();
        URI uri = this.uriInfo.getAbsolutePathBuilder().path("{attributeId}").build(new Object[]{attrId});
        data.put("AttributeId", this.asLink(uri.getPath(), String.valueOf(attrId)));
        return data;
    }

    private Map<String, Object> toData(ArtifactReadable artifact) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("Name", artifact.getName());
        data.put("Artifact Id", artifact.getId());
        data.put("Tx Id", artifact.getTransaction());
        String branchId = artifact.getBranch().getIdString();
        String branchName = this.getBranchFromId((BranchId)artifact.getBranch()).getName();
        URI uri = this.isAtEndOfPath(this.uriInfo.getPath(), "artifact") ? this.uriInfo.getAbsolutePathBuilder().path("../../{uuid}").build(new Object[]{branchId}) : this.uriInfo.getAbsolutePathBuilder().path("../../../{uuid}").build(new Object[]{branchId});
        data.put("Branch Id", this.asLink(uri.toASCIIString(), branchId));
        data.put("Branch Name", this.asLink(uri.toASCIIString(), branchName));
        Collection types = artifact.getExistingAttributeTypes();
        for (AttributeTypeToken type : types) {
            for (AttributeReadable attr : artifact.getAttributes(type)) {
                URI attrUri = this.uriInfo.getAbsolutePathBuilder().path("/attribute/{attributeId}").build(new Object[]{attr.getId()});
                String label = this.asLink(attrUri.getPath(), type.getName());
                String value = attr.getDisplayableString();
                data.put(label, value == null ? "<NULL>" : value);
            }
        }
        int count = 0;
        for (ArtifactReadable art : artifact.getChildren()) {
            URI uri1 = this.isAtEndOfPath(this.uriInfo.getPath(), "artifact") ? this.uriInfo.getAbsolutePathBuilder().path("{uuid}").build(new Object[]{art.getIdString()}) : this.uriInfo.getAbsolutePathBuilder().path("../{uuid}").build(new Object[]{art.getIdString()});
            String value = art.getName();
            data.put("Child " + ++count, this.asLink(uri1.getPath(), value == null ? "<NULL>" : value));
        }
        return data;
    }

    private Map<String, Object> toData(Branch branch) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("Name", branch.getName());
        data.put("Branch Id", branch.getId());
        data.put("State", branch.getBranchState());
        data.put("Type", branch.getBranchType());
        data.put("Archived", branch.isArchived());
        if (branch.hasParentBranch()) {
            try {
                BranchToken parent = this.getBranchFromId(branch.getParentBranch());
                String parentId = parent.getIdString();
                URI uri = this.isAtEndOfPath(this.uriInfo.getPath(), "branch") ? this.uriInfo.getAbsolutePathBuilder().path("{uuid}").build(new Object[]{parentId}) : this.uriInfo.getAbsolutePathBuilder().path("../{uuid}").build(new Object[]{parentId});
                data.put("Parent", this.asLink(uri.getPath(), parent.getName()));
            }
            catch (OseeCoreException oseeCoreException) {
                data.put("Parent", "Root");
            }
            URI uri = this.isAtEndOfPath(this.uriInfo.getPath(), "branch") ? this.uriInfo.getAbsolutePathBuilder().path("{uuid}/artifact").build(new Object[]{branch.getIdString()}) : this.uriInfo.getAbsolutePathBuilder().path("../{uuid}/artifact").build(new Object[]{branch.getIdString()});
            data.put("Artifacts", this.asLink(uri.getPath(), "Hierarchy"));
        }
        return data;
    }

    private BranchToken getBranchFromId(BranchId branch) {
        return (BranchToken)((BranchQuery)this.orcsApi.getQueryFactory().branchQuery().andId(branch)).getResultsAsId().getExactlyOne();
    }

    public Map<String, Object> toData(TransactionReadable txRecord) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("TxId", txRecord);
        data.put("TxType", txRecord.getTxType());
        data.put("Date", txRecord.getDate());
        data.put("Comment", txRecord.getComment());
        data.put("Author", txRecord.getAuthor());
        BranchToken branch = this.getBranchFromId(txRecord.getBranch());
        URI uri = this.isAtEndOfPath(this.uriInfo.getPath(), "branch") ? this.uriInfo.getAbsolutePathBuilder().path("{uuid}").build(new Object[]{branch.getIdString()}) : this.uriInfo.getAbsolutePathBuilder().path("../{uuid}").build(new Object[]{branch.getIdString()});
        data.put("Branch", this.asLink(uri.getPath(), branch.getName()));
        return data;
    }

    public String asLink(String url, String text) {
        return String.format("<a href=\"%s\">%s</a>", url, text);
    }

    public void addTable(StringBuilder builder, Map<String, Object> data) {
        builder.append("<table>");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            builder.append("<tr><td><b>");
            builder.append(entry.getKey());
            builder.append(": <b/></td><td>");
            builder.append(entry.getValue().toString());
            builder.append("</td></tr>");
        }
        builder.append("</table>");
    }

    private boolean isAtEndOfPath(String path, String value) {
        String toCheck = path;
        if (toCheck.endsWith("/")) {
            toCheck = toCheck.substring(0, toCheck.length() - 1);
        }
        return toCheck.endsWith(value);
    }
}

