/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceEnumerationApi;
import org.eclipse.osee.mim.InterfaceEnumerationSetApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.PlatformTypesEndpoint;
import org.eclipse.osee.mim.types.InterfaceEnumeration;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class PlatformTypesEndpointImpl
implements PlatformTypesEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final InterfacePlatformTypeApi platformApi;
    private final InterfaceEnumerationSetApi enumSetApi;
    private final InterfaceEnumerationApi enumApi;

    public PlatformTypesEndpointImpl(BranchId branch, UserId account, InterfacePlatformTypeApi api, InterfaceEnumerationSetApi enumSetApi, InterfaceEnumerationApi enumApi) {
        this.account = account;
        this.branch = branch;
        this.platformApi = api;
        this.enumSetApi = enumSetApi;
        this.enumApi = enumApi;
    }

    @Override
    public Collection<PlatformTypeToken> getPlatformTypes() {
        try {
            return this.platformApi.getAccessor().getAll(this.branch, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public PlatformTypeToken getPlatformType(ArtifactId typeId) {
        try {
            return this.platformApi.getAccessor().get(this.branch, typeId, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public InterfaceEnumerationSet getRelatedEnumerationSet(ArtifactId typeId) {
        try {
            List enumSets = (List)this.enumSetApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfacePlatformTypeEnumeration_Element, typeId, InterfaceEnumerationSet.class);
            for (InterfaceEnumerationSet set : enumSets) {
                set.setEnumerations((List)this.enumApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceEnumeration_EnumerationSet, ArtifactId.valueOf((Long)set.getId()), InterfaceEnumeration.class));
            }
            return (InterfaceEnumerationSet)((Object)enumSets.get(0));
        }
        catch (Exception ex) {
            System.out.println(ex);
            return null;
        }
    }
}

