/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide.internal;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.data.IdeClientSession;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.HttpProcessor;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.server.ide.api.client.ClientEndpoint;
import org.eclipse.osee.framework.server.ide.api.client.model.ClientDetails;
import org.eclipse.osee.framework.server.ide.api.client.model.ClientInfo;
import org.eclipse.osee.framework.server.ide.api.client.model.Sessions;
import org.eclipse.osee.framework.server.ide.api.model.IdeVersion;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ClientEndpointImpl
implements ClientEndpoint {
    @Context
    private UriInfo uriInfo;
    private final JdbcService jdbcService;
    private final OrcsApi orcsApi;
    private static final String NEWEST_SESSIONS_BY_USER = "select client_address, user_id, created_on, client_port, client_version, session_id from osee_session where user_id = ? order by created_on desc";

    public ClientEndpointImpl(JdbcService jdbcService, OrcsApi orcsApi) {
        this.jdbcService = jdbcService;
        this.orcsApi = orcsApi;
    }

    public Response getAll() {
        Sessions activeSessions = new Sessions();
        activeSessions.get().addAll(this.getActiveSessions().keySet());
        return Response.ok((Object)activeSessions).build();
    }

    public Response getAllDetails() {
        ClientDetails details = new ClientDetails();
        Map<IdeClientSession, ClientInfo> activeSessions = this.getActiveSessions();
        for (Map.Entry<IdeClientSession, ClientInfo> entry : activeSessions.entrySet()) {
            IdeClientSession session = entry.getKey();
            details.getSessions().add(session);
            ClientInfo info = entry.getValue();
            this.increment(details.releaseCount, info.getVersion());
            this.addUserId(details.releaseToUserId, session.getClientVersion(), session.getUserId());
            if (!info.getInstallation().contains("osee-installs")) continue;
            details.networkReleaseUserIds.add(session.getUserId());
        }
        return Response.ok((Object)details).build();
    }

    public Response getClientsForUser(String idOrName) {
        System.out.println(String.format("getClientsForUser [%s]", idOrName));
        Sessions sessions = new Sessions();
        HashMap portToAlive = new HashMap();
        List<String> resolvedUserIds = this.getUserIds(idOrName);
        if (resolvedUserIds.isEmpty()) {
            throw new OseeArgumentException("User with id or name of [%s] not found", new Object[]{idOrName});
        }
        Consumer<JdbcStatement> consumer = stmt -> {
            IdeClientSession session = ClientEndpointImpl.createSession(stmt, this.uriInfo);
            String key = String.valueOf(session.getClientAddress()) + session.getClientPort();
            Boolean alive = (Boolean)portToAlive.get(key);
            if (alive == null) {
                alive = this.alive(session);
                portToAlive.put(key, alive);
                if (alive.booleanValue()) {
                    sessions.add(session);
                }
            }
        };
        for (String userId : resolvedUserIds) {
            this.jdbcService.getClient().runQueryWithLimit(consumer, 10, NEWEST_SESSIONS_BY_USER, new Object[]{userId});
        }
        return Response.ok((Object)sessions).build();
    }

    public Response getClientInfo(String userId, String sessionId) {
        if (!GUID.isValid((String)sessionId)) {
            return Response.ok((Object)String.format("Session [%s] is invalid", sessionId)).build();
        }
        IdeClientSession session = this.getClientSession(sessionId);
        String infoStr = this.getInfoStr(session, true);
        return Response.ok((Object)infoStr).build();
    }

    public IdeVersion getSupportedVersions() {
        IdeVersion versions = new IdeVersion();
        versions.addVersion(OseeCodeVersion.getVersion());
        return versions;
    }

    public TransactionId saveCustomizeData(CustomizeData customizeData) {
        boolean personal = customizeData.isPersonal();
        ArtifactToken customArtId = personal ? this.orcsApi.userService().getUser() : CoreArtifactTokens.XViewerCustomization;
        ArtifactReadable customArt = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andId((ArtifactId)customArtId).asArtifact();
        List attributes = customArt.getAttributeList((AttributeTypeGeneric)CoreAttributeTypes.XViewerCustomization);
        AttributeId attrId = AttributeId.SENTINEL;
        for (IAttribute attribute : attributes) {
            CustomizeData cd = new CustomizeData((String)attribute.getValue());
            if (!customizeData.getGuid().equals(cd.getGuid())) continue;
            attrId = attribute;
            break;
        }
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, "save customization " + customizeData.getName());
        String value = customizeData.getXml(true);
        if (attrId.isValid()) {
            tx.setAttributeById((ArtifactId)customArt, attrId, value);
        } else {
            tx.createAttribute((ArtifactId)customArt, (AttributeTypeToken)CoreAttributeTypes.XViewerCustomization, (Object)value);
        }
        return tx.commit();
    }

    private List<String> getUserIds(String userIdOrName) {
        LinkedList<String> results = new LinkedList<String>();
        if (Strings.isNumeric((String)userIdOrName)) {
            results.add(userIdOrName);
        } else {
            for (ArtifactReadable userArt : this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON).andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).and((AttributeTypeId)CoreAttributeTypes.Name, userIdOrName, QueryOption.CONTAINS_MATCH_OPTIONS).getResults()) {
                results.add((String)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId, null));
            }
        }
        return results;
    }

    private static IdeClientSession createSession(JdbcStatement stmt, UriInfo uriInfo) {
        IdeClientSession session = new IdeClientSession(stmt.getString("CLIENT_ADDRESS"), stmt.getString("CLIENT_PORT"), stmt.getString("USER_ID"), stmt.getString("CLIENT_VERSION"), stmt.getString("SESSION_ID"), DateUtil.get((Date)stmt.getDate("CREATED_ON"), (String)"MM/dd/yyyy hh:mm a"));
        URI location = UriBuilder.fromPath((String)uriInfo.getBaseUri().toASCIIString()).path("client").path(stmt.getString("USER_ID")).path("session").path(stmt.getString("SESSION_ID")).build(new Object[0]);
        session.setSessionLog(location.toString());
        return session;
    }

    private Map<IdeClientSession, ClientInfo> getActiveSessions() {
        HashMap<IdeClientSession, ClientInfo> sessionToInfo = new HashMap<IdeClientSession, ClientInfo>(200);
        HashSet pinged = new HashSet(200);
        Consumer<JdbcStatement> consumer = stmt -> {
            IdeClientSession session = ClientEndpointImpl.createSession(stmt, this.uriInfo);
            String key = String.valueOf(session.getClientAddress()) + session.getClientPort();
            if (!pinged.contains(key)) {
                ClientInfo info = this.getClientInfo(session.getSessionId());
                if (info != null) {
                    sessionToInfo.put(session, info);
                }
                pinged.add(key);
            }
        };
        this.jdbcService.getClient().runQuery(consumer, "select * from osee_session where created_on > CURRENT_DATE - INTERVAL '7' DAY order by created_on desc", new Object[0]);
        return sessionToInfo;
    }

    private void addUserId(Map<String, Collection<String>> releaseToUserId, String release, String userId) {
        Collection<String> userIds = releaseToUserId.get(release);
        if (userIds == null) {
            userIds = new HashSet<String>(100);
        }
        userIds.add(userId);
        releaseToUserId.put(release, userIds);
    }

    private void increment(Map<String, Integer> releaseCount, String version) {
        Integer count = releaseCount.get(version);
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        releaseCount.put(version, count);
    }

    private ClientInfo getClientInfo(String sessionId) {
        IdeClientSession session = this.getClientSession(sessionId);
        String infoStr = this.getInfoStr(session, false);
        if (Strings.isValid((String)infoStr)) {
            return new ClientInfo(infoStr);
        }
        return null;
    }

    private IdeClientSession getClientSession(String sessionId) {
        return (IdeClientSession)this.jdbcService.getClient().fetch(null, stmt -> ClientEndpointImpl.createSession(stmt, this.uriInfo), "select * from osee_session where session_id = ?", new Object[]{sessionId});
    }

    private boolean alive(IdeClientSession session) {
        boolean alive = this.isHostAlive(session);
        if (!alive) {
            return false;
        }
        alive = false;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            URL url = new URL(String.format("http://%s:%s/osee/request?cmd=pingId", session.getClientAddress(), session.getClientPort()));
            HttpProcessor.AcquireResult result = HttpProcessor.acquire((URL)url, (OutputStream)outputStream, (int)1000);
            if (result.wasSuccessful()) {
                alive = true;
            }
        }
        catch (Exception exception) {}
        return alive;
    }

    private boolean isHostAlive(IdeClientSession session) {
        boolean reachable = false;
        try {
            String osName = System.getProperty("os.name");
            String option = osName.toLowerCase().contains("windows") ? "-n" : "-c";
            Process p1 = Runtime.getRuntime().exec(String.format("ping %s 1 %s", option, session.getClientAddress()));
            int returnVal = p1.waitFor();
            reachable = returnVal == 0;
        }
        catch (Exception exception) {}
        return reachable;
    }

    private String getInfoStr(IdeClientSession session, boolean withLog) {
        block4: {
            try {
                boolean alive = this.isHostAlive(session);
                if (alive) break block4;
                return "Host Not Alive";
            }
            catch (Exception exception) {}
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        URL url = new URL(String.format("http://%s:%s/osee/request?cmd=" + (withLog ? "log" : "info"), session.getClientAddress(), session.getClientPort()));
        HttpProcessor.AcquireResult result = HttpProcessor.acquire((URL)url, (OutputStream)outputStream, (int)1000);
        if (result.wasSuccessful()) {
            return outputStream.toString(result.getEncoding());
        }
        return "";
    }
}

