/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest;

import java.io.InputStream;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.EnumSupplierMap;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.synchronization.rest.AttributeDefinitionGrove;
import org.eclipse.osee.synchronization.rest.AttributeDefinitionGroveThing;
import org.eclipse.osee.synchronization.rest.AttributeValueGrove;
import org.eclipse.osee.synchronization.rest.AttributeValueGroveThing;
import org.eclipse.osee.synchronization.rest.CommonObjectGroveThing;
import org.eclipse.osee.synchronization.rest.CommonObjectTypeContainer;
import org.eclipse.osee.synchronization.rest.CommonObjectTypeGrove;
import org.eclipse.osee.synchronization.rest.CommonObjectTypeGroveThing;
import org.eclipse.osee.synchronization.rest.DataTypeDefinitionGrove;
import org.eclipse.osee.synchronization.rest.DataTypeDefinitionGroveThing;
import org.eclipse.osee.synchronization.rest.Grove;
import org.eclipse.osee.synchronization.rest.GroveThing;
import org.eclipse.osee.synchronization.rest.HeaderGrove;
import org.eclipse.osee.synchronization.rest.HeaderGroveThing;
import org.eclipse.osee.synchronization.rest.IdentifierType;
import org.eclipse.osee.synchronization.rest.IsSynchronizationArtifactBuilder;
import org.eclipse.osee.synchronization.rest.NativeDataType;
import org.eclipse.osee.synchronization.rest.Root;
import org.eclipse.osee.synchronization.rest.RootList;
import org.eclipse.osee.synchronization.rest.SpecObjectGrove;
import org.eclipse.osee.synchronization.rest.SpecObjectGroveThing;
import org.eclipse.osee.synchronization.rest.SpecObjectTypeGrove;
import org.eclipse.osee.synchronization.rest.SpecObjectTypeGroveThing;
import org.eclipse.osee.synchronization.rest.SpecTypeGrove;
import org.eclipse.osee.synchronization.rest.SpecTypeGroveThing;
import org.eclipse.osee.synchronization.rest.SpecificationGrove;
import org.eclipse.osee.synchronization.rest.SpecificationGroveThing;
import org.eclipse.osee.synchronization.rest.SynchronizationArtifactBuilder;
import org.eclipse.osee.synchronization.rest.UnknownSynchronizationArtifactTypeException;
import org.eclipse.osee.synchronization.util.IndentedString;
import org.eclipse.osee.synchronization.util.ToMessage;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;

public class SynchronizationArtifact
implements ToMessage {
    private static Map<String, Class<?>> synchronizationArtifactBuilderClassMap = new HashMap();
    private final OrcsApi orcsApi;
    private final Map<IdentifierType, Grove> groveMap;
    private final EnumSupplierMap<IdentifierType, GroveThing> groveThingFactoryMap;
    private final Map<Long, CommonObjectTypeContainer> commonObjectTypeContainerMap;
    private final RootList rootList;
    private final SynchronizationArtifactBuilder synchronizationArtifactBuilder;

    static {
        BundleContext bundleContext = FrameworkUtil.getBundle(SynchronizationArtifact.class).getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        String bundleSymbolicNamePath = bundle.getSymbolicName().replace('.', '/');
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        ClassLoader classLoader = bundleWiring.getClassLoader();
        Collection resources = bundleWiring.listResources(bundleSymbolicNamePath, "*.class", 1);
        resources.forEach(resource -> {
            try {
                String className = resource.substring(0, resource.indexOf(46)).replace('/', '.');
                Class<?> theClass = classLoader.loadClass(className);
                IsSynchronizationArtifactBuilder isSynchronizationArtifactBuilder = theClass.getAnnotation(IsSynchronizationArtifactBuilder.class);
                if (isSynchronizationArtifactBuilder != null) {
                    synchronizationArtifactBuilderClassMap.put(isSynchronizationArtifactBuilder.artifactType(), theClass);
                }
            }
            catch (Exception exception) {}
        });
    }

    private SynchronizationArtifact(RootList rootList, SynchronizationArtifactBuilder synchronizationArtifactBuilder) {
        var groveMap;
        assert (Objects.nonNull(rootList) && Objects.nonNull(synchronizationArtifactBuilder));
        this.rootList = rootList;
        this.synchronizationArtifactBuilder = synchronizationArtifactBuilder;
        this.orcsApi = rootList.getOrcsApi();
        assert (Objects.nonNull(this.orcsApi));
        this.commonObjectTypeContainerMap = new HashMap<Long, CommonObjectTypeContainer>();
        this.groveMap = groveMap = new EnumMap<IdentifierType, Grove>(IdentifierType.class){
            private static final long serialVersionUID = 1L;

            public void put(Grove grove) {
                this.put(grove.getType(), grove);
            }
        };
        groveMap.put(new AttributeDefinitionGrove());
        groveMap.put(new AttributeValueGrove());
        groveMap.put(new DataTypeDefinitionGrove());
        groveMap.put(new HeaderGrove());
        groveMap.put(new SpecObjectGrove());
        groveMap.put(new SpecObjectTypeGrove());
        groveMap.put(new SpecificationGrove());
        groveMap.put(new SpecTypeGrove());
        this.groveThingFactoryMap = new EnumSupplierMap(IdentifierType.class);
        this.groveThingFactoryMap.put((Enum)IdentifierType.ATTRIBUTE_DEFINITION, AttributeDefinitionGroveThing::new);
        this.groveThingFactoryMap.put((Enum)IdentifierType.ATTRIBUTE_VALUE, AttributeValueGroveThing::new);
        this.groveThingFactoryMap.put((Enum)IdentifierType.DATA_TYPE_DEFINITION, DataTypeDefinitionGroveThing::new);
        this.groveThingFactoryMap.put((Enum)IdentifierType.HEADER, HeaderGroveThing::new);
        this.groveThingFactoryMap.put((Enum)IdentifierType.SPEC_OBJECT, SpecObjectGroveThing::new);
        this.groveThingFactoryMap.put((Enum)IdentifierType.SPEC_OBJECT_TYPE, SpecObjectTypeGroveThing::new);
        this.groveThingFactoryMap.put((Enum)IdentifierType.SPECIFICATION, SpecificationGroveThing::new);
        this.groveThingFactoryMap.put((Enum)IdentifierType.SPECIFICATION_TYPE, SpecTypeGroveThing::new);
    }

    public static SynchronizationArtifact create(RootList rootList) throws UnknownSynchronizationArtifactTypeException {
        assert (Objects.nonNull(rootList) && rootList instanceof RootList);
        RootList rootListImpl = rootList;
        String synchronizationArtifactType = rootListImpl.getSynchronizationArtifactType();
        if (!synchronizationArtifactBuilderClassMap.containsKey(synchronizationArtifactType)) {
            throw new UnknownSynchronizationArtifactTypeException(synchronizationArtifactType);
        }
        SynchronizationArtifactBuilder synchronizationArtifactBuilder = SynchronizationArtifact.getSynchronizationArtifactBuilder(synchronizationArtifactType);
        SynchronizationArtifact synchronizationArtifact = new SynchronizationArtifact(rootListImpl, synchronizationArtifactBuilder);
        return synchronizationArtifact;
    }

    private static SynchronizationArtifactBuilder getSynchronizationArtifactBuilder(String artifactType) throws UnknownSynchronizationArtifactTypeException {
        try {
            return (SynchronizationArtifactBuilder)synchronizationArtifactBuilderClassMap.get(artifactType).getConstructor(null).newInstance(null);
        }
        catch (Exception e) {
            throw new UnknownSynchronizationArtifactTypeException(artifactType, e);
        }
    }

    public void build() {
        HeaderGroveThing header = (HeaderGroveThing)this.createGroveThing(IdentifierType.HEADER);
        header.setOrcsApi(this.orcsApi);
        header.setRootListImpl(this.rootList);
        ((HeaderGrove)this.getGrove(IdentifierType.HEADER)).add(header);
        this.rootList.forEach(this::processRootArtifact);
        this.processCommonObjectTypeContainerMap();
        this.processAttributeDefinitionGrove();
        this.processSpecObjectGrove();
        this.groveMap.values().forEach(grove -> grove.createForeignThings(this.getSynchronizationArtifactBuilder()));
        this.synchronizationArtifactBuilder.build(this);
    }

    private CommonObjectTypeGroveThing createOrGetCommonObjectType(IdentifierType identifierType, ArtifactTypeToken artifactTypeToken) {
        CommonObjectTypeContainer commonObjectTypeContainer = this.commonObjectTypeContainerMap.get(artifactTypeToken.getId());
        if (commonObjectTypeContainer != null && commonObjectTypeContainer.hasType(identifierType)) {
            return commonObjectTypeContainer.get(identifierType);
        }
        CommonObjectTypeGroveThing commonObjectTypeGroveThing = (CommonObjectTypeGroveThing)this.createGroveThing(identifierType);
        commonObjectTypeGroveThing.setNativeThing(artifactTypeToken);
        if (commonObjectTypeContainer == null) {
            commonObjectTypeContainer = new CommonObjectTypeContainer(commonObjectTypeGroveThing);
            this.commonObjectTypeContainerMap.put(artifactTypeToken.getId(), commonObjectTypeContainer);
        } else {
            commonObjectTypeContainer.add(commonObjectTypeGroveThing);
        }
        ((CommonObjectTypeGrove)this.getGrove(identifierType)).add(commonObjectTypeGroveThing);
        return commonObjectTypeGroveThing;
    }

    private CommonObjectGroveThing createCommonObject(ArtifactReadable artifactReadable, IdentifierType identifierType) {
        CommonObjectGroveThing commonObjectGroveThing = (CommonObjectGroveThing)this.createGroveThing(identifierType);
        commonObjectGroveThing.setNativeThing(artifactReadable);
        ArtifactTypeToken artifactTypeToken = artifactReadable.getArtifactType();
        CommonObjectTypeGroveThing commonObjectTypeGroveThing = this.createOrGetCommonObjectType(identifierType == IdentifierType.SPEC_OBJECT ? IdentifierType.SPEC_OBJECT_TYPE : IdentifierType.SPECIFICATION_TYPE, artifactTypeToken);
        commonObjectGroveThing.setCommonObjectType(commonObjectTypeGroveThing);
        return commonObjectGroveThing;
    }

    public <T extends Grove> T getGrove(IdentifierType identifierType) {
        return (T)this.groveMap.get((Object)identifierType);
    }

    <T extends GroveThing> T createGroveThing(IdentifierType identifierType) {
        return (T)((GroveThing)this.groveThingFactoryMap.get((Enum)identifierType));
    }

    SynchronizationArtifactBuilder getSynchronizationArtifactBuilder() {
        return this.synchronizationArtifactBuilder;
    }

    private void processArtifactReadable(int indent, ArtifactReadable artifactReadable, IdentifierType.Identifier specificationIdentifier, IdentifierType.Identifier parentIdentifier) {
        CommonObjectGroveThing specObject = this.createCommonObject(artifactReadable, IdentifierType.SPEC_OBJECT);
        IdentifierType.Identifier specObjectIdentifier = specObject.getGroveThingKey();
        ((SpecObjectGrove)this.getGrove(IdentifierType.SPEC_OBJECT)).add(specificationIdentifier, parentIdentifier, specObject);
        artifactReadable.getChildren().forEach(childArtifactReadable -> this.processArtifactReadable(indent + 1, (ArtifactReadable)childArtifactReadable, specificationIdentifier, specObjectIdentifier));
    }

    private void processAttributeDefinitionGrove() {
        AttributeDefinitionGrove attributeDefinitionGrove = (AttributeDefinitionGrove)this.getGrove(IdentifierType.ATTRIBUTE_DEFINITION);
        DataTypeDefinitionGrove dataTypeDefinitionGrove = (DataTypeDefinitionGrove)this.getGrove(IdentifierType.DATA_TYPE_DEFINITION);
        attributeDefinitionGrove.stream().forEach(attributeDefinition -> {
            AttributeTypeToken attributeTypeToken = (AttributeTypeToken)attributeDefinition.getNativeThing();
            NativeDataType nativeDataType = NativeDataType.classifyNativeDataType(attributeTypeToken);
            GroveThing dataTypeDefinition = dataTypeDefinitionGrove.getByNativeKey(nativeDataType.getId()).orElseGet(() -> dataTypeDefinitionGrove.add(new DataTypeDefinitionGroveThing().setNativeThing(nativeDataType)));
            ((AttributeDefinitionGroveThing)attributeDefinition).setDataTypeDefinition((DataTypeDefinitionGroveThing)dataTypeDefinition);
        });
    }

    private void processCommonObjectTypeContainerMap() {
        AttributeDefinitionGrove attributeDefinitionGrove = (AttributeDefinitionGrove)this.getGrove(IdentifierType.ATTRIBUTE_DEFINITION);
        this.commonObjectTypeContainerMap.values().forEach(commonObjectTypeContainer -> {
            List<CommonObjectTypeGroveThing> commonObjectTypes = commonObjectTypeContainer.get();
            ArtifactTypeToken artifactTypeToken = commonObjectTypeContainer.getArtifactTypeToken();
            List attributeTypeTokenList = artifactTypeToken.getValidAttributeTypes();
            attributeTypeTokenList.forEach(attributeTypeToken -> commonObjectTypes.forEach(commonObjectType -> {
                AttributeDefinitionGroveThing attributeDefinition = new AttributeDefinitionGroveThing();
                attributeDefinition.setNativeThing(attributeTypeToken);
                attributeDefinition.setParent((CommonObjectTypeGroveThing)commonObjectType);
                commonObjectType.add(attributeDefinition);
                attributeDefinitionGrove.add(attributeDefinition);
            }));
        });
    }

    private void processRootArtifact(Root root) {
        SpecificationGrove specificationGrove = (SpecificationGrove)this.getGrove(IdentifierType.SPECIFICATION);
        SpecObjectGrove specObjectGrove = (SpecObjectGrove)this.getGrove(IdentifierType.SPEC_OBJECT);
        BranchId branchId = root.getBranchId();
        ArtifactId artifactId = root.getArtifactId();
        ResultSet artifactReadableSet = this.orcsApi.getQueryFactory().fromBranch(branchId).andId(artifactId).getResults();
        ArtifactReadable rootArtifactReadable = (ArtifactReadable)artifactReadableSet.getExactlyOne();
        SpecificationGroveThing specification = (SpecificationGroveThing)this.createCommonObject(rootArtifactReadable, IdentifierType.SPECIFICATION);
        IdentifierType.Identifier specificationIdentifier = specification.getGroveThingKey();
        specificationGrove.add(specification);
        specObjectGrove.add(specification);
        rootArtifactReadable.getChildren().forEach(childArtifactReadable -> this.processArtifactReadable(1, (ArtifactReadable)childArtifactReadable, specificationIdentifier, specificationIdentifier));
    }

    private void processSpecObjectGrove() {
        SpecObjectGrove specObjectGrove = (SpecObjectGrove)this.getGrove(IdentifierType.SPEC_OBJECT);
        AttributeValueGrove attributeValueGrove = (AttributeValueGrove)this.getGrove(IdentifierType.ATTRIBUTE_VALUE);
        specObjectGrove.stream().forEach(groveThing -> {
            CommonObjectGroveThing commonObject = (CommonObjectGroveThing)groveThing;
            ArtifactReadable artifactReadable = (ArtifactReadable)commonObject.getNativeThing();
            CommonObjectTypeGroveThing commonObjectType = commonObject.getCommonObjectType();
            commonObjectType.streamAttributeDefinitions().forEach(attributeDefinition -> {
                AttributeTypeToken attributeTypeToken = (AttributeTypeToken)attributeDefinition.getNativeThing();
                try {
                    Object oseeAttributeValue = artifactReadable.getSoleAttributeValue(attributeTypeToken);
                    AttributeValueGroveThing attributeValue = (AttributeValueGroveThing)this.createGroveThing(IdentifierType.ATTRIBUTE_VALUE);
                    attributeValue.setParent(commonObject);
                    attributeValue.setAttributeDefinition((AttributeDefinitionGroveThing)attributeDefinition);
                    attributeValue.setNativeThing(oseeAttributeValue);
                    attributeValueGrove.add(attributeValue);
                }
                catch (Exception exception) {}
            });
        });
    }

    public InputStream serialize() {
        return this.synchronizationArtifactBuilder.serialize();
    }

    @Override
    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString(0);
        outMessage.append("\n").append("\n").append("\n").append(indent0).append("DOM Dump:").append("\n");
        this.groveMap.values().forEach(grove -> {
            StringBuilder stringBuilder2 = grove.toMessage(1, outMessage);
        });
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

