/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.convert;

import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.rest.internal.convert.AbstractConvertGuidToId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ConvertBaselineGuidToBaselineId
extends AbstractConvertGuidToId {
    public ConvertBaselineGuidToBaselineId(Log logger, JdbcClient jdbcClient, OrcsApi orcsApi, AtsApi atsApi) {
        super(logger, jdbcClient, orcsApi, atsApi);
    }

    public void run(XResultData data, boolean reportOnly, AtsApi atsApi) {
        if (reportOnly) {
            data.log("REPORT ONLY - Changes not persisted\n");
        }
        TransactionBuilder tx = this.createTransactionBuilder();
        int numChanges = 0;
        for (ArtifactReadable art : this.orcsApi.getQueryFactory().fromBranch((BranchId)atsApi.getAtsBranch()).andTypeEquals(new ArtifactTypeToken[]{AtsArtifactTypes.Version, AtsArtifactTypes.TeamDefinition}).andExists(new AttributeTypeToken[]{AtsAttributeTypes.BaselineBranchGuid}).getResults()) {
            List attributeValues = art.getAttributeValues((AttributeTypeToken)AtsAttributeTypes.BaselineBranchGuid);
            for (String guid : attributeValues) {
                if (guid.isEmpty()) continue;
                BranchId branch = null;
                try {
                    branch = this.getBranch(guid);
                }
                catch (Exception exception) {}
                if (branch == null) {
                    data.errorf("Branch with guid %s can't be found", new Object[]{guid});
                    continue;
                }
                String baseLine = art.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, null);
                if (Strings.isValid((String)baseLine) && !this.isIdDifferent(baseLine, branch)) continue;
                if (!Strings.isValid((String)baseLine)) {
                    data.logf("Adding id attribute of value %s to artifact type [%s] name [%s] id [%s]\n", new Object[]{branch, art.getArtifactType(), art.getName(), art.getIdString()});
                } else if (this.isIdDifferent(baseLine, branch)) {
                    data.logf("Updating id attribute of value %s to artifact type [%s] name [%s] id [%s]\n", new Object[]{branch, art.getArtifactType(), art.getName(), art.getIdString()});
                }
                ++numChanges;
                if (reportOnly) continue;
                tx.setSoleAttributeValue((ArtifactId)art, (AttributeTypeToken)AtsAttributeTypes.BaselineBranchId, (Object)branch.getIdString());
            }
        }
        if (!reportOnly) {
            data.log("\n" + numChanges + " Changes Persisted");
            tx.commit();
        } else {
            data.log("\n" + numChanges + " Need to be Changed");
        }
    }

    public String getDescription() {
        StringBuffer data = new StringBuffer();
        data.append("ConvertBaselineGuidToBaselineId (required conversion)\n\n");
        data.append("Necessary for upgrading from OSEE 0.16.2 to 0.17.0");
        data.append("- Verify that ats.BaselineBranchId is a valid attribute type\n");
        data.append("- Verify Add id attribute for every ats.BaselineBranchGuid attribute on Version artifacts\n");
        data.append("- Verify Add id attribute for every ats.BaselineBranchGuid attribute on Team Definition artifacts\n\n");
        data.append("NOTE: This operation can be run multiple times\n");
        data.append("Manual Cleanup (optional): Use Purge Attribute Type BLAM to remove the ats.BaselineBranchGuid attributes.");
        return data.toString();
    }

    public String getName() {
        return "ConvertBaselineGuidToBaselineId";
    }

    private boolean isIdDifferent(String id, BranchId branch) {
        return Strings.isValid((String)id) && branch.notEqual(Long.valueOf(id));
    }
}

