/*********************************************************************
 * Copyright (c) 2015 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.define.rest.internal;

import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;

/**
 * @author David W. Miller
 */
public class AlternateTypeOutput {
   ArtifactTypeToken alternateArtifact;
   AttributeTypeId alternateAttribute;

   public AlternateTypeOutput(ArtifactTypeToken alternateArtifact, AttributeTypeId alternateAttribute) {
      this.alternateArtifact = alternateArtifact;
      this.alternateAttribute = alternateAttribute;
   }

   public ArtifactTypeToken getAlternateArtifactType() {
      return alternateArtifact;
   }

   public AttributeTypeId getAlternateAttributeType() {
      return alternateAttribute;
   }
}
