/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.define.api.DataRightsOperations;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.DataRightsClassification;
import org.eclipse.osee.framework.core.model.datarights.DataRight;
import org.eclipse.osee.framework.core.model.datarights.DataRightAnchor;
import org.eclipse.osee.framework.core.model.datarights.DataRightEntry;
import org.eclipse.osee.framework.core.model.datarights.DataRightInput;
import org.eclipse.osee.framework.core.model.datarights.DataRightResult;
import org.eclipse.osee.framework.core.util.PageOrientation;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class DataRightsOperationsImpl
implements DataRightsOperations {
    private static final ArtifactToken MAPPING_ARTIFACT = ArtifactToken.valueOf((long)5443258L, (String)"DataRightsFooters", (BranchToken)CoreBranches.COMMON, (ArtifactTypeToken)CoreArtifactTypes.GeneralData);
    private final OrcsApi orcsApi;

    public DataRightsOperationsImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public DataRightResult getDataRights(List<ArtifactId> artifacts, BranchId branch) {
        return this.getDataRights(artifacts, branch, "");
    }

    public DataRightResult getDataRights(List<ArtifactId> artifacts, BranchId branch, String overrideClassification) {
        DataRightInput request = new DataRightInput();
        this.populateRequest(artifacts, branch, request, overrideClassification);
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
        DataRightResult mapping = new DataRightResult();
        Map<String, DataRight> classificationsToDataRights = this.getClassificationToDataRights(query);
        mapping.getDataRights().addAll(classificationsToDataRights.values());
        List<DataRightEntry> orderedData = this.getOrderedList(request);
        this.findMatchForAll(orderedData.iterator(), mapping.getDataRightAnchors(), classificationsToDataRights);
        return mapping;
    }

    private void populateRequest(List<ArtifactId> artifacts, BranchId branch, DataRightInput request, String overrideClassification) {
        int index = 0;
        if (!artifacts.isEmpty() && branch.isValid()) {
            Map artifactMap = this.orcsApi.getQueryFactory().fromBranch(branch).andIds(artifacts).asArtifactMap();
            for (ArtifactId artifact : artifacts) {
                ArtifactReadable art = (ArtifactReadable)artifactMap.getOrDefault(artifact, ArtifactReadable.SENTINEL);
                String classification = "";
                String orientation = "Portrait";
                if (DataRightsClassification.isValid((String)overrideClassification)) {
                    classification = overrideClassification;
                } else if (art.isValid()) {
                    classification = art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.DataRightsClassification, "");
                    orientation = art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.PageOrientation, "Portrait");
                }
                request.addData(artifact, classification, PageOrientation.fromString((String)orientation), index);
                ++index;
            }
        }
    }

    private DataRightAnchor getAnchor(ArtifactId id, Collection<DataRightAnchor> anchors) {
        for (DataRightAnchor anchor : anchors) {
            if (!anchor.getId().equals(id)) continue;
            return anchor;
        }
        return null;
    }

    private void findMatchForAll(Iterator<DataRightEntry> iterator, Collection<DataRightAnchor> anchors, Map<String, DataRight> classificationsToDataRight) {
        DataRightEntry previousArtifact = null;
        while (iterator.hasNext()) {
            DataRight dataRight;
            DataRightEntry currentArtifact = iterator.next();
            String classification = currentArtifact.getClassification();
            PageOrientation orientation = currentArtifact.getOrientation();
            boolean isSetDataRightFooter = false;
            if (previousArtifact == null) {
                isSetDataRightFooter = true;
            } else {
                String previousArtClassification = previousArtifact.getClassification();
                if (!classification.equals(previousArtClassification)) {
                    isSetDataRightFooter = true;
                } else {
                    DataRightAnchor previousArtAnchor = this.getAnchor(previousArtifact.getId(), anchors);
                    PageOrientation prevOrientation = previousArtifact.getOrientation();
                    if (previousArtAnchor != null && orientation.equals((Object)prevOrientation)) {
                        previousArtAnchor.setContinuous(true);
                    }
                }
            }
            if (!Strings.isValid((String)classification)) {
                classification = "DEFAULT";
            }
            if ((dataRight = classificationsToDataRight.get(classification)) == null) {
                classification = "Unspecified";
                dataRight = classificationsToDataRight.get(classification);
            }
            DataRightAnchor anchor = new DataRightAnchor();
            anchor.setSetDataRightFooter(isSetDataRightFooter);
            anchor.setId(currentArtifact.getId());
            anchor.setDataRight(dataRight);
            anchors.add(anchor);
            previousArtifact = currentArtifact;
        }
    }

    private List<DataRightEntry> getOrderedList(DataRightInput request) {
        ArrayList<DataRightEntry> orderedData = new ArrayList<DataRightEntry>();
        orderedData.addAll(request.getData());
        Collections.sort(orderedData, new Comparator<DataRightEntry>(){

            @Override
            public int compare(DataRightEntry arg0, DataRightEntry arg1) {
                return arg0.getIndex() - arg1.getIndex();
            }
        });
        return orderedData;
    }

    private Map<String, DataRight> getClassificationToDataRights(QueryBuilder query) {
        HashMap<String, DataRight> toReturn = new HashMap<String, DataRight>();
        List mappingArtifacts = query.andId((ArtifactId)MAPPING_ARTIFACT).asArtifacts();
        if (!mappingArtifacts.isEmpty()) {
            ArtifactReadable footerMappingArt = (ArtifactReadable)mappingArtifacts.get(0);
            List footers = new ArrayList();
            footers = footerMappingArt.getAttributeValues((AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
            for (String footer : footers) {
                String[] enumToFooter = footer.split("\\n", 2);
                if (enumToFooter.length != 2) continue;
                DataRight dataRight = new DataRight();
                dataRight.setContent(enumToFooter[1].trim());
                toReturn.put(enumToFooter[0].trim(), dataRight);
            }
        } else {
            DataRight dataRight = new DataRight();
            dataRight.setContent("<w:ftr w:type=\"odd\"><w:p><w:pPr><w:pStyle w:val=\"para8pt\"/><w:jc w:val=\"center\"/></w:pPr><w:r><w:rPr><w:rStyle w:val=\"PageNumber\"/></w:rPr><w:fldChar w:fldCharType=\"begin\"/></w:r><w:r><w:rPr><w:rStyle w:val=\"PageNumber\"/></w:rPr><w:instrText> PAGE </w:instrText></w:r><w:r><w:rPr><w:rStyle w:val=\"PageNumber\"/></w:rPr><w:fldChar w:fldCharType=\"separate\"/></w:r><w:r><w:rPr><w:rStyle w:val=\"PageNumber\"/><w:noProof/></w:rPr><w:t>5</w:t></w:r><w:r><w:rPr><w:rStyle w:val=\"PageNumber\"/></w:rPr><w:fldChar w:fldCharType=\"end\"/></w:r></w:p><w:p><w:pPr><w:spacing w:before=\"0\" w:after=\"0\" w:line=\"240\" w:line-rule=\"auto\"/><w:jc w:val=\"both\"/><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr></w:pPr><w:r><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr><w:t>UNSPECIFIED - PLEASE TAG WITH CORRECT DATA RIGHTS ATTRIBUTE!!!</w:t></w:r></w:p><w:p><w:pPr><w:spacing w:before=\"0\" w:after=\"0\" w:line=\"240\" w:line-rule=\"auto\"/><w:jc w:val=\"both\"/><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr></w:pPr><w:r><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr><w:t>Contract No.: </w:t></w:r></w:p><w:p><w:pPr><w:spacing w:before=\"0\" w:after=\"0\" w:line=\"240\" w:line-rule=\"auto\"/><w:jc w:val=\"both\"/><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr></w:pPr><w:r><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr><w:t>Contractor Name: The Boeing Company</w:t></w:r></w:p><w:p><w:pPr><w:spacing w:before=\"0\" w:after=\"0\" w:line=\"240\" w:line-rule=\"auto\"/><w:jc w:val=\"both\"/><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr></w:pPr><w:r><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr><w:t>Contractor Address: 5000 E. McDowell Road; Mesa, AZ 85215-9797 </w:t></w:r></w:p><w:p><w:pPr><w:spacing w:before=\"0\" w:after=\"0\" w:line=\"240\" w:line-rule=\"auto\"/><w:jc w:val=\"both\"/><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr></w:pPr><w:r><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr><w:t></w:t></w:r></w:p><w:p><w:pPr><w:spacing w:before=\"0\" w:after=\"0\" w:line=\"240\" w:line-rule=\"auto\"/><w:jc w:val=\"both\"/><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr></w:pPr></w:p><w:p><w:pPr><w:spacing w:before=\"0\" w:after=\"0\" w:line=\"240\" w:line-rule=\"auto\"/><w:jc w:val=\"both\"/><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr></w:pPr><w:r><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr><w:t>The Government's rights to use, modify, reproduce, release, perform, display, or disclose this software are restricted by paragraph (b)(3) of the Rights in Noncommercial Computer Software and Noncommercial Computer Software Documentation clause contained in the above identified contract.  Any reproduction of computer software or portions thereof marked with this legend must also reproduce the markings.  Any person, other than the Government, who has been provided access to such software must promptly notify the above named Contractor. </w:t></w:r></w:p><w:p><w:pPr><w:spacing w:before=\"0\" w:after=\"0\" w:line=\"240\" w:line-rule=\"auto\"/><w:jc w:val=\"both\"/><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr></w:pPr></w:p><w:p><w:pPr><w:spacing w:before=\"0\" w:after=\"0\" w:line=\"240\" w:line-rule=\"auto\"/><w:jc w:val=\"both\"/><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr></w:pPr><w:r><w:rPr><w:rFonts w:cs=\"Arial\"/><w:sz w:val=\"16\"/></w:rPr><w:t>Copyright (c) 2017 \u2013 The Boeing Company</w:t></w:r></w:p></w:ftr>");
            toReturn.put("Unspecified", dataRight);
        }
        return toReturn;
    }
}

