/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.workitem.bids;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.JaxTeamWorkflow;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.team.CreateTeamOption;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactData;
import org.eclipse.osee.ats.api.workflow.cr.bit.model.BuildImpactDatas;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.OrcsApi;

public class BidsOperations {
    private final AtsApi atsApi;
    private final OrcsApi orcsApi;

    public BidsOperations(AtsApi atsApi, OrcsApi orcsApi) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
    }

    public BuildImpactDatas createBids(BuildImpactDatas bids) {
        if (bids.getTeamWf() == null) {
            bids.getResults().errorf("Must specify Team Workflow\n", new Object[]{bids.getTeamWf()});
            return bids;
        }
        IAtsTeamWorkflow teamWf = this.atsApi.getWorkItemService().getTeamWf(bids.getTeamWf());
        if (teamWf == null) {
            bids.getResults().errorf("Invalid ATS Id [%s]\n", new Object[]{bids.getTeamWf()});
        }
        if (bids.getResults().isErrors()) {
            return bids;
        }
        try {
            AtsUser currentUser = this.atsApi.getUserService().getCurrentUser();
            IAtsChangeSet changes = this.atsApi.createChangeSet("Create Build Impact Data", currentUser);
            for (BuildImpactData bid : bids.getBuildImpacts()) {
                ArtifactToken bidArt = null;
                if (bid.getBidArt().getId() > 0L) {
                    bidArt = this.atsApi.getQueryService().getArtifact(bid.getBidArt().getId());
                } else {
                    bidArt = changes.createArtifact(bids.getBidArtType(), bid.getBidArt().getName());
                    bid.setBidArt(bidArt);
                    changes.relate((Object)teamWf, AtsRelationTypes.BuildImpactTableToData_Bid, (Object)bidArt);
                    ArtifactToken verArt = this.atsApi.getQueryService().getArtifact((ArtifactId)bid.getBuild());
                    if (verArt != null) {
                        changes.relate((ArtifactId)bidArt, AtsRelationTypes.BuildImpactDataToVer_Version, (ArtifactId)verArt);
                        Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)verArt);
                        IAtsTeamDefinition teamDef = this.atsApi.getVersionService().getTeamDefinition((IAtsVersion)version);
                        IAtsProgram program = this.atsApi.getProgramService().getProgram(teamDef);
                        bid.setProgram(program.getArtifactToken());
                    }
                }
                changes.setAttributeValues((ArtifactId)bidArt, (AttributeTypeToken)AtsAttributeTypes.BitConfig, Collections.castAll((Collection)bid.getConfigs()));
                if (Strings.isValid((String)bid.getState())) {
                    changes.setSoleAttributeValue((ArtifactId)bidArt, (AttributeTypeToken)AtsAttributeTypes.BitState, (Object)bid.getState());
                }
                for (JaxTeamWorkflow jTeamWf : bid.getTeamWfs()) {
                    if (!jTeamWf.getNewAi().isValid()) continue;
                    ActionableItem ai = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)jTeamWf.getNewAi());
                    IAtsTeamDefinition teamDef = this.atsApi.getTeamDefinitionService().getImpactedTeamDef((IAtsActionableItem)ai);
                    Date createdDate = new Date();
                    IAtsTeamWorkflow newTeamWf = this.atsApi.getActionService().createTeamWorkflow(teamWf.getParentAction(), teamDef, Arrays.asList(ai), null, changes, createdDate, currentUser, null, new CreateTeamOption[]{CreateTeamOption.Duplicate_If_Exists});
                    this.populateJaxTeamWf(jTeamWf, newTeamWf);
                    changes.relate((Object)bidArt, AtsRelationTypes.BuildImpactDataToTeamWf_TeamWf, (Object)newTeamWf);
                }
            }
            TransactionToken transaction = changes.execute();
            teamWf = this.atsApi.getWorkItemService().getTeamWf(this.atsApi.getQueryService().getArtifact(teamWf.getId()));
            bids.setTransaction(TransactionId.valueOf((Long)transaction.getId()));
        }
        catch (Exception ex) {
            bids.getResults().errorf("Exception adding bids %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return bids;
    }

    private void populateJaxTeamWf(JaxTeamWorkflow jTeamWf, IAtsTeamWorkflow newTeamWf) {
        jTeamWf.setTeam(newTeamWf.getTeamDefinition().getStoreObject());
        jTeamWf.setAtsId(newTeamWf.getAtsId());
        jTeamWf.setName(newTeamWf.getName());
        jTeamWf.setId(newTeamWf.getId());
        jTeamWf.setStateType(newTeamWf.getStateMgr().getCurrentStateType());
        jTeamWf.setCurrentState(newTeamWf.getStateMgr().getCurrentStateName());
    }

    public BuildImpactDatas getBids(String atsId) {
        BuildImpactDatas bids = new BuildImpactDatas();
        IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)this.atsApi.getWorkItemService().getWorkItemByAtsId(atsId);
        if (teamWf == null) {
            bids.getResults().errorf("Invalid ATS Id [%s]", new Object[]{bids.getTeamWf()});
        }
        if (bids.getResults().isErrors()) {
            return bids;
        }
        bids.setTeamWf(teamWf.getStoreObject());
        IAtsProgram program = this.atsApi.getProgramService().getProgram((IAtsWorkItem)teamWf);
        BranchToken branch = this.atsApi.getProgramService().getProductLineBranch(program);
        for (ArtifactToken view : this.orcsApi.getQueryFactory().applicabilityQuery().getViewsForBranch((BranchId)branch)) {
            bids.addConfig(view);
        }
        for (ArtifactToken bidArt : this.atsApi.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.BuildImpactTableToData_Bid)) {
            BuildImpactData bid = new BuildImpactData();
            bid.setBidArt(bidArt);
            for (Object obj : this.atsApi.getAttributeResolver().getAttributeValues((ArtifactId)bidArt, (AttributeTypeToken)AtsAttributeTypes.BitConfig)) {
                ArtifactId configArt = (ArtifactId)obj;
                ArtifactToken config = (ArtifactToken)bids.getIdToConfig().get(configArt.getId());
                bid.getConfigs().add(config);
            }
            bid.setState((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)bidArt, (AttributeTypeToken)AtsAttributeTypes.BitState, (Object)""));
            ArtifactToken verArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)bidArt, AtsRelationTypes.BuildImpactDataToVer_Version);
            bid.setBuild(verArt);
            bids.addBuildImpactData(bid);
            if (verArt != null) {
                Version version = this.atsApi.getVersionService().getVersionById((ArtifactId)verArt);
                IAtsTeamDefinition teamDef = this.atsApi.getVersionService().getTeamDefinition((IAtsVersion)version);
                IAtsProgram prog = this.atsApi.getProgramService().getProgram(teamDef);
                bid.setProgram(prog.getArtifactToken());
            }
            for (ArtifactToken bidTeamWfArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)bidArt, AtsRelationTypes.BuildImpactDataToTeamWf_TeamWf)) {
                if (!bidTeamWfArt.isValid()) continue;
                IAtsTeamWorkflow bidTeamWf = this.atsApi.getWorkItemService().getTeamWf(bidTeamWfArt);
                JaxTeamWorkflow jTeamWf = new JaxTeamWorkflow();
                bid.getTeamWfs().add(jTeamWf);
                this.populateJaxTeamWf(jTeamWf, bidTeamWf);
            }
        }
        return bids;
    }

    public BuildImpactDatas deleteBids(BuildImpactDatas bids) {
        if (bids.getTeamWf() == null) {
            bids.getResults().errorf("Must specify Team Workflow\n", new Object[]{bids.getTeamWf()});
            return bids;
        }
        IAtsTeamWorkflow teamWf = this.atsApi.getWorkItemService().getTeamWf(bids.getTeamWf());
        if (teamWf == null) {
            bids.getResults().errorf("Invalid ATS Id [%s]\n", new Object[]{bids.getTeamWf()});
        }
        if (bids.getResults().isErrors()) {
            return bids;
        }
        try {
            AtsUser currentUser = this.atsApi.getUserService().getCurrentUser();
            IAtsChangeSet changes = this.atsApi.createChangeSet("Create Build Impact Data", currentUser);
            for (BuildImpactData bid : bids.getBuildImpacts()) {
                if (bid.getBidArt().isInvalid()) {
                    bids.getResults().errorf("Invalid BID Artifact Token", new Object[0]);
                }
                changes.deleteArtifact(ArtifactId.valueOf((Long)bid.getBidArt().getId()));
            }
            if (bids.getResults().isErrors()) {
                return bids;
            }
            TransactionToken transaction = changes.executeIfNeeded();
            bids.setTransaction(TransactionId.valueOf((Long)transaction.getId()));
        }
        catch (Exception ex) {
            bids.getResults().errorf("Exception adding bids %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return bids;
    }
}

