/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.agile;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.rest.internal.agile.FeatureGroupSum;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResourceToken;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.template.engine.PageCreator;

public class SprintPageBuilder {
    private final ArtifactReadable sprint;
    private Date startDate;
    private Date endDate;
    private final SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
    private int numActionsCompleted = 0;
    private double workCompleted = 0.0;
    private double walkupCompleted = 0.0;
    private int numActionsStarted = 0;
    private int numActionsBacklog = 0;
    TreeMap<String, FeatureGroupSum> featureSums = new TreeMap();
    private final ArtifactReadable team;
    private final AtsApi atsApi;

    public SprintPageBuilder(ArtifactReadable team, ArtifactReadable sprint, AtsApi atsApi) {
        this.team = team;
        this.sprint = sprint;
        this.atsApi = atsApi;
    }

    public String generatePage(PageCreator page, ResourceToken token) {
        this.calculateData();
        page.addKeyValuePairs(new String[]{"sprintName", this.sprint.getName()});
        page.addKeyValuePairs(new String[]{"teamName", this.team.getName()});
        page.addKeyValuePairs(new String[]{"summaryDate", DateUtil.getDateNow((String)"MM/dd/yyyy hh:mm a")});
        page.addKeyValuePairs(new String[]{"beginDate", this.getStartDate()});
        page.addKeyValuePairs(new String[]{"endDate", this.getEndDate()});
        page.addKeyValuePairs(new String[]{"workCompleted", this.getWorkCompleted()});
        page.addKeyValuePairs(new String[]{"walkupCompleted", this.getWalkupCompleted()});
        page.addKeyValuePairs(new String[]{"numActionsCompleted", this.getNumActionsCompleted()});
        page.addKeyValuePairs(new String[]{"numActionsStarted", this.getNumActionsStarted()});
        page.addKeyValuePairs(new String[]{"numActionsBacklog", this.getNumActionsBacklog()});
        page.addKeyValuePairs(new String[]{"tableContent", this.getTable()});
        String html = page.realizePage(token);
        html = AtsUtil.resolveAjaxToBaseApplicationServer((String)html, (AtsApi)this.atsApi);
        return html;
    }

    private void calculateData() {
        this.initCalculations();
        this.calculateBacklogCount();
        this.calculateActionsCreated();
        this.featureSums.clear();
        ResultSet actions = this.sprint.getRelated(AtsRelationTypes.AgileSprintToItem_AtsItem);
        for (ArtifactReadable item : actions) {
            if (!this.includeInCount(item)) continue;
            ++this.numActionsCompleted;
            double points = this.getPointsFromAction(item);
            if (((Boolean)item.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.UnplannedWork, (Object)false)).booleanValue()) {
                this.walkupCompleted += points;
            } else {
                this.workCompleted += points;
            }
            this.updateFeatureGroupSum(item, this.featureSums, points);
        }
    }

    private double getPointsFromAction(ArtifactReadable item) {
        double points = 0.0;
        ArtifactReadable agileTeam = (ArtifactReadable)this.sprint.getRelated(AtsRelationTypes.AgileTeamToSprint_AgileTeam).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (agileTeam.isValid()) {
            String pointsAttrType = agileTeam.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.PointsAttributeType, "");
            if (Strings.isValid((String)pointsAttrType) && pointsAttrType.equals(AtsAttributeTypes.PointsNumeric.getName())) {
                points = (Double)item.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.PointsNumeric, (Object)0.0);
            } else {
                String value = item.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.Points, "0");
                if (Strings.isNumeric((String)value)) {
                    points = Double.parseDouble(value);
                }
            }
        }
        return points;
    }

    private ArtifactReadable calculateActionsCreated() {
        ArtifactReadable agileTeam = (ArtifactReadable)this.sprint.getRelated(AtsRelationTypes.AgileTeamToSprint_AgileTeam).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (agileTeam.isValid()) {
            ResultSet agileItems = this.sprint.getRelated(AtsRelationTypes.AgileSprintToItem_AtsItem);
            this.numActionsStarted += this.countIfInTimeFrame((ResultSet<ArtifactReadable>)agileItems);
            ArtifactReadable backlog = (ArtifactReadable)agileTeam.getRelated(AtsRelationTypes.AgileTeamToBacklog_Backlog).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
            if (backlog.isValid()) {
                ResultSet backlogItems = backlog.getRelated(AtsRelationTypes.Goal_Member);
                this.numActionsStarted += this.countIfInTimeFrame((ResultSet<ArtifactReadable>)backlogItems);
            }
        }
        return agileTeam;
    }

    private int countIfInTimeFrame(ResultSet<ArtifactReadable> agileItems) {
        int numFound = 0;
        for (ArtifactReadable item : agileItems) {
            Date artCreated = (Date)item.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.CreatedDate, null);
            if (artCreated == null || !artCreated.after(this.startDate) || !artCreated.before(this.endDate)) continue;
            ++numFound;
        }
        return numFound;
    }

    private void updateFeatureGroupSum(ArtifactReadable item, TreeMap<String, FeatureGroupSum> featureSums, double points) {
        String featureGroupName = null;
        ArtifactReadable featureGroup = (ArtifactReadable)item.getRelated(AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup).getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        featureGroupName = featureGroup.isInvalid() ? "UnSet" : featureGroup.getName();
        FeatureGroupSum feature = featureSums.get(featureGroupName);
        if (feature == null) {
            feature = new FeatureGroupSum(featureGroupName, featureGroup.isInvalid() ? "" : featureGroup.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.Description, ""));
        }
        feature.addToSum(points);
        featureSums.put(featureGroupName, feature);
    }

    private boolean includeInCount(ArtifactReadable item) {
        return "Completed".equals(item.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CurrentStateType)) || "Cancelled".equals(item.getSoleAttributeAsString((AttributeTypeToken)AtsAttributeTypes.CurrentStateType));
    }

    private void calculateBacklogCount() {
        ArtifactReadable goal;
        ArtifactReadable team = (ArtifactReadable)this.sprint.getRelated(AtsRelationTypes.AgileTeamToSprint_AgileTeam).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (team.isValid() && (goal = (ArtifactReadable)team.getRelated(AtsRelationTypes.AgileTeamToBacklog_Backlog).getOneOrDefault((Object)ArtifactReadable.SENTINEL)).isValid()) {
            ResultSet members = goal.getRelated(AtsRelationTypes.Goal_Member);
            this.numActionsBacklog = members.size();
        }
    }

    private void initCalculations() {
        try {
            this.startDate = this.adjustDate((Date)this.sprint.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.StartDate), false);
            this.endDate = this.adjustDate((Date)this.sprint.getSoleAttributeValue((AttributeTypeToken)AtsAttributeTypes.EndDate), true);
        }
        catch (Exception exception) {
            throw new OseeCoreException("Start Date and End Date must be set in Sprint [%s]", new Object[]{this.sprint.getName()});
        }
        this.numActionsCompleted = 0;
        this.workCompleted = 0.0;
        this.walkupCompleted = 0.0;
        this.numActionsCompleted = 0;
        this.numActionsStarted = 0;
        this.numActionsBacklog = 0;
    }

    private Date adjustDate(Date date, boolean isEnd) {
        int hour = 0;
        int min = 0;
        int sec = 0;
        if (isEnd) {
            hour = 23;
            min = 59;
            sec = 59;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, hour);
        cal.set(12, min);
        cal.set(13, sec);
        cal.set(14, 0);
        return cal.getTime();
    }

    private String getStartDate() {
        return this.df.format(this.startDate);
    }

    private String getEndDate() {
        return this.df.format(this.endDate);
    }

    private String getWorkCompleted() {
        return Integer.valueOf(Double.valueOf(this.workCompleted).intValue()).toString();
    }

    private String getWalkupCompleted() {
        return Integer.valueOf(Double.valueOf(this.walkupCompleted).intValue()).toString();
    }

    private String getNumActionsCompleted() {
        return Integer.toString(this.numActionsCompleted);
    }

    private String getNumActionsStarted() {
        return Integer.toString(this.numActionsStarted);
    }

    private String getNumActionsBacklog() {
        return Integer.toString(this.numActionsBacklog);
    }

    private String getTable() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, FeatureGroupSum> feature : this.featureSums.entrySet()) {
            sb.append(feature.getValue().getHTML());
        }
        return sb.toString();
    }
}

