/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds.criteria;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.core.ds.Criteria;
import org.eclipse.osee.orcs.core.ds.Options;

public class CriteriaArtifactType
extends Criteria {
    private final Collection<ArtifactTypeToken> artifactTypes;
    private final boolean includeTypeInheritance;

    public CriteriaArtifactType(Collection<ArtifactTypeToken> artifactTypes, boolean includeTypeInheritance) {
        this.artifactTypes = artifactTypes;
        this.includeTypeInheritance = includeTypeInheritance;
    }

    @Override
    public void checkValid(Options options) {
        Conditions.checkNotNullOrEmpty(this.artifactTypes, (String)"artifact types");
    }

    public Collection<ArtifactTypeToken> getOriginalTypes() {
        return this.artifactTypes;
    }

    public Collection<? extends ArtifactTypeId> getTypes() {
        if (this.includeTypeInheritance) {
            LinkedHashSet<ArtifactTypeToken> typesToUse = new LinkedHashSet<ArtifactTypeToken>();
            typesToUse.addAll(this.artifactTypes);
            for (ArtifactTypeToken type : this.artifactTypes) {
                typesToUse.addAll(type.getAllDescendantTypes());
            }
            return typesToUse;
        }
        return this.artifactTypes;
    }

    @Override
    public String toString() {
        return "CriteriaArtifactType [artifactTypes=" + this.artifactTypes + ", includeTypeInheritance=" + this.includeTypeInheritance + "]";
    }
}

