/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.GetAllMIMRelatedObjectsEndpoint;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.types.InterfaceConnection;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.ResolvedStructurePath;
import org.eclipse.osee.mim.types.StructurePath;

public class GetAllMIMRelatedObjectsEndpointImpl
implements GetAllMIMRelatedObjectsEndpoint {
    private final BranchId branch;
    private final InterfaceNodeViewApi interfaceNodeApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;
    private final InterfaceMessageApi messageApi;
    private final InterfaceSubMessageApi subMessageApi;
    private final InterfaceStructureApi interfaceStructureApi;

    public GetAllMIMRelatedObjectsEndpointImpl(BranchId branch, InterfaceStructureApi interfaceStructureApi, InterfaceMessageApi interfaceMessageApi, InterfaceSubMessageApi interfaceSubMessageApi, InterfaceNodeViewApi interfaceNodeApi, InterfaceConnectionViewApi interfaceConnectionViewApi) {
        this.branch = branch;
        this.interfaceNodeApi = interfaceNodeApi;
        this.interfaceConnectionApi = interfaceConnectionViewApi;
        this.messageApi = interfaceMessageApi;
        this.subMessageApi = interfaceSubMessageApi;
        this.interfaceStructureApi = interfaceStructureApi;
    }

    @Override
    public Collection<StructurePath> getAllStructureNames() {
        try {
            List<StructurePath> structures = this.interfaceStructureApi.getAccessor().getAll(this.branch, InterfaceStructureToken.class).stream().map(a -> new StructurePath(a.getId(), a.getName(), a.getDescription())).collect(Collectors.toList());
            structures = this.getStructureNames(structures);
            return structures;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<StructurePath>();
        }
    }

    private List<StructurePath> getStructureNames(List<StructurePath> structures) {
        try {
            for (StructurePath structure : structures) {
                for (InterfaceSubMessageToken submessage : this.subMessageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceSubMessageContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceSubMessageToken.class)) {
                    for (InterfaceMessageToken message : this.messageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage, ArtifactId.valueOf((Long)submessage.getId()), InterfaceMessageToken.class)) {
                        for (InterfaceConnection connection : this.interfaceConnectionApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceConnectionContent_Message, ArtifactId.valueOf((Long)message.getId()), InterfaceConnection.class)) {
                            structure.addPath(new ResolvedStructurePath(String.valueOf(message.getName()) + " > " + submessage.getName(), "/" + connection.getIdString() + "/messages/" + message.getIdString() + "/" + submessage.getIdString() + "/" + message.getName() + " > " + submessage.getName() + "/elements/" + structure.getIdString()));
                        }
                    }
                }
            }
            Collections.sort(structures, new Comparator<StructurePath>(){

                @Override
                public int compare(StructurePath o1, StructurePath o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            return structures;
        }
        catch (Exception exception) {
            return new LinkedList<StructurePath>();
        }
    }

    private List<AttributeTypeId> createStructureAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceStructureCategory);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMinSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMaxSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceTaskFileType);
        return attributes;
    }

    @Override
    public Collection<StructurePath> getFilteredStructureNames(String filter) {
        try {
            List<StructurePath> structures = this.interfaceStructureApi.getAccessor().getAllByFilter(this.branch, filter, this.createStructureAttributeList(), InterfaceStructureToken.class).stream().map(a -> new StructurePath(a.getId(), a.getName(), a.getDescription())).collect(Collectors.toList());
            structures = this.getStructureNames(structures);
            return structures;
        }
        catch (Exception exception) {
            return new LinkedList<StructurePath>();
        }
    }
}

