/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.types.PLGenericDBObject;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class ArtifactAccessorImpl<T extends PLGenericDBObject>
implements ArtifactAccessor<T> {
    private ArtifactTypeToken artifactType = ArtifactTypeToken.SENTINEL;
    private final OrcsApi orcsApi;

    public ArtifactAccessorImpl(ArtifactTypeToken artifactType, OrcsApi orcsApi) {
        this.setArtifactType(artifactType);
        this.orcsApi = orcsApi;
    }

    @Override
    public T get(BranchId branch, ArtifactId artId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactReadable artifact = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{this.artifactType}).andId(artId).asArtifactOrSentinel();
        if (artifact.isValid()) {
            PLGenericDBObject returnObj = (PLGenericDBObject)((Object)clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact));
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke((Object)returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(artId, branch));
            }
            return (T)((Object)returnObj);
        }
        return (T)((Object)((PLGenericDBObject)((Object)clazz.newInstance())));
    }

    @Override
    public Collection<T> getAll(BranchId branch, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedList<PLGenericDBObject> artifactList = new LinkedList<PLGenericDBObject>();
        for (ArtifactReadable artifact : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{this.artifactType}).asArtifacts()) {
            if (!artifact.isValid()) continue;
            PLGenericDBObject returnObj = (PLGenericDBObject)((Object)clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact));
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke((Object)returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken((ArtifactId)artifact, branch));
            }
            artifactList.add(returnObj);
        }
        return artifactList;
    }

    @Override
    public T getByRelation(BranchId branch, ArtifactId artId, RelationTypeSide relation, ArtifactId relatedId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactReadable artifact = this.orcsApi.getQueryFactory().fromBranch(branch).andRelatedTo(relation, relatedId).andId(artId).asArtifactOrSentinel();
        if (artifact.isValid()) {
            PLGenericDBObject returnObj = (PLGenericDBObject)((Object)clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact));
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke((Object)returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(artId, branch));
            }
            return (T)((Object)returnObj);
        }
        return (T)((Object)((PLGenericDBObject)((Object)clazz.newInstance())));
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedList<PLGenericDBObject> artifactList = new LinkedList<PLGenericDBObject>();
        for (ArtifactReadable artifact : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{this.artifactType}).andRelatedTo(relation, relatedId).asArtifacts()) {
            if (!artifact.isValid()) continue;
            PLGenericDBObject returnObj = (PLGenericDBObject)((Object)clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact));
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke((Object)returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken((ArtifactId)artifact, branch));
            }
            artifactList.add(returnObj);
        }
        return artifactList;
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Collection<AttributeTypeId> attributes, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedList<PLGenericDBObject> artifactList = new LinkedList<PLGenericDBObject>();
        for (ArtifactReadable artifact : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{this.artifactType}).and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY}).getResults().getList()) {
            if (!artifact.isValid()) continue;
            PLGenericDBObject returnObj = (PLGenericDBObject)((Object)clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact));
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke((Object)returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken((ArtifactId)artifact, branch));
            }
            artifactList.add(returnObj);
        }
        return artifactList;
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Collection<AttributeTypeId> attributes, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedList<PLGenericDBObject> artifactList = new LinkedList<PLGenericDBObject>();
        for (ArtifactReadable artifact : this.orcsApi.getQueryFactory().fromBranch(branch).andRelatedTo(relation, relatedId).and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY}).getResults().getList()) {
            if (!artifact.isValid()) continue;
            PLGenericDBObject returnObj = (PLGenericDBObject)((Object)clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact));
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke((Object)returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken((ArtifactId)artifact, branch));
            }
            artifactList.add(returnObj);
        }
        return artifactList;
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactTypeToken artifactType) {
        this.artifactType = artifactType;
    }

    @Override
    public T getByRelationWithoutId(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactReadable artifact = this.orcsApi.getQueryFactory().fromBranch(branch).andRelatedTo(relation, relatedId).asArtifactOrSentinel();
        if (artifact.isValid()) {
            PLGenericDBObject returnObj = (PLGenericDBObject)((Object)clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact));
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke((Object)returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken((ArtifactId)artifact, branch));
            }
            return (T)((Object)returnObj);
        }
        return (T)((Object)((PLGenericDBObject)((Object)clazz.newInstance())));
    }

    private boolean hasSetApplic(Class<?> type) {
        return this.getSetApplic(type) != null;
    }

    private Method getSetApplic(Class<?> type) {
        Method[] methodArray = type.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("set") && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getReturnType()) && method.getName().endsWith("Applicability")) {
                return method;
            }
            ++n2;
        }
        return null;
    }
}

