/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.web.rest.layer.util;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.eclipse.osee.framework.authentication.ldap.core.Activator;
import org.eclipse.osee.framework.authentication.ldap.core.internal.LDAPConnector;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.icteam.common.clientserver.LdapUserDetailsWrapper;

public class LdapUtil {
    public static List<LdapUserDetailsWrapper> getLDAPSearchResult(String username) {
        ArrayList<LdapUserDetailsWrapper> userList = new ArrayList<LdapUserDetailsWrapper>();
        SearchResult searchResult = null;
        String searchFilter = "(&(objectCategory=person)(|(sAMAccountName=" + username + "*)(givenName=" + username + "*)(displayname=" + username + "*)))";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> results = null;
            InitialLdapContext ctxInstance = LDAPConnector.getCtxInstance();
            String getsearchBaseFromDb = LDAPConnector.getsearchBaseFromDb();
            if (ctxInstance != null) {
                results = ctxInstance.search(getsearchBaseFromDb, searchFilter, searchControls);
                ctxInstance.close();
                LDAPConnector.setCtxInstance(null);
            }
            if (results != null) {
                Attributes attribs = null;
                while (results.hasMoreElements()) {
                    Attribute attributeMail;
                    Attribute attributeUserID;
                    searchResult = (SearchResult)results.nextElement();
                    attribs = searchResult.getAttributes();
                    if (attribs.size() <= 0) continue;
                    LdapUserDetailsWrapper userDetails = new LdapUserDetailsWrapper();
                    Attribute attributeName = attribs.get("displayname");
                    if (attributeName != null) {
                        NamingEnumeration<?> nameMembers = attributeName.getAll();
                        while (nameMembers != null && nameMembers.hasMoreElements()) {
                            String displayName = (String)nameMembers.next();
                            userDetails.setDisplayName(displayName);
                        }
                    }
                    if ((attributeUserID = attribs.get("sAMAccountName")) != null) {
                        NamingEnumeration<?> accNameMembers = attributeUserID.getAll();
                        while (accNameMembers != null && accNameMembers.hasMoreElements()) {
                            String accName = (String)accNameMembers.next();
                            userDetails.setUserId(accName);
                        }
                    }
                    if ((attributeMail = attribs.get("mail")) != null) {
                        NamingEnumeration<?> mailMembers = attributeMail.getAll();
                        while (mailMembers != null && mailMembers.hasMoreElements()) {
                            String mailName = (String)mailMembers.next();
                            userDetails.setMail(mailName);
                        }
                    }
                    userList.add(userDetails);
                }
            }
        }
        catch (NamingException e) {
            OseeLog.logf(Activator.class, (Level)Level.INFO, (String)e.getMessage(), (Object[])new Object[]{null});
        }
        return userList;
    }
}

