/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.util;

import java.util.AbstractSet;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.osee.synchronization.util.EnumFunctionMap;
import org.eclipse.osee.synchronization.util.EnumMapDuplicateEntryException;

public class AbstractEnumFunctionMap<K extends Enum<K>, F>
implements EnumFunctionMap<K, F> {
    EnumMap<K, F> enumMap;

    AbstractEnumFunctionMap(Class<K> enumerationKeyClass) {
        this.enumMap = new EnumMap<K, F>(enumerationKeyClass){
            private static final long serialVersionUID = 1L;

            @Override
            public Set<K> keySet() {
                final Set superKeySet = super.keySet();
                return new AbstractSet<K>(){

                    @Override
                    public boolean add(K k) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Iterator<K> iterator() {
                        final Iterator rvIterator = superKeySet.iterator();
                        return new Iterator<K>(){

                            @Override
                            public boolean hasNext() {
                                return rvIterator.hasNext();
                            }

                            @Override
                            public K next() {
                                return (Enum)rvIterator.next();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return superKeySet.size();
                    }
                };
            }
        };
    }

    @Override
    public boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.enumMap.containsKey(key);
    }

    @Override
    public Optional<F> getFunction(K key) {
        return Optional.ofNullable(this.enumMap.get(key));
    }

    @Override
    public boolean isEmpty() {
        return this.enumMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.enumMap.keySet();
    }

    @Override
    public void put(K key, F function) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(function);
        if (this.enumMap.containsKey(key)) {
            throw new EnumMapDuplicateEntryException(key);
        }
        this.enumMap.put(key, function);
    }

    @Override
    public int size() {
        return this.enumMap.size();
    }
}

