/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.synchronization.api.SynchronizationEndpoint;
import org.eclipse.osee.synchronization.rest.RootList;
import org.eclipse.osee.synchronization.rest.SynchronizationArtifact;
import org.eclipse.osee.synchronization.rest.UnknownSynchronizationArtifactTypeException;
import org.eclipse.osee.synchronization.util.CharSequenceStreamingOutput;
import org.eclipse.osee.synchronization.util.InputStreamStreamingOutput;

public class SynchronizationEndpointImpl
implements SynchronizationEndpoint {
    private final OrcsApi orcsApi;

    public SynchronizationEndpointImpl(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public Response getSynchronizationArtifact(BranchId branchId, ArtifactId artifactId, String artifactType) {
        try {
            RootList rootList = RootList.create(this.orcsApi, artifactType, branchId, artifactId);
            return this.processRootList(rootList);
        }
        catch (Exception e) {
            return Response.ok((Object)new CharSequenceStreamingOutput(e.getMessage())).status(Response.Status.BAD_REQUEST).build();
        }
    }

    public Response getSynchronizationArtifact(String roots, String artifactType) {
        try {
            RootList rootList = RootList.create(this.orcsApi, artifactType, roots);
            return this.processRootList(rootList);
        }
        catch (Exception e) {
            return Response.ok((Object)new CharSequenceStreamingOutput(e.getMessage())).status(Response.Status.BAD_REQUEST).build();
        }
    }

    private Response processRootList(RootList rootList) {
        try {
            SynchronizationArtifact synchronizationArtifact = SynchronizationArtifact.create(rootList);
            synchronizationArtifact.build();
            InputStream inputStream = synchronizationArtifact.serialize();
            return Response.ok((Object)new InputStreamStreamingOutput(inputStream)).build();
        }
        catch (UnknownSynchronizationArtifactTypeException e) {
            return Response.ok((Object)new CharSequenceStreamingOutput(e.getMessage())).status(Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder(2048);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            message.append("<---E-X-C-E-P-T-I-O-N--->").append("\n").append(e.getMessage()).append("\n").append(stringWriter.toString()).append("\n");
            return Response.ok((Object)new CharSequenceStreamingOutput(message)).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

