/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.reqif.export;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.icteam.reqif.export.CustomisedXmlTextInputStream;
import org.eclipse.osee.icteam.reqif.export.RMFUtility;
import org.eclipse.osee.icteam.reqif.export.ReqIFUtil;
import org.eclipse.osee.icteam.reqif.export.UniqueIdentifierGenerator;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinitionBoolean;
import org.eclipse.rmf.reqif10.DatatypeDefinitionDate;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionInteger;
import org.eclipse.rmf.reqif10.DatatypeDefinitionReal;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.ReqIFHeader;
import org.eclipse.rmf.reqif10.ReqIFToolExtension;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecObjectType;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecRelationType;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.SpecificationType;
import org.eclipse.rmf.reqif10.XhtmlContent;
import org.eclipse.rmf.reqif10.xhtml.XhtmlDivType;
import org.eclipse.rmf.reqif10.xhtml.XhtmlFactory;

public class ReqIfCreateResoure {
    Map<String, List<Object>> typesMap = new HashMap<String, List<Object>>();

    public void createReqIfResource(String fileName, List<Artifact> artifacts) throws OseeCoreException, DatatypeConfigurationException, IOException {
        fileName = String.valueOf(fileName) + ".reqif";
        UniqueIdentifierGenerator.resetNumber();
        ReqIF reqif = ReqIF10Factory.eINSTANCE.createReqIF();
        ReqIFHeader header = this.createReqIFHeader();
        reqif.setTheHeader(header);
        ReqIFContent coreContent = this.createCoreContent(artifacts);
        reqif.setCoreContent(coreContent);
        reqif.getToolExtensions().add((Object)this.createReqifToolExtension());
        RMFUtility.saveReqIFFile(reqif, fileName);
    }

    private ReqIFToolExtension createReqifToolExtension() {
        ReqIFToolExtension toolExtension = ReqIF10Factory.eINSTANCE.createReqIFToolExtension();
        return toolExtension;
    }

    private ReqIFContent createCoreContent(List<Artifact> artifacts) throws OseeCoreException, DatatypeConfigurationException {
        ReqIFContent reqifContent = ReqIF10Factory.eINSTANCE.createReqIFContent();
        this.createSpecification(artifacts, reqifContent);
        this.createSpecObjects(reqifContent);
        this.createSpecRelations(artifacts, reqifContent);
        this.createSpecTypes(reqifContent);
        this.createDataTypes(reqifContent);
        return reqifContent;
    }

    private void createSpecRelations(List<Artifact> artifacts, ReqIFContent reqifcontent) throws OseeCoreException, DatatypeConfigurationException {
        ArrayList<RelationLink> relationLink = new ArrayList<RelationLink>();
        for (Artifact artifact : artifacts) {
            List children = null;
            children = artifact.getChildren();
            for (Artifact artifactChild : children) {
                List relationsHigerLevel = artifactChild.getRelations(CoreRelationTypes.RequirementTrace_HigherLevelRequirement);
                List relationsLowerLevel = artifactChild.getRelations(CoreRelationTypes.RequirementTrace_LowerLevelRequirement);
                for (RelationLink relationLink2 : relationsLowerLevel) {
                    if (relationLink.contains(relationLink2)) continue;
                    relationLink.add(relationLink2);
                }
                for (RelationLink relationLink2 : relationsHigerLevel) {
                    if (relationLink.contains(relationLink2)) continue;
                    relationLink.add(relationLink2);
                }
            }
        }
        if (relationLink.size() > 0) {
            for (RelationLink relation : relationLink) {
                SpecObject specObjectA = this.findSpecObject(relation.getArtifactA(), reqifcontent);
                SpecObject specObjectB = this.findSpecObject(relation.getArtifactB(), reqifcontent);
                SpecRelation specRelation = ReqIF10Factory.eINSTANCE.createSpecRelation();
                specRelation.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("SpecRelation"));
                specRelation.setLastChange(ReqIFUtil.getGregorianCalendarNow());
                specRelation.setSource(specObjectA);
                specRelation.setTarget(specObjectB);
                List<Object> list = this.typesMap.get("SpecRelationType");
                SpecRelationType specRelationType = list != null ? (SpecRelationType)list.get(0) : this.createSpecRelationType();
                specRelation.setType(specRelationType);
                reqifcontent.getSpecRelations().add((Object)specRelation);
            }
        }
    }

    private SpecRelationType createSpecRelationType() throws DatatypeConfigurationException {
        SpecRelationType specRelationType = ReqIF10Factory.eINSTANCE.createSpecRelationType();
        String uniqueName = UniqueIdentifierGenerator.createUniqueNameWithID("SpecRelationType");
        specRelationType.setIdentifier(uniqueName);
        specRelationType.setLastChange(ReqIFUtil.getGregorianCalendarNow());
        this.addObjectInToMap(specRelationType, "SpecRelationType");
        return specRelationType;
    }

    private SpecObject findSpecObject(Artifact artifactA, ReqIFContent reqifcontent) {
        EList specobjects = reqifcontent.getSpecObjects();
        for (SpecObject specObject : specobjects) {
            EList values = specObject.getValues();
            for (AttributeValue attributeValue : values) {
                AttributeValueString attr;
                if (!(attributeValue instanceof AttributeValueString) || !(attr = (AttributeValueString)attributeValue).getTheValue().equals(artifactA.getName())) continue;
                return specObject;
            }
        }
        return null;
    }

    private void createSpecObjects(ReqIFContent reqifContent) {
        List<Object> list = this.typesMap.get("SpecObject");
        if (list != null) {
            for (Object object : list) {
                if (!(object instanceof SpecObject)) continue;
                SpecObject specObject = (SpecObject)object;
                reqifContent.getSpecObjects().add((Object)specObject);
            }
        }
    }

    private void createDataTypes(ReqIFContent reqifContent) {
        DatatypeDefinitionInteger dataTypeDef;
        List<Object> list = this.typesMap.get("DataTypeDefinitionString");
        if (list != null) {
            for (Object object : list) {
                if (!(object instanceof DatatypeDefinitionString)) continue;
                DatatypeDefinitionString datatypedefString = (DatatypeDefinitionString)object;
                reqifContent.getDatatypes().add((Object)datatypedefString);
            }
        }
        if ((list = this.typesMap.get("DataTypeDefinitionInteger")) != null) {
            for (Object object : list) {
                if (!(object instanceof DatatypeDefinitionInteger)) continue;
                dataTypeDef = (DatatypeDefinitionInteger)object;
                reqifContent.getDatatypes().add((Object)dataTypeDef);
            }
        }
        if ((list = this.typesMap.get("DataTypeDefinitionDate")) != null) {
            for (Object object : list) {
                if (!(object instanceof DatatypeDefinitionDate)) continue;
                dataTypeDef = (DatatypeDefinitionDate)object;
                reqifContent.getDatatypes().add((Object)dataTypeDef);
            }
        }
        if ((list = this.typesMap.get("DataTypeDefinitionBoolean")) != null) {
            for (Object object : list) {
                if (!(object instanceof DatatypeDefinitionBoolean)) continue;
                dataTypeDef = (DatatypeDefinitionBoolean)object;
                reqifContent.getDatatypes().add((Object)dataTypeDef);
            }
        }
        if ((list = this.typesMap.get("DataTypeDefinitionEnumeration")) != null) {
            for (Object object : list) {
                if (!(object instanceof DatatypeDefinitionEnumeration)) continue;
                dataTypeDef = (DatatypeDefinitionEnumeration)object;
                reqifContent.getDatatypes().add((Object)dataTypeDef);
            }
        }
        if ((list = this.typesMap.get("DataTypeDefinitionReal")) != null) {
            for (Object object : list) {
                if (!(object instanceof DatatypeDefinitionReal)) continue;
                dataTypeDef = (DatatypeDefinitionReal)object;
                reqifContent.getDatatypes().add((Object)dataTypeDef);
            }
        }
        if ((list = this.typesMap.get("DataTypeDefinitionXhtml")) != null) {
            for (Object object : list) {
                if (!(object instanceof DatatypeDefinitionXHTML)) continue;
                dataTypeDef = (DatatypeDefinitionXHTML)object;
                reqifContent.getDatatypes().add((Object)dataTypeDef);
            }
        }
    }

    private void createSpecTypes(ReqIFContent reqifContent) {
        List<Object> list = this.typesMap.get("SpecificationType");
        if (list != null) {
            for (Object object : list) {
                if (!(object instanceof SpecificationType)) continue;
                SpecificationType specificationType = (SpecificationType)object;
                reqifContent.getSpecTypes().add((Object)specificationType);
            }
        }
        if ((list = this.typesMap.get("SpecObjectType")) != null) {
            for (Object object : list) {
                if (!(object instanceof SpecObjectType)) continue;
                SpecObjectType specObjectType = (SpecObjectType)object;
                reqifContent.getSpecTypes().add((Object)specObjectType);
            }
        }
        if ((list = this.typesMap.get("SpecRelationType")) != null) {
            for (Object object : list) {
                if (!(object instanceof SpecRelationType)) continue;
                SpecRelationType specRelationType = (SpecRelationType)object;
                reqifContent.getSpecTypes().add((Object)specRelationType);
            }
        }
    }

    private void createSpecification(List<Artifact> artifacts, ReqIFContent reqifContent) throws OseeCoreException, DatatypeConfigurationException {
        for (Artifact artifact : artifacts) {
            Specification specification = ReqIF10Factory.eINSTANCE.createSpecification();
            specification.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("Specification"));
            specification.setLastChange(ReqIFUtil.getGregorianCalendarNow());
            specification.setLongName(artifact.getName());
            List<Object> list = this.typesMap.get("SpecificationType");
            SpecificationType specificationTypeTemp = list != null ? (SpecificationType)list.get(0) : this.createSpeciificationType();
            specification.setType(specificationTypeTemp);
            List requirmentArtifacts = artifact.getChildren();
            for (Artifact reqArtifact : requirmentArtifacts) {
                specification.getChildren().add((Object)this.createSpecHierarchy(reqArtifact));
            }
            reqifContent.getSpecifications().add((Object)specification);
        }
    }

    private SpecHierarchy createSpecHierarchy(Artifact reqArtifact) throws OseeCoreException, DatatypeConfigurationException {
        SpecHierarchy spechierarchy = ReqIF10Factory.eINSTANCE.createSpecHierarchy();
        spechierarchy.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("SpecHierarchy"));
        spechierarchy.setLastChange(ReqIFUtil.getGregorianCalendarNow());
        spechierarchy.setObject(this.createSpecObject(reqArtifact));
        List children = reqArtifact.getChildren();
        if (children.size() > 0) {
            for (Artifact artifact : children) {
                SpecHierarchy spech = this.createSpecHierarchy(artifact);
                spechierarchy.getChildren().add((Object)spech);
            }
        }
        return spechierarchy;
    }

    private SpecObject createSpecObject(Artifact reqArtifact) throws OseeCoreException, DatatypeConfigurationException {
        SpecObject specObject = ReqIF10Factory.eINSTANCE.createSpecObject();
        specObject.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("SpecObject"));
        specObject.setLastChange(ReqIFUtil.getGregorianCalendarNow());
        SpecObjectType specObjectType = null;
        List<Object> list = this.typesMap.get("SpecObjectType");
        specObjectType = list == null ? this.createSpecObjectType() : (SpecObjectType)list.get(0);
        specObject.setType(specObjectType);
        specObject.getValues().add((Object)this.createAttributeValueString(reqArtifact, specObjectType));
        specObject.getValues().add((Object)this.createAttributeValueXhtml(specObjectType));
        List attributes = reqArtifact.getAttributes((AttributeTypeId)CoreAttributeTypes.WordTemplateContent);
        if (attributes.size() > 0) {
            Attribute attribute = (Attribute)attributes.get(0);
            attribute.getValue();
            EList values = specObject.getValues();
            for (AttributeValue attributeValue : values) {
                if (!(attributeValue instanceof AttributeValueXHTML)) continue;
                AttributeValueXHTML attr = (AttributeValueXHTML)attributeValue;
                try {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try {
                        CustomisedXmlTextInputStream inputStream = new CustomisedXmlTextInputStream(attribute.getValue().toString(), (XhtmlDivType)attr.getTheValue().getXhtml());
                        try {
                            try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");){
                                char[] chars = new char[16000];
                                reader.read(chars);
                            }
                            if (inputStream == null) continue;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.addObjectInToMap(specObject, "SpecObject");
        return specObject;
    }

    private AttributeValueXHTML createAttributeValueXhtml(SpecObjectType specObjectType) {
        AttributeValueXHTML attributeValueXhmtl = ReqIF10Factory.eINSTANCE.createAttributeValueXHTML();
        EList specAttributes = specObjectType.getSpecAttributes();
        for (AttributeDefinition attributeDefinition : specAttributes) {
            if (!(attributeDefinition instanceof AttributeDefinitionXHTML)) continue;
            AttributeDefinitionXHTML attr = (AttributeDefinitionXHTML)attributeDefinition;
            attributeValueXhmtl.setDefinition(attr);
            break;
        }
        XhtmlContent xhtmlContent = ReqIF10Factory.eINSTANCE.createXhtmlContent();
        XhtmlDivType xhmtlDivType = XhtmlFactory.eINSTANCE.createXhtmlDivType();
        xhtmlContent.setXhtml((EObject)xhmtlDivType);
        attributeValueXhmtl.setTheValue(xhtmlContent);
        return attributeValueXhmtl;
    }

    private AttributeValueString createAttributeValueString(Artifact reqArtifact, SpecObjectType specObjectType) {
        AttributeValueString attributeValueString = ReqIF10Factory.eINSTANCE.createAttributeValueString();
        EList specAttributes = specObjectType.getSpecAttributes();
        for (AttributeDefinition attributeDefinition : specAttributes) {
            if (!(attributeDefinition instanceof AttributeDefinitionString)) continue;
            AttributeDefinitionString attr = (AttributeDefinitionString)attributeDefinition;
            attributeValueString.setDefinition(attr);
            break;
        }
        attributeValueString.setTheValue(reqArtifact.getName());
        return attributeValueString;
    }

    private SpecObjectType createSpecObjectType() throws DatatypeConfigurationException {
        SpecObjectType specObjectType = ReqIF10Factory.eINSTANCE.createSpecObjectType();
        specObjectType.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("SpecObjectType"));
        specObjectType.setLastChange(ReqIFUtil.getGregorianCalendarNow());
        specObjectType.getSpecAttributes().add((Object)this.createAttributeDefinitionString());
        specObjectType.getSpecAttributes().add((Object)this.createAttributeDefinitionXHTML());
        this.addObjectInToMap(specObjectType, "SpecObjectType");
        return specObjectType;
    }

    private SpecificationType createSpeciificationType() throws DatatypeConfigurationException {
        SpecificationType specificationType = ReqIF10Factory.eINSTANCE.createSpecificationType();
        String uniqueName = UniqueIdentifierGenerator.createUniqueNameWithID("SpecificationType");
        specificationType.setIdentifier(uniqueName);
        specificationType.setLastChange(ReqIFUtil.getGregorianCalendarNow());
        specificationType.setLongName("Specification Type");
        specificationType.getSpecAttributes().add((Object)this.createAttributeDefinitionString());
        this.addObjectInToMap(specificationType, "SpecificationType");
        return specificationType;
    }

    private AttributeDefinitionString createAttributeDefinitionString() throws DatatypeConfigurationException {
        AttributeDefinitionString attributeDefiniitonString = ReqIF10Factory.eINSTANCE.createAttributeDefinitionString();
        attributeDefiniitonString.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("AttributeDefinitionString"));
        attributeDefiniitonString.setLongName("Description");
        attributeDefiniitonString.setLastChange(ReqIFUtil.getGregorianCalendarNow());
        attributeDefiniitonString.setType(this.createDataTypeString());
        return attributeDefiniitonString;
    }

    private AttributeDefinitionXHTML createAttributeDefinitionXHTML() throws DatatypeConfigurationException {
        AttributeDefinitionXHTML attrDefXhmtl = ReqIF10Factory.eINSTANCE.createAttributeDefinitionXHTML();
        attrDefXhmtl.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("AttributeDefiniitonXHTML"));
        attrDefXhmtl.setLastChange(ReqIFUtil.getGregorianCalendarNow());
        attrDefXhmtl.setLongName("Content");
        attrDefXhmtl.setType(this.createDataTypeXhtml());
        return attrDefXhmtl;
    }

    private DatatypeDefinitionXHTML createDataTypeXhtml() throws DatatypeConfigurationException {
        DatatypeDefinitionXHTML dataTypeDefXhmtl = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionXHTML();
        dataTypeDefXhmtl.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("DataTypeDefinitionXhtml"));
        dataTypeDefXhmtl.setLastChange(ReqIFUtil.getGregorianCalendarNow());
        this.addObjectInToMap(dataTypeDefXhmtl, "DataTypeDefinitionXhtml");
        return dataTypeDefXhmtl;
    }

    private DatatypeDefinitionString createDataTypeString() throws DatatypeConfigurationException {
        DatatypeDefinitionString dataTypeString = ReqIF10Factory.eINSTANCE.createDatatypeDefinitionString();
        dataTypeString.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("DataTypeDefinitionString"));
        dataTypeString.setLastChange(ReqIFUtil.getGregorianCalendarNow());
        dataTypeString.setMaxLength(new BigInteger("320000"));
        this.addObjectInToMap(dataTypeString, "DataTypeDefinitionString");
        return dataTypeString;
    }

    private ReqIFHeader createReqIFHeader() throws DatatypeConfigurationException {
        ReqIFHeader header = ReqIF10Factory.eINSTANCE.createReqIFHeader();
        header.setComment("Created by :" + System.getProperty("user.name"));
        header.setIdentifier(UniqueIdentifierGenerator.createUniqueNameWithID("Header"));
        header.setRepositoryId("Repository Id");
        header.setReqIFVersion("1.0.1");
        header.setSourceToolId("ICTEAM");
        header.setReqIFToolId("ICTEAM");
        header.setCreationTime(ReqIFUtil.getGregorianCalendarNow());
        header.setTitle("ReqIF File generated by ICTEAM");
        return header;
    }

    public void addObjectInToMap(Object obj, String string) {
        List<Object> list = this.typesMap.get(string);
        if (list == null) {
            list = new ArrayList<Object>();
            list.add(obj);
            this.typesMap.put(string, list);
        } else {
            list.add(obj);
        }
    }
}

